/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.traverser;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.model.api.SwLeafElement;
import com.intellij.swagger.core.model.specification.SwStringLeafElement;
import com.intellij.swagger.core.model.specification.SwStringLeafElementKt;
import com.intellij.swagger.core.reference.SwaggerElementPatternsKt;
import com.intellij.swagger.core.reference.definitions.SwObjectDefinitionResolverKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ3\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\fJ;\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\bH&J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H&J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H&J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH&J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0016J\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H&J\u0012\u0010\u001e\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010\u001f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010 \u001a\u0004\u0018\u00010\bH\u0002J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\"H\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/swagger/core/traverser/SpecificationTraverser;", "", "()V", "findByPath", "Lcom/intellij/psi/PsiElement;", "root", "path", "", "", "(Lcom/intellij/psi/PsiElement;[Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "findByPathAndExpand", "Lkotlin/sequences/Sequence;", "(Lcom/intellij/psi/PsiElement;[Ljava/lang/String;)Lkotlin/sequences/Sequence;", "findByPathAndGetContentText", "Lcom/intellij/swagger/core/model/api/SwLeafElement;", "readValueName", "", "(Lcom/intellij/psi/PsiElement;Z[Ljava/lang/String;)Lcom/intellij/swagger/core/model/api/SwLeafElement;", "getChildValueByKeyName", "node", "name", "getFullElementPath", "getNameOr", "value", "getParent", "getTopLevelValueOf", "psiFile", "Lcom/intellij/psi/PsiFile;", "getValueIfKeyValue", "getValuesAsSequenceFrom", "isReferenceNode", "resolveRefOrContinue", "pathItemOrNull", "skipFirstItem", "", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSpecificationTraverserFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecificationTraverserFactory.kt\ncom/intellij/swagger/core/traverser/SpecificationTraverser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public abstract class SpecificationTraverser {
    @Nullable
    public final PsiElement findByPath(@Nullable PsiElement root, String ... path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        PsiElement rootNamedElement = root instanceof PsiFile ? this.getTopLevelValueOf((PsiFile)root) : root;
        return SpecificationTraverser.findByPath$findByPathFromTreeNode(this, rootNamedElement, ArraysKt.filterNotNull((Object[])path));
    }

    @NotNull
    public final Sequence<PsiElement> findByPathAndExpand(@Nullable PsiElement root, String ... path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.getValuesAsSequenceFrom(this.findByPath(root, Arrays.copyOf(path, path.length)));
    }

    @NotNull
    public final SwLeafElement<String> findByPathAndGetContentText(@Nullable PsiElement root, boolean readValueName, String ... path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        PsiElement psiElement = this.findByPath(root, Arrays.copyOf(path, path.length));
        PsiElement namedElement = readValueName ? this.getValueIfKeyValue(psiElement) : psiElement;
        return this.getNameOr(namedElement, null);
    }

    private final List<String> skipFirstItem(List<String> path) {
        return SequencesKt.toList((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)path), (int)1));
    }

    @NotNull
    public SwLeafElement<String> getNameOr(@Nullable PsiElement node, @Nullable String value) {
        SwStringLeafElement swStringLeafElement;
        String string;
        String string2;
        if (node instanceof PsiNamedElement) {
            string2 = ((PsiNamedElement)node).getName();
            if (string2 == null) {
                string2 = SwaggerBundle.message("not.specified", new Object[0]);
            }
        } else {
            string2 = value;
        }
        return (string = string2) != null && (swStringLeafElement = SwStringLeafElementKt.wrapToLeafElement(string, node)) != null ? (SwLeafElement)swStringLeafElement : (SwLeafElement)SwStringLeafElement.Companion.getEMPTY();
    }

    private final PsiElement resolveRefOrContinue(PsiElement node, String pathItemOrNull) {
        PsiElement theOnlyChild;
        if (!Registry.is((String)"openapi.traversal.resolve.enable")) {
            return node;
        }
        if (pathItemOrNull == null || Intrinsics.areEqual((Object)pathItemOrNull, (Object)"$ref")) {
            return node;
        }
        PsiElement psiElement = (PsiElement)SequencesKt.singleOrNull(this.getValuesAsSequenceFrom(node));
        if (psiElement != null) {
            PsiElement p0 = psiElement;
            boolean bl = false;
            v1 = this.getValueIfKeyValue(p0);
        } else {
            v1 = theOnlyChild = null;
        }
        if (theOnlyChild == null || !this.isReferenceNode(theOnlyChild)) {
            return node;
        }
        return SwObjectDefinitionResolverKt.resolveDefinition(theOnlyChild);
    }

    private final boolean isReferenceNode(PsiElement node) {
        return SwaggerElementPatternsKt.getReferenceValue().accepts((Object)node);
    }

    @Nullable
    public abstract String getFullElementPath(@Nullable PsiElement var1);

    @Nullable
    public abstract PsiElement getParent(@Nullable PsiElement var1);

    @Nullable
    public abstract PsiElement getTopLevelValueOf(@Nullable PsiFile var1);

    @Nullable
    public abstract PsiElement getChildValueByKeyName(@Nullable PsiElement var1, @NotNull String var2);

    @NotNull
    public abstract Sequence<PsiElement> getValuesAsSequenceFrom(@Nullable PsiElement var1);

    @Nullable
    public PsiElement getValueIfKeyValue(@Nullable PsiElement node) {
        return node;
    }

    private static final PsiElement findByPath$findByPathFromTreeNode(SpecificationTraverser this$0, PsiElement node, List<String> path) {
        while (true) {
            ProgressManager.checkCanceled();
            PsiElement effectiveNodeToTraverse = this$0.resolveRefOrContinue(node, (String)CollectionsKt.firstOrNull(path));
            if (path.isEmpty()) {
                return effectiveNodeToTraverse;
            }
            PsiElement rightHandExpression = this$0.getValueIfKeyValue(effectiveNodeToTraverse);
            PsiElement namedChild = this$0.getChildValueByKeyName(rightHandExpression, (String)CollectionsKt.first(path));
            List<String> list = this$0.skipFirstItem(path);
            node = namedChild;
            path = list;
        }
    }
}

