/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.reference.definitions;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntheticElement;
import com.intellij.swagger.core.model.SwObjectDefinitionUtilsKt;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.providers.resolve.SpecificationResolveHelperKt;
import com.intellij.swagger.core.reference.definitions.SwCoordinateItem;
import com.intellij.swagger.core.reference.definitions.SwObjectCoordinates;
import com.intellij.swagger.core.reference.definitions.SwObjectDefinitionReferenceKt;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\tH\u0000\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\r"}, d2={"buildUriItem", "Lcom/intellij/swagger/core/reference/definitions/SwCoordinateItem;", "rawValue", "", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "parseObjectCoordinates", "Lcom/intellij/swagger/core/reference/definitions/SwObjectCoordinates;", "psiElement", "Lcom/intellij/psi/PsiElement;", "valueRangeInElement", "resolveDefinition", "element", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwObjectDefinitionResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwObjectDefinitionResolver.kt\ncom/intellij/swagger/core/reference/definitions/SwObjectDefinitionResolverKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 SwTreeUtil.kt\ncom/intellij/swagger/core/traverser/SwTreeUtil\n*L\n1#1,75:1\n1#2:76\n26#3:77\n35#4,2:78\n*S KotlinDebug\n*F\n+ 1 SwObjectDefinitionResolver.kt\ncom/intellij/swagger/core/reference/definitions/SwObjectDefinitionResolverKt\n*L\n38#1:77\n40#1:78,2\n*E\n"})
public final class SwObjectDefinitionResolverKt {
    @Nullable
    public static final PsiElement resolveDefinition(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        return SwObjectDefinitionResolverKt.resolveDefinition(element, textRange);
    }

    @Nullable
    public static final PsiElement resolveDefinition(@NotNull PsiElement element, @NotNull TextRange rangeInElement) {
        PsiElement psiElement;
        block12: {
            block16: {
                String[] definitionCoordinates;
                String[] stringArray;
                PsiFile targetPsiFile;
                block18: {
                    block17: {
                        SwObjectCoordinates coordinates;
                        block13: {
                            block15: {
                                block14: {
                                    block11: {
                                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                        Intrinsics.checkNotNullParameter((Object)rangeInElement, (String)"rangeInElement");
                                        String string = element.getText();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                        coordinates = SwObjectDefinitionResolverKt.parseObjectCoordinates(string, rangeInElement);
                                        if (!coordinates.isEmpty()) break block11;
                                        psiElement = null;
                                        break block12;
                                    }
                                    if (!coordinates.isWebCoordinates()) break block13;
                                    String string = coordinates.getUriValue();
                                    if (string == null) {
                                        string = "";
                                    }
                                    Url url2 = Urls.parse((String)string, (boolean)false);
                                    if (url2 == null) {
                                        return null;
                                    }
                                    Url url3 = url2;
                                    CharSequence charSequence = url3.getAuthority();
                                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block14;
                                    String string2 = url3.getPath();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                                    if (!StringsKt.isBlank((CharSequence)string2)) break block15;
                                }
                                return null;
                            }
                            psiElement = (PsiElement)new SyntheticElement(element, coordinates){
                                final /* synthetic */ PsiElement $element;
                                final /* synthetic */ SwObjectCoordinates $coordinates;
                                {
                                    this.$element = $element;
                                    this.$coordinates = $coordinates;
                                }

                                @NotNull
                                public PsiElement getParent() {
                                    return this.$element;
                                }

                                public void navigate(boolean requestFocus) {
                                    if (requestFocus) {
                                        String string = this.$coordinates.getUriValue();
                                        if (string == null) {
                                            string = "";
                                        }
                                        BrowserUtil.browse((String)string);
                                    }
                                }
                            };
                            break block12;
                        }
                        CharSequence url3 = coordinates.getUriValue();
                        if (url3 == null || StringsKt.isBlank((CharSequence)url3)) break block16;
                        PsiFile psiFile2 = element.getContainingFile().getOriginalFile();
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
                        PsiFile psiFile3 = SwObjectDefinitionReferenceKt.findStorageFile(psiFile2, coordinates.getUriValue());
                        if (psiFile3 == null) {
                            return null;
                        }
                        targetPsiFile = psiFile3;
                        stringArray = coordinates.getDefinitionCoordinates();
                        if (stringArray == null) break block17;
                        String[] it = stringArray;
                        boolean bl = false;
                        String[] stringArray2 = SwObjectDefinitionUtilsKt.getDefinitionCoordinates((String)it);
                        stringArray = stringArray2;
                        if (stringArray2 != null) break block18;
                    }
                    boolean $i$f$emptyArray = false;
                    stringArray = new String[]{};
                }
                if ((definitionCoordinates = stringArray).length == 0) {
                    return (PsiElement)targetPsiFile;
                }
                SwTreeUtil $this$iv = SwTreeUtil.INSTANCE;
                boolean withSelf$iv = true;
                boolean $i$f$getParentOfType = false;
                SwSpecificationFile swSpecificationFile = $this$iv.getParentOfType((PsiElement)targetPsiFile, SwSpecificationFile.class, withSelf$iv);
                if (swSpecificationFile == null) {
                    return null;
                }
                SwSpecificationFile specification = swSpecificationFile;
                return specification.find(Arrays.copyOf(definitionCoordinates, definitionCoordinates.length));
            }
            String string = rangeInElement.substring(element.getText());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String[] objectName = SwObjectDefinitionUtilsKt.getDefinitionCoordinates(string);
            PsiFile psiFile4 = element.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile4, (String)"getContainingFile(...)");
            psiElement = SpecificationResolveHelperKt.resolveLocalObject(psiFile4, Arrays.copyOf(objectName, objectName.length));
        }
        return psiElement;
    }

    @NotNull
    public static final SwObjectCoordinates parseObjectCoordinates(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        String string = psiElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        return SwObjectDefinitionResolverKt.parseObjectCoordinates(string, textRange);
    }

    @NotNull
    public static final SwObjectCoordinates parseObjectCoordinates(@NotNull String rawValue, @NotNull TextRange valueRangeInElement) {
        TextRange textRange;
        TextRange pathOrUrlRange;
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        Intrinsics.checkNotNullParameter((Object)valueRangeInElement, (String)"valueRangeInElement");
        int objectDefinitionCoordinatesIndex = StringsKt.indexOf$default((CharSequence)rawValue, (String)"#/", (int)0, (boolean)false, (int)6, null);
        if (objectDefinitionCoordinatesIndex == -1) {
            return new SwObjectCoordinates(SwObjectDefinitionResolverKt.buildUriItem(rawValue, valueRangeInElement), null, 2, null);
        }
        TextRange textRange2 = TextRange.create((int)0, (int)objectDefinitionCoordinatesIndex).intersection(valueRangeInElement);
        if (textRange2 == null) {
            textRange2 = pathOrUrlRange = TextRange.EMPTY_RANGE;
        }
        if ((textRange = TextRange.create((int)objectDefinitionCoordinatesIndex, (int)StringsKt.getLastIndex((CharSequence)rawValue)).intersection(valueRangeInElement)) == null) {
            textRange = TextRange.EMPTY_RANGE;
        }
        TextRange definitionRange = textRange;
        Intrinsics.checkNotNull((Object)pathOrUrlRange);
        SwCoordinateItem swCoordinateItem = SwObjectDefinitionResolverKt.buildUriItem(rawValue, pathOrUrlRange);
        String string = definitionRange.substring(rawValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Intrinsics.checkNotNull((Object)definitionRange);
        return new SwObjectCoordinates(swCoordinateItem, new SwCoordinateItem.SwDefinitionItem(string, definitionRange));
    }

    private static final SwCoordinateItem buildUriItem(String rawValue, TextRange rangeInElement) {
        SwCoordinateItem swCoordinateItem;
        if (Urls.parse((String)rawValue, (boolean)false) != null) {
            String string = rangeInElement.substring(rawValue);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            swCoordinateItem = new SwCoordinateItem.SwWebUrlItem(string, rangeInElement);
        } else {
            String string = rangeInElement.substring(rawValue);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            swCoordinateItem = new SwCoordinateItem.SwLocalPathItem(string, rangeInElement);
        }
        return swCoordinateItem;
    }
}

