/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.reference.definitions;

import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.swagger.core.reference.definitions.SwObjectDefinitionResolverKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\tH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/swagger/core/reference/definitions/SwObjectDefinitionReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/highlighting/HighlightedReference;", "element", "(Lcom/intellij/psi/PsiElement;)V", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getText", "", "handleElementRename", "newElementName", "resolve", "intellij.swagger.core"})
public final class SwObjectDefinitionReference
extends PsiReferenceBase<PsiElement>
implements HighlightedReference {
    public SwObjectDefinitionReference(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)this.getElement());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        return textRange;
    }

    private final String getText() {
        String string = this.getRangeInElement().substring(this.getElement().getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        return SwObjectDefinitionResolverKt.resolveDefinition(psiElement, this.getRangeInElement());
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        String string = StringUtil.unquoteString((String)this.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
        String unquotedValue = string;
        int locationEndIndex = StringsKt.lastIndexOf$default((CharSequence)unquotedValue, (String)"/", (int)0, (boolean)false, (int)6, null) + 1;
        String string2 = unquotedValue.substring(0, locationEndIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String prefix = string2;
        PsiElement psiElement = super.handleElementRename(prefix + newElementName);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"handleElementRename(...)");
        return psiElement;
    }
}

