/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.reference.definitions;

import com.intellij.swagger.core.reference.definitions.SwCoordinateItem;
import com.intellij.swagger.core.reference.definitions.SwDefinitionReferenceBuilderKt;
import com.intellij.util.PathUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0018\u001a\u00020\u0014J\u0006\u0010\u0019\u001a\u00020\u0014R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/swagger/core/reference/definitions/SwObjectCoordinates;", "", "objectsStorageUri", "Lcom/intellij/swagger/core/reference/definitions/SwCoordinateItem;", "objectDefinition", "Lcom/intellij/swagger/core/reference/definitions/SwCoordinateItem$SwDefinitionItem;", "(Lcom/intellij/swagger/core/reference/definitions/SwCoordinateItem;Lcom/intellij/swagger/core/reference/definitions/SwCoordinateItem$SwDefinitionItem;)V", "definitionCoordinates", "", "getDefinitionCoordinates", "()Ljava/lang/String;", "uriValue", "getUriValue", "computeCompletedDefinitionSegment", "caretOffsetInElement", "", "computeCompletedStorageUriSegment", "Lkotlin/Pair;", "getIndexOfCharBeforeCaret", "hasCompletedRelativePath", "", "isEmpty", "isLocalPathCoordinates", "isStorageEdited", "isWebCoordinates", "referencesEntireFile", "intellij.swagger.core"})
public final class SwObjectCoordinates {
    @Nullable
    private final SwCoordinateItem objectsStorageUri;
    @Nullable
    private final SwCoordinateItem.SwDefinitionItem objectDefinition;

    public SwObjectCoordinates(@Nullable SwCoordinateItem objectsStorageUri, @Nullable SwCoordinateItem.SwDefinitionItem objectDefinition) {
        this.objectsStorageUri = objectsStorageUri;
        this.objectDefinition = objectDefinition;
    }

    public /* synthetic */ SwObjectCoordinates(SwCoordinateItem swCoordinateItem, SwCoordinateItem.SwDefinitionItem swDefinitionItem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            swCoordinateItem = null;
        }
        if ((n & 2) != 0) {
            swDefinitionItem = null;
        }
        this(swCoordinateItem, swDefinitionItem);
    }

    @Nullable
    public final String getUriValue() {
        SwCoordinateItem swCoordinateItem = this.objectsStorageUri;
        return swCoordinateItem != null ? swCoordinateItem.getValue() : null;
    }

    @Nullable
    public final String getDefinitionCoordinates() {
        SwCoordinateItem.SwDefinitionItem swDefinitionItem = this.objectDefinition;
        return swDefinitionItem != null ? swDefinitionItem.getValue() : null;
    }

    public final boolean isEmpty() {
        return SwDefinitionReferenceBuilderKt.isNullOrEmpty(this.objectsStorageUri) && SwDefinitionReferenceBuilderKt.isNullOrEmpty(this.objectDefinition);
    }

    public final boolean isWebCoordinates() {
        return this.objectsStorageUri instanceof SwCoordinateItem.SwWebUrlItem;
    }

    public final boolean isLocalPathCoordinates() {
        return this.objectsStorageUri instanceof SwCoordinateItem.SwLocalPathItem;
    }

    public final boolean referencesEntireFile() {
        CharSequence charSequence;
        return this.isLocalPathCoordinates() && !((charSequence = (CharSequence)this.getUriValue()) == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)this.getDefinitionCoordinates()) == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    public final boolean isStorageEdited(int caretOffsetInElement) {
        boolean isCaretInUriRange;
        SwCoordinateItem swCoordinateItem = this.objectsStorageUri;
        boolean bl = swCoordinateItem != null && (swCoordinateItem = swCoordinateItem.getRangeInElement()) != null ? swCoordinateItem.contains(Math.max(0, this.getIndexOfCharBeforeCaret(caretOffsetInElement))) : (isCaretInUriRange = false);
        if (!isCaretInUriRange) {
            return false;
        }
        return !this.hasCompletedRelativePath(caretOffsetInElement);
    }

    @Nullable
    public final Pair<String, String> computeCompletedStorageUriSegment(int caretOffsetInElement) {
        Pair pair;
        if (this.objectsStorageUri == null) {
            return null;
        }
        int caretOffsetInValue = Math.min(this.objectsStorageUri.getValue().length(), caretOffsetInElement);
        String string = this.objectsStorageUri.getValue().substring(0, caretOffsetInValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String substringBeforeCaret = string;
        CharSequence charSequence = PathUtil.getFileExtension((String)substringBeforeCaret);
        if (!(charSequence == null || charSequence.length() == 0)) {
            return TuplesKt.to((Object)substringBeforeCaret, (Object)"");
        }
        int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)substringBeforeCaret, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (lastSlashIndex == -1) {
            pair = TuplesKt.to((Object)substringBeforeCaret, (Object)"");
        } else {
            String string2 = substringBeforeCaret.substring(0, lastSlashIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String completeSegment = string2;
            String string3 = substringBeforeCaret.substring(lastSlashIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String incompleteSegment = string3;
            pair = TuplesKt.to((Object)completeSegment, (Object)incompleteSegment);
        }
        return pair;
    }

    @Nullable
    public final String computeCompletedDefinitionSegment(int caretOffsetInElement) {
        String string;
        if (this.objectDefinition == null) {
            return null;
        }
        int referenceRootIndex = StringsKt.indexOf$default((CharSequence)this.objectDefinition.getValue(), (String)"#/", (int)0, (boolean)false, (int)6, null);
        int definitionSegmentStart = referenceRootIndex == -1 ? 0 : referenceRootIndex + 2;
        int n = this.getIndexOfCharBeforeCaret(caretOffsetInElement);
        SwCoordinateItem swCoordinateItem = this.objectsStorageUri;
        String string2 = swCoordinateItem != null ? swCoordinateItem.getValue() : null;
        if (string2 == null) {
            string2 = "";
        }
        int n2 = n - string2.length();
        int n3 = 0;
        int relativeCaretOffsetInDefinition = Math.max(n2, n3);
        int caretOffsetInValue = Math.min(this.objectDefinition.getValue().length(), relativeCaretOffsetInDefinition);
        if (caretOffsetInValue >= definitionSegmentStart) {
            String string3 = this.objectDefinition.getValue().substring(definitionSegmentStart, caretOffsetInValue);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = null;
        }
        return string;
    }

    private final boolean hasCompletedRelativePath(int caretOffsetInElement) {
        String completedPathSegment;
        CharSequence charSequence;
        Pair<String, String> pair = this.computeCompletedStorageUriSegment(caretOffsetInElement);
        String string = pair != null ? (String)pair.getFirst() : null;
        if (string == null) {
            string = "";
        }
        return !((charSequence = (CharSequence)PathUtil.getFileExtension((String)(completedPathSegment = string))) == null || charSequence.length() == 0);
    }

    private final int getIndexOfCharBeforeCaret(int caretOffsetInElement) {
        return caretOffsetInElement - 1;
    }

    public SwObjectCoordinates() {
        this(null, null, 3, null);
    }
}

