/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.providers.resolve;

import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.psi.PsiElement;
import com.intellij.swagger.core.documentation.SwUrlFakeElement;
import com.intellij.swagger.core.model.api.SwParameter;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.providers.resolve.SwTargetInfo;
import com.intellij.swagger.core.providers.resolve.SwUrlTargetInfo;
import com.intellij.swagger.core.providers.resolve.SwUrlTargetUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\u001a\u001a\u0004\u0018\u00010\rH\u0016R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/intellij/swagger/core/providers/resolve/SwUrlTargetInfo;", "Lcom/intellij/swagger/core/providers/resolve/SwTargetInfo;", "Lcom/intellij/swagger/core/model/api/SwUrl;", "modelElement", "path", "Lcom/intellij/microservices/url/UrlPath;", "schemes", "", "", "authorities", "Lcom/intellij/microservices/url/Authority;", "(Lcom/intellij/swagger/core/model/api/SwUrl;Lcom/intellij/microservices/url/UrlPath;Ljava/util/List;Ljava/util/List;)V", "documentationPsiElement", "Lcom/intellij/psi/PsiElement;", "getDocumentationPsiElement", "()Lcom/intellij/psi/PsiElement;", "isDeprecated", "", "()Z", "parameters", "Lkotlin/sequences/Sequence;", "Lcom/intellij/swagger/core/model/api/SwParameter;", "getParameters", "()Lkotlin/sequences/Sequence;", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "resolveToPsiElement", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwUrlTargetUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwUrlTargetUtils.kt\ncom/intellij/swagger/core/providers/resolve/SwUrlTargetInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n1#2:185\n*E\n"})
public final class SwUrlTargetInfo
extends SwTargetInfo<SwUrl> {
    @NotNull
    private final UrlPath path;

    public SwUrlTargetInfo(@NotNull SwUrl modelElement, @NotNull UrlPath path, @NotNull List<String> schemes2, @NotNull List<? extends Authority> authorities2) {
        Intrinsics.checkNotNullParameter((Object)modelElement, (String)"modelElement");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(schemes2, (String)"schemes");
        Intrinsics.checkNotNullParameter(authorities2, (String)"authorities");
        super(modelElement, schemes2, authorities2, SwUrlTargetUtilsKt.httpMethodUppercase(modelElement), false, 16, null);
        this.path = path;
    }

    @NotNull
    public UrlPath getPath() {
        return this.path;
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        return ((SwUrl)this.getModelElement()).getSourcePsi();
    }

    public boolean isDeprecated() {
        return false;
    }

    @Nullable
    public PsiElement getDocumentationPsiElement() {
        SwUrlFakeElement swUrlFakeElement;
        PsiElement psiElement = ((SwUrl)this.getModelElement()).getSourcePsi();
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            swUrlFakeElement = new SwUrlFakeElement(it, ((SwUrl)this.getModelElement()).getUrlString());
        } else {
            swUrlFakeElement = null;
        }
        return (PsiElement)swUrlFakeElement;
    }

    @Override
    @NotNull
    public Sequence<SwParameter> getParameters() {
        return SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)((SwUrl)this.getModelElement()).getSupportedOperations()), (Function1)parameters.1.INSTANCE);
    }
}

