/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.providers.resolve;

import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.core.model.SwaggerMergedModel;
import com.intellij.swagger.core.model.api.SwMetaHolder;
import com.intellij.swagger.core.model.api.SwModelBase;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.providers.resolve.SpecificationResolveHelperKt;
import com.intellij.swagger.core.providers.resolve.SwUrlPathSpecification;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a+\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0000\u00a2\u0006\u0002\u0010\u000e\u001a\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a8\u0006\u0013"}, d2={"resolveBasePath", "Lkotlin/sequences/Sequence;", "Lcom/intellij/swagger/core/model/api/SwUrl;", "searchedUrl", "Lcom/intellij/microservices/url/UrlPath;", "specificationModel", "Lcom/intellij/swagger/core/model/api/SwModelBase;", "resolveLocalObject", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "path", "", "", "(Lcom/intellij/psi/PsiFile;[Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "resolveOrdinaryUrl", "resolveUrl", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSpecificationResolveHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecificationResolveHelper.kt\ncom/intellij/swagger/core/providers/resolve/SpecificationResolveHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class SpecificationResolveHelperKt {
    @NotNull
    public static final Sequence<SwUrl> resolveUrl(@NotNull UrlPath searchedUrl, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)searchedUrl, (String)"searchedUrl");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Project project = scope.getProject();
        if (project == null) {
            return SequencesKt.emptySequence();
        }
        Project project2 = project;
        return SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)SwaggerMergedModel.Companion.getInstance(project2).getBaseModelElements(scope)), (Function1)((Function1)new Function1<SwModelBase, SwModelBase>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            @NotNull
            public final SwModelBase invoke(@NotNull SwModelBase it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.substitute(this.$project);
            }
        })), (Function1)((Function1)new Function1<SwModelBase, Sequence<? extends SwUrl>>(searchedUrl){
            final /* synthetic */ UrlPath $searchedUrl;
            {
                this.$searchedUrl = $searchedUrl;
                super(1);
            }

            @NotNull
            public final Sequence<SwUrl> invoke(@NotNull SwModelBase specification) {
                Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
                return SequencesKt.plus((Sequence)SpecificationResolveHelperKt.access$resolveBasePath(this.$searchedUrl, specification), (Sequence)SpecificationResolveHelperKt.access$resolveOrdinaryUrl(this.$searchedUrl, specification));
            }
        }));
    }

    private static final Sequence<SwUrl> resolveBasePath(UrlPath searchedUrl, SwModelBase specificationModel) {
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)specificationModel.getBasePaths()), (Function1)((Function1)new Function1<SwUrl, Boolean>(searchedUrl){
            final /* synthetic */ UrlPath $searchedUrl;
            {
                this.$searchedUrl = $searchedUrl;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SwUrl basePath2) {
                Intrinsics.checkNotNullParameter((Object)basePath2, (String)"basePath");
                return SwUrlPathSpecification.INSTANCE.parsePath(basePath2.getUrlString()).isCompatibleWith(this.$searchedUrl);
            }
        }));
    }

    private static final Sequence<SwUrl> resolveOrdinaryUrl(UrlPath searchedUrl, SwModelBase specificationModel) {
        int searchedUrlSegmentsCount = searchedUrl.getSegments().size();
        List searchedUrlsWithTrimmedBasePaths2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)specificationModel.getBasePaths()), (Function1)((Function1)resolveOrdinaryUrl.searchedUrlsWithTrimmedBasePaths.1.INSTANCE))), (Function1)resolveOrdinaryUrl.searchedUrlsWithTrimmedBasePaths.2.INSTANCE), (Function1)((Function1)new Function1<UrlPath, Boolean>(searchedUrl){
            final /* synthetic */ UrlPath $searchedUrl;
            {
                this.$searchedUrl = $searchedUrl;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull UrlPath parsedBasePath) {
                Intrinsics.checkNotNullParameter((Object)parsedBasePath, (String)"parsedBasePath");
                return parsedBasePath.canBePrefixFor(this.$searchedUrl);
            }
        })), (Function1)((Function1)new Function1<UrlPath, UrlPath>(searchedUrlSegmentsCount, searchedUrl){
            final /* synthetic */ int $searchedUrlSegmentsCount;
            final /* synthetic */ UrlPath $searchedUrl;
            {
                this.$searchedUrlSegmentsCount = $searchedUrlSegmentsCount;
                this.$searchedUrl = $searchedUrl;
                super(1);
            }

            @Nullable
            public final UrlPath invoke(@NotNull UrlPath basePathPrefix) {
                Intrinsics.checkNotNullParameter((Object)basePathPrefix, (String)"basePathPrefix");
                int basePathSegmentsCount = basePathPrefix.getSegments().size();
                return basePathSegmentsCount >= this.$searchedUrlSegmentsCount ? null : new UrlPath(CollectionsKt.drop((Iterable)this.$searchedUrl.getSegments(), (int)basePathSegmentsCount));
            }
        })));
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)specificationModel.getUrls()), (Function1)((Function1)new Function1<SwUrl, Boolean>((List<UrlPath>)searchedUrlsWithTrimmedBasePaths2){
            final /* synthetic */ List<UrlPath> $searchedUrlsWithTrimmedBasePaths;
            {
                this.$searchedUrlsWithTrimmedBasePaths = $searchedUrlsWithTrimmedBasePaths;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SwUrl urlFromSpecification) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)urlFromSpecification, (String)"urlFromSpecification");
                    Iterable $this$any$iv = this.$searchedUrlsWithTrimmedBasePaths;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            UrlPath it = (UrlPath)element$iv;
                            boolean bl2 = false;
                            if (!SwUrlPathSpecification.INSTANCE.parsePath(urlFromSpecification.getUrlString()).isCompatibleWith(it)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
    }

    @Nullable
    public static final PsiElement resolveLocalObject(@NotNull PsiFile psiFile2, String ... path) {
        SwModelElement cachedOrNewSpec;
        SwModelElement swModelElement;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Project project = psiFile2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                SwaggerMergedModel swaggerMergedModel = SwaggerMergedModel.Companion.getInstance(project);
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)psiFile2);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(...)");
                swModelElement = (SwModelBase)CollectionsKt.firstOrNull(swaggerMergedModel.getBaseModelElements(globalSearchScope));
                if (swModelElement == null) break block4;
                SwModelBase it = swModelElement;
                boolean bl = false;
                Project project2 = psiFile2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                SwModelBase swModelBase = it.substitute(project2);
                SwMetaHolder swMetaHolder = swModelBase instanceof SwMetaHolder ? (SwMetaHolder)((Object)swModelBase) : null;
                swModelElement = swMetaHolder;
                if (swMetaHolder != null) break block5;
            }
            swModelElement = SwTreeUtil.INSTANCE.getParentOfType((PsiElement)psiFile2, SwSpecificationFile.class, true);
        }
        if ((cachedOrNewSpec = swModelElement) == null) {
            Logger.getInstance((String)"SwSpecificationResolveHelper").warn("Unable to prepare specification model for file " + psiFile2.getName());
        }
        SwModelElement swModelElement2 = cachedOrNewSpec;
        return swModelElement2 != null ? swModelElement2.find(Arrays.copyOf(path, path.length)) : null;
    }

    public static final /* synthetic */ Sequence access$resolveBasePath(UrlPath searchedUrl, SwModelBase specificationModel) {
        return SpecificationResolveHelperKt.resolveBasePath(searchedUrl, specificationModel);
    }

    public static final /* synthetic */ Sequence access$resolveOrdinaryUrl(UrlPath searchedUrl, SwModelBase specificationModel) {
        return SpecificationResolveHelperKt.resolveOrdinaryUrl(searchedUrl, specificationModel);
    }
}

