/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.providers;

import com.intellij.ide.presentation.Presentation;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.model.SwaggerMergedModel;
import com.intellij.swagger.core.model.api.SwAuthority;
import com.intellij.swagger.core.model.api.SwModelBase;
import com.intellij.swagger.core.model.api.SwSchema;
import com.intellij.swagger.core.providers.SwUrlResolver;
import com.intellij.swagger.core.providers.resolve.SpecificationResolveHelperKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(icon="com.intellij.swagger.core.SwaggerCoreIcons.Endpoint", typeName="Swagger")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/swagger/core/providers/SwUrlResolver;", "Lcom/intellij/microservices/url/UrlResolver;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "model", "Lcom/intellij/swagger/core/model/SwaggerMergedModel;", "projectSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "supportedSchemes", "", "", "getSupportedSchemes", "()Ljava/util/List;", "getAuthorityHints", "Lcom/intellij/microservices/url/Authority$Exact;", "schema", "getVariants", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "resolve", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "Factory", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwUrlResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwUrlResolver.kt\ncom/intellij/swagger/core/providers/SwUrlResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1549#2:50\n1620#2,3:51\n1549#2:54\n1620#2,3:55\n*S KotlinDebug\n*F\n+ 1 SwUrlResolver.kt\ncom/intellij/swagger/core/providers/SwUrlResolver\n*L\n28#1:50\n28#1:51,3\n31#1:54\n31#1:55,3\n*E\n"})
public final class SwUrlResolver
implements UrlResolver {
    @NotNull
    private final Project myProject;
    @NotNull
    private final SwaggerMergedModel model;
    @NotNull
    private final GlobalSearchScope projectSearchScope;

    public SwUrlResolver(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.model = SwaggerMergedModel.Companion.getInstance(this.myProject);
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getProjectScope(...)");
        this.projectSearchScope = globalSearchScope;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Authority.Exact> getAuthorityHints(@Nullable String schema2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.model.getAuthorities(this.projectSearchScope);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwAuthority swAuthority = (SwAuthority)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Authority.Exact(it.getAuthorityValue().getValue()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getSupportedSchemes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.model.getSchemes(this.projectSearchScope);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwSchema swSchema = (SwSchema)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SwaggerUtilsKt.withEndingSlash(it.getSchemaValue().getValue()));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations(request.getPath()), (Function1)((Function1)new Function1<UrlPath, Sequence<? extends UrlTargetInfo>>(this, request){
            final /* synthetic */ SwUrlResolver this$0;
            final /* synthetic */ UrlResolveRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(1);
            }

            @NotNull
            public final Sequence<UrlTargetInfo> invoke(@NotNull UrlPath it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SequencesKt.filter((Sequence)SequencesKt.flatMapIterable(SpecificationResolveHelperKt.resolveUrl(it, SwUrlResolver.access$getProjectSearchScope$p(this.this$0)), (Function1)resolve.1.INSTANCE), (Function1)((Function1)new Function1<UrlTargetInfo, Boolean>(this.$request){
                    final /* synthetic */ UrlResolveRequest $request;
                    {
                        this.$request = $request;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull UrlTargetInfo endpointTarget) {
                        Intrinsics.checkNotNullParameter((Object)endpointTarget, (String)"endpointTarget");
                        CharSequence charSequence = this.$request.getMethod();
                        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || CollectionsKt.contains((Iterable)endpointTarget.getMethods(), (Object)this.$request.getMethod());
                    }
                }));
            }
        })));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.model.getBaseModelElements(this.projectSearchScope)), (Function1)((Function1)new Function1<SwModelBase, SwModelBase>(this){
            final /* synthetic */ SwUrlResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final SwModelBase invoke(@NotNull SwModelBase it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.substitute(SwUrlResolver.access$getMyProject$p(this.this$0));
            }
        })), (Function1)getVariants.2.INSTANCE));
    }

    public static final /* synthetic */ GlobalSearchScope access$getProjectSearchScope$p(SwUrlResolver $this) {
        return $this.projectSearchScope;
    }

    public static final /* synthetic */ Project access$getMyProject$p(SwUrlResolver $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/swagger/core/providers/SwUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.swagger.core"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return SwaggerMergedModel.Companion.getInstance(project).hasSpecifications() ? (UrlResolver)new SwUrlResolver(project) : null;
        }
    }
}

