/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.providers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.model.SwSecondarySpecificationSchemaAssemblyKt;
import com.intellij.swagger.core.providers.SwJsonSchemaPatchUtils$hasTextNode$;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J \u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\b\b\u0002\u0010\u001d\u001a\u00020\u0017J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0004J\f\u0010\u001f\u001a\u00020\u0004*\u00020\fH\u0002J\u0014\u0010 \u001a\u00020\u0017*\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/swagger/core/providers/SwJsonSchemaPatchUtils;", "", "()V", "PATCHES_DIRECTORY", "", "myJsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "addItemToArray", "", "targetArray", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "newItem", "Lcom/fasterxml/jackson/databind/JsonNode;", "applySuitablePatches", "jsonSchemaContent", "specificationType", "Lcom/intellij/swagger/core/SwSpecificationType;", "findAllSuitablePatches", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/vfs/VirtualFile;", "mergeArrays", "patchArray", "mergePatchIntoSchema", "", "schemaRootNode", "patchVirtualFile", "mergeTrees", "targetSchema", "patch", "allowCancellation", "readTree", "asPrettyString", "hasTextNode", "textNode", "Lcom/fasterxml/jackson/databind/node/TextNode;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwJsonSchemaPatchUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwJsonSchemaPatchUtils.kt\ncom/intellij/swagger/core/providers/SwJsonSchemaPatchUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,135:1\n1224#2,2:136\n473#2:139\n1247#2,2:140\n13#3:138\n*S KotlinDebug\n*F\n+ 1 SwJsonSchemaPatchUtils.kt\ncom/intellij/swagger/core/providers/SwJsonSchemaPatchUtils\n*L\n27#1:136,2\n134#1:139\n134#1:140,2\n48#1:138\n*E\n"})
public final class SwJsonSchemaPatchUtils {
    @NotNull
    public static final SwJsonSchemaPatchUtils INSTANCE = new SwJsonSchemaPatchUtils();
    @NotNull
    private static final String PATCHES_DIRECTORY = "schema/patches";
    @NotNull
    private static final ObjectMapper myJsonObjectMapper = new ObjectMapper(new JsonFactory());

    private SwJsonSchemaPatchUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String applySuitablePatches(@NotNull String jsonSchemaContent, @NotNull SwSpecificationType specificationType2) {
        String string;
        boolean bl;
        JsonNode mutableTransformedSchema;
        block5: {
            void $this$all$iv;
            Intrinsics.checkNotNullParameter((Object)jsonSchemaContent, (String)"jsonSchemaContent");
            Intrinsics.checkNotNullParameter((Object)specificationType2, (String)"specificationType");
            JsonNode jsonNode = this.readTree(jsonSchemaContent);
            if (jsonNode == null) {
                return jsonSchemaContent;
            }
            mutableTransformedSchema = jsonNode;
            Sequence<VirtualFile> sequence = this.findAllSuitablePatches(specificationType2);
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (INSTANCE.mergePatchIntoSchema(mutableTransformedSchema, it)) continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        boolean allStaticPatchesApplied = bl;
        JsonNode dynamicSchemaPatch = SwSecondarySpecificationSchemaAssemblyKt.createDynamicSchemaPatchFor(specificationType2);
        if (dynamicSchemaPatch != null) {
            SwJsonSchemaPatchUtils.mergeTrees$default(this, mutableTransformedSchema, dynamicSchemaPatch, false, 4, null);
        }
        if (allStaticPatchesApplied) {
            string = this.asPrettyString(mutableTransformedSchema);
        } else {
            Logger.getInstance(SwJsonSchemaPatchUtils.class).warn("Some patches were applied with errors, default schema for specification type " + specificationType2 + " will be used");
            string = jsonSchemaContent;
        }
        return string;
    }

    @Nullable
    public final JsonNode readTree(@NotNull String jsonSchemaContent) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)jsonSchemaContent, (String)"jsonSchemaContent");
        try {
            jsonNode = myJsonObjectMapper.readTree(jsonSchemaContent);
        }
        catch (IOException exception) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(SwJsonSchemaPatchUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Unable to read json schema from provided file", (Throwable)exception);
            jsonNode = null;
        }
        return jsonNode;
    }

    @NotNull
    public final JsonNode mergeTrees(@NotNull JsonNode targetSchema, @NotNull JsonNode patch, boolean allowCancellation) {
        block15: {
            JsonNode jsonNode;
            block11: {
                Intrinsics.checkNotNullParameter((Object)targetSchema, (String)"targetSchema");
                Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
                if (allowCancellation) {
                    ProgressManager.checkCanceled();
                }
                if (!((jsonNode = targetSchema) instanceof ObjectNode)) break block11;
                Iterator iterator = patch.fields();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fields(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    String nodeKeyWithoutPrefixes;
                    Map.Entry node;
                    block14: {
                        block13: {
                            block12: {
                                node = (Map.Entry)iterator2.next();
                                Object k = node.getKey();
                                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                                nodeKeyWithoutPrefixes = StringsKt.removePrefix((String)StringsKt.removePrefix((String)((String)k), (CharSequence)"~"), (CharSequence)"!");
                                if (!targetSchema.has(nodeKeyWithoutPrefixes)) break block12;
                                Object k2 = node.getKey();
                                Intrinsics.checkNotNullExpressionValue(k2, (String)"<get-key>(...)");
                                if (StringsKt.startsWith$default((String)((String)k2), (String)"!", (boolean)false, (int)2, null)) break block13;
                            }
                            if (targetSchema.has(nodeKeyWithoutPrefixes) && !(targetSchema.get(nodeKeyWithoutPrefixes) instanceof TextNode)) break block14;
                        }
                        ((ObjectNode)targetSchema).set(nodeKeyWithoutPrefixes, (JsonNode)node.getValue());
                        continue;
                    }
                    if (targetSchema.has(nodeKeyWithoutPrefixes)) {
                        Object k = node.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                        if (StringsKt.startsWith$default((String)((String)k), (String)"~", (boolean)false, (int)2, null)) {
                            ((ObjectNode)targetSchema).remove(nodeKeyWithoutPrefixes);
                            continue;
                        }
                    }
                    if (!targetSchema.has(nodeKeyWithoutPrefixes)) continue;
                    JsonNode jsonNode2 = targetSchema.get(nodeKeyWithoutPrefixes);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"get(...)");
                    Object v = node.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                    SwJsonSchemaPatchUtils.mergeTrees$default(this, jsonNode2, (JsonNode)v, false, 4, null);
                }
                break block15;
            }
            if (jsonNode instanceof ArrayNode) {
                JsonNode jsonNode3 = patch;
                if (jsonNode3 instanceof ArrayNode) {
                    this.mergeArrays((ArrayNode)targetSchema, (ArrayNode)patch);
                } else if (jsonNode3 instanceof ObjectNode) {
                    this.addItemToArray((ArrayNode)targetSchema, patch);
                }
            }
        }
        return targetSchema;
    }

    public static /* synthetic */ JsonNode mergeTrees$default(SwJsonSchemaPatchUtils swJsonSchemaPatchUtils, JsonNode jsonNode, JsonNode jsonNode2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return swJsonSchemaPatchUtils.mergeTrees(jsonNode, jsonNode2, bl);
    }

    private final String asPrettyString(JsonNode $this$asPrettyString) {
        String string = myJsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)$this$asPrettyString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    private final boolean mergePatchIntoSchema(JsonNode schemaRootNode, VirtualFile patchVirtualFile) {
        boolean bl;
        try {
            String string = FileUtil.loadTextAndClose((InputStream)patchVirtualFile.getInputStream());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadTextAndClose(...)");
            String patchContent = string;
            JsonNode jsonNode = this.readTree(patchContent);
            if (jsonNode == null) {
                return false;
            }
            JsonNode patchRootNode = jsonNode;
            SwJsonSchemaPatchUtils.mergeTrees$default(this, schemaRootNode, patchRootNode, false, 4, null);
            bl = true;
        }
        catch (IOException ex) {
            Logger.getInstance(SwJsonSchemaPatchUtils.class).warn("Unable to apply patch " + patchVirtualFile.getName() + " to json schema", (Throwable)ex);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Sequence<VirtualFile> findAllSuitablePatches(@NotNull SwSpecificationType specificationType2) {
        SwSpecificationType swSpecificationType;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)specificationType2, (String)"specificationType");
        StringBuilder $this$findAllSuitablePatches_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (specificationType2 instanceof SwSpecificationType.SecondarySpecificationPart) {
            $this$findAllSuitablePatches_u24lambda_u241.append("Secondary_");
        }
        if ((swSpecificationType = specificationType2) instanceof SwSpecificationType.Swagger2Family) {
            $this$findAllSuitablePatches_u24lambda_u241.append("2_0");
        } else if (swSpecificationType instanceof SwSpecificationType.OpenAPI30Family) {
            $this$findAllSuitablePatches_u24lambda_u241.append("3_0_0");
        } else if (swSpecificationType instanceof SwSpecificationType.OpenAPI31Family) {
            $this$findAllSuitablePatches_u24lambda_u241.append("3_1_0");
        } else {
            return SequencesKt.emptySequence();
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String patchNamePrefix = string;
        return (Sequence)ActionsKt.runReadAction((Function0)((Function0)new Function0<Sequence<? extends VirtualFile>>(patchNamePrefix){
            final /* synthetic */ String $patchNamePrefix;
            {
                this.$patchNamePrefix = $patchNamePrefix;
                super(0);
            }

            @NotNull
            public final Sequence<VirtualFile> invoke() {
                VirtualFile virtualFile2 = SwaggerUtilsKt.getBundledResource("schema/patches");
                Object[] $this$orEmpty$iv = virtualFile2 != null ? virtualFile2.getChildren() : null;
                boolean $i$f$orEmpty = false;
                Object[] objectArray = $this$orEmpty$iv;
                if ($this$orEmpty$iv == null) {
                    boolean $i$f$emptyArray = false;
                    objectArray = new VirtualFile[]{};
                }
                return SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<VirtualFile, Boolean>(this.$patchNamePrefix){
                    final /* synthetic */ String $patchNamePrefix;
                    {
                        this.$patchNamePrefix = $patchNamePrefix;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(VirtualFile it) {
                        String string = it.getNameWithoutExtension();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
                        return StringsKt.startsWith$default((String)string, (String)this.$patchNamePrefix, (boolean)false, (int)2, null);
                    }
                }));
            }
        }));
    }

    private final void mergeArrays(ArrayNode targetArray, ArrayNode patchArray) {
        Iterator iterator = patchArray.elements();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            JsonNode arrayItem = (JsonNode)iterator2.next();
            if (!(arrayItem instanceof TextNode) || this.hasTextNode(targetArray, (TextNode)arrayItem)) continue;
            this.addItemToArray(targetArray, arrayItem);
        }
    }

    private final void addItemToArray(ArrayNode targetArray, JsonNode newItem) {
        targetArray.add(newItem);
    }

    private final boolean hasTextNode(ArrayNode $this$hasTextNode, TextNode textNode) {
        boolean bl;
        block1: {
            Iterator iterator = $this$hasTextNode.elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            Sequence $this$filterIsInstance$iv = SequencesKt.asSequence((Iterator)iterator);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)hasTextNode$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$any$iv = sequence;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                TextNode it = (TextNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.textValue(), (Object)textNode.textValue())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }
}

