/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.model;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@State(name="SwUserDefinedSpecifications")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002$%B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0016J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\tJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020#H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/swagger/core/model/SwUserDefinedSpecifications;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/swagger/core/model/SwUserDefinedSpecifications$SwUserDefinedSpecificationsState;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myState", "", "", "Lcom/intellij/swagger/core/SwSpecificationType;", "clearAssociations", "", "deserializeSpecificationType", "value", "Lcom/intellij/swagger/core/model/SwUserDefinedSpecifications$SerializedSpecificationType;", "dispose", "getSpecificationType", "fileUrl", "getState", "loadState", "state", "markAsSpecification", "virtualFilePointer", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "specificationType", "processVFileEvent", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "removeUrlForDeletedFile", "serializeSpecificationType", "type", "updateUrlForMovedFile", "Lcom/intellij/openapi/vfs/newvfs/events/VFileMoveEvent;", "updateUrlForRenamedFile", "Lcom/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent;", "SerializedSpecificationType", "SwUserDefinedSpecificationsState", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwUserDefinedSpecifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwUserDefinedSpecifications.kt\ncom/intellij/swagger/core/model/SwUserDefinedSpecifications\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n14#2:140\n14#2:141\n1#3:142\n453#4:143\n403#4:144\n453#4:149\n403#4:150\n1238#5,4:145\n1238#5,4:151\n*S KotlinDebug\n*F\n+ 1 SwUserDefinedSpecifications.kt\ncom/intellij/swagger/core/model/SwUserDefinedSpecifications\n*L\n86#1:140\n87#1:141\n102#1:143\n102#1:144\n107#1:149\n107#1:150\n102#1:145,4\n107#1:151,4\n*E\n"})
public final class SwUserDefinedSpecifications
implements PersistentStateComponent<SwUserDefinedSpecificationsState>,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, SwSpecificationType> myState;

    public SwUserDefinedSpecifications(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myState = new LinkedHashMap();
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(){

            /*
             * WARNING - void declaration
             */
            public void before(@NotNull List<? extends VFileEvent> events) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(events, (String)"events");
                Iterable iterable = events;
                SwUserDefinedSpecifications swUserDefinedSpecifications = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VFileEvent p0 = (VFileEvent)element$iv;
                    boolean bl = false;
                    swUserDefinedSpecifications.processVFileEvent(p0);
                }
            }
        });
    }

    public final void markAsSpecification(@NotNull VirtualFilePointer virtualFilePointer, @Nullable SwSpecificationType specificationType2) {
        Intrinsics.checkNotNullParameter((Object)virtualFilePointer, (String)"virtualFilePointer");
        if (specificationType2 == null || specificationType2 instanceof SwSpecificationType.UNKNOWN) {
            this.myState.remove(virtualFilePointer.getUrl());
        } else {
            Map<String, SwSpecificationType> map2 = this.myState;
            String string = virtualFilePointer.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            map2.put(string, specificationType2);
        }
        VirtualFile virtualFile2 = virtualFilePointer.getFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, virtualFile3){
            final /* synthetic */ SwUserDefinedSpecifications this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                super(0);
            }

            public final void invoke() {
                FileEditorManager.getInstance((Project)SwUserDefinedSpecifications.access$getProject$p(this.this$0)).updateFilePresentation(this.$virtualFile);
            }
        }), (int)1, null);
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.project).findFile(virtualFile3);
        if (psiFile2 == null) {
            return;
        }
        PsiFile psiFile3 = psiFile2;
        DaemonCodeAnalyzer.getInstance((Project)this.project).restart(psiFile3);
    }

    @TestOnly
    public final void clearAssociations() {
        this.myState.clear();
    }

    private final void processVFileEvent(VFileEvent event) {
        if (event instanceof VFileDeleteEvent) {
            this.removeUrlForDeletedFile(event);
        } else if (event instanceof VFileMoveEvent) {
            this.updateUrlForMovedFile((VFileMoveEvent)event);
        } else if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).isRename()) {
            this.updateUrlForRenamedFile((VFilePropertyChangeEvent)event);
        }
    }

    private final void removeUrlForDeletedFile(VFileEvent event) {
        Map<String, SwSpecificationType> map2 = this.myState;
        VirtualFile virtualFile2 = event.getFile();
        String string = virtualFile2 != null ? virtualFile2.getUrl() : null;
        TypeIntrinsics.asMutableMap(map2).remove(string);
    }

    private final void updateUrlForMovedFile(VFileMoveEvent event) {
        String string = event.getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        Object object = event.getOldParent();
        if (object == null || (object = object.getUrl()) == null) {
            this.removeUrlForDeletedFile((VFileEvent)event);
            return;
        }
        Object oldParentUrl = object;
        String string2 = event.getNewParent().getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
        String newParentUrl = string2;
        String oldFileUrl = (String)oldParentUrl + "/" + fileName;
        String newFileUrl = newParentUrl + "/" + fileName;
        SwSpecificationType swSpecificationType = this.myState.remove(oldFileUrl);
        if (swSpecificationType == null) {
            return;
        }
        SwSpecificationType oldValue = swSpecificationType;
        this.myState.put(newFileUrl, oldValue);
    }

    private final void updateUrlForRenamedFile(VFilePropertyChangeEvent event) {
        Object object = event.getFile().getParent();
        if (object == null || (object = object.getUrl()) == null) {
            this.removeUrlForDeletedFile((VFileEvent)event);
            return;
        }
        Object parentUrl = object;
        Object $this$asSafely$iv = event.getOldValue();
        boolean $i$f$asSafely = false;
        Object object2 = $this$asSafely$iv;
        if (!(object2 instanceof String)) {
            object2 = null;
        }
        String string = (String)object2;
        if (string == null) {
            this.removeUrlForDeletedFile((VFileEvent)event);
            return;
        }
        String oldName = string;
        Object $this$asSafely$iv2 = event.getNewValue();
        boolean $i$f$asSafely2 = false;
        Object object3 = $this$asSafely$iv2;
        if (!(object3 instanceof String)) {
            object3 = null;
        }
        String string2 = (String)object3;
        if (string2 == null) {
            this.removeUrlForDeletedFile((VFileEvent)event);
            return;
        }
        String newName = string2;
        String oldFileUrl = (String)parentUrl + "/" + oldName;
        String newFileUrl = (String)parentUrl + "/" + newName;
        SwSpecificationType swSpecificationType = this.myState.remove(oldFileUrl);
        if (swSpecificationType == null) {
            return;
        }
        SwSpecificationType oldValue = swSpecificationType;
        this.myState.put(newFileUrl, oldValue);
    }

    @NotNull
    public final SwSpecificationType getSpecificationType(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        SwSpecificationType swSpecificationType = this.myState.get(fileUrl);
        if (swSpecificationType == null) {
            swSpecificationType = SwSpecificationType.UNKNOWN.INSTANCE;
        }
        return swSpecificationType;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SwUserDefinedSpecificationsState getState() {
        SwUserDefinedSpecificationsState swUserDefinedSpecificationsState;
        Map<String, SwSpecificationType> map2;
        Map<String, SwSpecificationType> map3;
        Map<String, SwSpecificationType> it = map3 = this.myState;
        boolean bl = false;
        Map<String, SwSpecificationType> map4 = map2 = !it.isEmpty() ? map3 : null;
        if (map2 != null) {
            void $this$mapValuesTo$iv$iv;
            Map<String, SwSpecificationType> $this$mapValues$iv = map2;
            boolean $i$f$mapValues = false;
            Map<String, SwSpecificationType> map5 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void entry;
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map6 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map7 = map6;
                boolean bl3 = false;
                SerializedSpecificationType serializedSpecificationType = this.serializeSpecificationType((SwSpecificationType)entry.getValue());
                map7.put(k, serializedSpecificationType);
            }
            Map p0 = destination$iv$iv;
            boolean bl4 = false;
            swUserDefinedSpecificationsState = new SwUserDefinedSpecificationsState(p0);
        } else {
            swUserDefinedSpecificationsState = null;
        }
        return swUserDefinedSpecificationsState;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull SwUserDefinedSpecificationsState state) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map map2 = state.getSpecTypeByUrl();
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map map3 = map2;
        Map<String, SwSpecificationType> map4 = this.myState;
        boolean $i$f$mapValues = false;
        void var4_5 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map5 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map6 = map5;
            boolean bl2 = false;
            SwSpecificationType swSpecificationType = this.deserializeSpecificationType((SerializedSpecificationType)entry.getValue());
            map6.put(k, swSpecificationType);
        }
        map4.putAll(destination$iv$iv);
    }

    private final SwSpecificationType deserializeSpecificationType(SerializedSpecificationType value) {
        String partId = value.getPartId();
        String typeId = value.getTypeId();
        return partId == null || typeId == null ? (SwSpecificationType)SwSpecificationType.UNKNOWN.INSTANCE : (Intrinsics.areEqual((Object)typeId, (Object)"openapi30") ? (SwSpecificationType)new SwSpecificationType.Openapi3SecondarySpecificationPart(partId) : (Intrinsics.areEqual((Object)typeId, (Object)"openapi31") ? (SwSpecificationType)new SwSpecificationType.Openapi31SecondarySpecificationPart(partId) : (Intrinsics.areEqual((Object)typeId, (Object)"swagger2") ? (SwSpecificationType)new SwSpecificationType.Swagger2SecondarySpecificationPart(partId) : (Intrinsics.areEqual((Object)typeId, (Object)"ignored") ? (SwSpecificationType)SwSpecificationType.IGNORED.INSTANCE : (SwSpecificationType)SwSpecificationType.UNKNOWN.INSTANCE))));
    }

    private final SerializedSpecificationType serializeSpecificationType(SwSpecificationType type2) {
        String typeId = type2.getId();
        String partId = type2 instanceof SwSpecificationType.SecondarySpecificationPart ? ((SwSpecificationType.SecondarySpecificationPart)((Object)type2)).getPartSchemaId() : null;
        return new SerializedSpecificationType(typeId, partId);
    }

    public void dispose() {
    }

    public static final /* synthetic */ Project access$getProject$p(SwUserDefinedSpecifications $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/swagger/core/model/SwUserDefinedSpecifications$SerializedSpecificationType;", "", "typeId", "", "partId", "(Ljava/lang/String;Ljava/lang/String;)V", "getPartId", "()Ljava/lang/String;", "setPartId", "(Ljava/lang/String;)V", "getTypeId", "setTypeId", "intellij.swagger.core"})
    public static final class SerializedSpecificationType {
        @Nullable
        private String typeId;
        @Nullable
        private String partId;

        public SerializedSpecificationType(@Nullable String typeId, @Nullable String partId) {
            this.typeId = typeId;
            this.partId = partId;
        }

        public /* synthetic */ SerializedSpecificationType(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @Nullable
        public final String getTypeId() {
            return this.typeId;
        }

        public final void setTypeId(@Nullable String string) {
            this.typeId = string;
        }

        @Nullable
        public final String getPartId() {
            return this.partId;
        }

        public final void setPartId(@Nullable String string) {
            this.partId = string;
        }

        public SerializedSpecificationType() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006R(\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/intellij/swagger/core/model/SwUserDefinedSpecifications$SwUserDefinedSpecificationsState;", "", "specTypeByUrl", "", "", "Lcom/intellij/swagger/core/model/SwUserDefinedSpecifications$SerializedSpecificationType;", "(Ljava/util/Map;)V", "getSpecTypeByUrl", "()Ljava/util/Map;", "setSpecTypeByUrl", "intellij.swagger.core"})
    public static final class SwUserDefinedSpecificationsState {
        @Nullable
        private Map<String, SerializedSpecificationType> specTypeByUrl;

        public SwUserDefinedSpecificationsState(@Nullable Map<String, SerializedSpecificationType> specTypeByUrl) {
            this.specTypeByUrl = specTypeByUrl;
        }

        public /* synthetic */ SwUserDefinedSpecificationsState(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map2 = null;
            }
            this(map2);
        }

        @Nullable
        public final Map<String, SerializedSpecificationType> getSpecTypeByUrl() {
            return this.specTypeByUrl;
        }

        public final void setSpecTypeByUrl(@Nullable Map<String, SerializedSpecificationType> map2) {
            this.specTypeByUrl = map2;
        }

        public SwUserDefinedSpecificationsState() {
            this(null, 1, null);
        }
    }
}

