/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.model;

import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.model.SwSpecificationSchemaStorage;
import com.intellij.swagger.core.providers.SwJsonSchemaPatchUtils;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.text.NameUtilCore;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import java.io.InputStream;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RG\u0010\u0005\u001a;\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012$\u0012\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b \b*\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t0\t0\u0006\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/swagger/core/model/SwSpecificationSchemaStorage;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "schemasBySpecificationType", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/swagger/core/SwSpecificationType;", "kotlin.jvm.PlatformType", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "Lorg/jetbrains/annotations/NotNull;", "computeSchema", "specificationType", "computeSchemaObject", "schemaFile", "getRootSchemaResourcePath", "", "getSchemaFile", "getSchemaFor", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwSpecificationSchemaStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwSpecificationSchemaStorage.kt\ncom/intellij/swagger/core/model/SwSpecificationSchemaStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class SwSpecificationSchemaStorage {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<SwSpecificationType, Pair<VirtualFile, JsonSchemaObject>> schemasBySpecificationType;

    public SwSpecificationSchemaStorage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> SwSpecificationSchemaStorage.schemasBySpecificationType$lambda$0((Function1)new Function1<SwSpecificationType, Pair<? extends VirtualFile, ? extends JsonSchemaObject>>((Object)this){

            @NotNull
            public final Pair<VirtualFile, JsonSchemaObject> invoke(@NotNull SwSpecificationType p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SwSpecificationSchemaStorage.access$computeSchema((SwSpecificationSchemaStorage)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.schemasBySpecificationType = concurrentMap;
    }

    @Nullable
    public final Pair<VirtualFile, JsonSchemaObject> getSchemaFor(@NotNull SwSpecificationType specificationType2) {
        Intrinsics.checkNotNullParameter((Object)specificationType2, (String)"specificationType");
        return specificationType2 instanceof SwSpecificationType.NONE ? null : (Pair)this.schemasBySpecificationType.get(specificationType2);
    }

    private final Pair<VirtualFile, JsonSchemaObject> computeSchema(SwSpecificationType specificationType2) {
        VirtualFile schemaFile = this.getSchemaFile(specificationType2);
        JsonSchemaObject schemaObject = this.computeSchemaObject(schemaFile, this.project);
        return TuplesKt.to((Object)schemaFile, (Object)schemaObject);
    }

    private final JsonSchemaObject computeSchemaObject(VirtualFile schemaFile, Project project) {
        if (Registry.is((String)"json.schema.object.v2")) {
            boolean bl;
            JsonSchemaObject bundledSchemaObject = JsonSchemaReader.getOrComputeSchemaObjectForSchemaFile((VirtualFile)schemaFile, (Project)project);
            boolean bl2 = bl = bundledSchemaObject != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Json schema object must be created for a bundled schema file";
                throw new AssertionError((Object)string);
            }
            JsonSchemaObject jsonSchemaObject = bundledSchemaObject;
            Intrinsics.checkNotNull((Object)jsonSchemaObject);
            return jsonSchemaObject;
        }
        return (JsonSchemaObject)ActionsKt.runReadAction((Function0)((Function0)new Function0<JsonSchemaObject>(project, schemaFile){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $schemaFile;
            {
                this.$project = $project;
                this.$schemaFile = $schemaFile;
                super(0);
            }

            @NotNull
            public final JsonSchemaObject invoke() {
                boolean bl;
                boolean bl2;
                PsiFile schemaPsiFile = PsiManager.getInstance((Project)this.$project).findFile(this.$schemaFile);
                boolean bl3 = bl2 = schemaPsiFile != null;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl4 = false;
                    String string = "PSI must be created for a bundled schema file";
                    throw new AssertionError((Object)string);
                }
                JsonSchemaReader jsonSchemaReader = new JsonSchemaReader(this.$schemaFile);
                PsiFile psiFile2 = schemaPsiFile;
                Intrinsics.checkNotNull((Object)psiFile2);
                JsonSchemaObject schemaObject = jsonSchemaReader.read(psiFile2);
                boolean bl5 = bl = schemaObject != null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl6 = false;
                    String string = "Json schema object must be created for a bundled schema file";
                    throw new AssertionError((Object)string);
                }
                JsonSchemaObject jsonSchemaObject = schemaObject;
                Intrinsics.checkNotNull((Object)jsonSchemaObject);
                return jsonSchemaObject;
            }
        }));
    }

    private final VirtualFile getSchemaFile(SwSpecificationType specificationType2) {
        StringBuilder stringBuilder;
        String resourcePath = this.getRootSchemaResourcePath(specificationType2);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new RuntimeException("No bundled json schema found in resources folder: '" + resourcePath + "'");
        }
        InputStream bundledSchemaAsStream = inputStream;
        String string = FileUtil.loadTextAndClose((InputStream)bundledSchemaAsStream);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadTextAndClose(...)");
        String defaultSchemaContent = string;
        String patchedSchemaContent = SwJsonSchemaPatchUtils.INSTANCE.applySuitablePatches(defaultSchemaContent, specificationType2);
        StringBuilder $this$getSchemaFile_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getSchemaFile_u24lambda_u242.append(specificationType2.getPresentableName());
        if (specificationType2 instanceof SwSpecificationType.SecondarySpecificationPart && !StringsKt.isBlank((CharSequence)((SwSpecificationType.SecondarySpecificationPart)((Object)specificationType2)).getPartSchemaId())) {
            String shortPartId = StringsKt.substringAfterLast$default((String)((SwSpecificationType.SecondarySpecificationPart)((Object)specificationType2)).getPartSchemaId(), (String)"/", null, (int)2, null);
            String[] stringArray = NameUtilCore.nameToWords((String)shortPartId);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"nameToWords(...)");
            String prettyName2 = ArraysKt.joinToString$default((Object[])stringArray, (CharSequence)" ", null, null, (int)0, null, (Function1)getSchemaFile.schemaName.1.prettyName.1.INSTANCE, (int)30, null);
            $this$getSchemaFile_u24lambda_u242.append(" [" + prettyName2 + "]");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String schemaName2 = string2;
        LanguageFileType jsonFileType = FileTypeManager.getInstance().findFileTypeByLanguage((Language)JsonLanguage.INSTANCE);
        return (VirtualFile)new LightVirtualFile(schemaName2 + ".json", (FileType)jsonFileType, (CharSequence)patchedSchemaContent);
    }

    private final String getRootSchemaResourcePath(SwSpecificationType specificationType2) {
        String string;
        SwSpecificationType swSpecificationType = specificationType2;
        if (swSpecificationType instanceof SwSpecificationType.Swagger2Family) {
            string = "schema/swagger_2_0.json";
        } else if (swSpecificationType instanceof SwSpecificationType.OpenAPI30Family) {
            string = "schema/openapi_3_0_0.json";
        } else if (swSpecificationType instanceof SwSpecificationType.OpenAPI31Family) {
            string = "schema/openapi_3_1_0.json";
        } else if (swSpecificationType instanceof SwSpecificationType.AsyncAPIFamily) {
            string = "schema/asyncapi_2.json";
        } else {
            throw new RuntimeException("No schema file exist for specification type: " + specificationType2);
        }
        return string;
    }

    private static final Pair schemasBySpecificationType$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Pair access$computeSchema(SwSpecificationSchemaStorage $this, SwSpecificationType specificationType2) {
        return $this.computeSchema(specificationType2);
    }
}

