/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.index;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a1\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0000\u00a2\u0006\u0002\u0010\u000f\u001a*\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0011\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0000\u001a\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0002\u001a8\u0010\u0017\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00112\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020\u00160\u001cH\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"INDEXED_SPECIFICATION_TYPE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/swagger/core/SwSpecificationType;", "getPrecomputedSpecificationTypeFromUserData", "psiFile", "Lcom/intellij/psi/PsiFile;", "isIndexingRightNow", "", "project", "Lcom/intellij/openapi/project/Project;", "processWithPrecomputedSpecificationType", "T", "specificationType", "action", "Lkotlin/Function0;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/swagger/core/SwSpecificationType;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "readListOfObjects", "", "dataInput", "Ljava/io/DataInput;", "objectReader", "storeVirtualFileInUserData", "", "writeListOfObjects", "dataOutput", "Ljava/io/DataOutput;", "objects", "objectWriter", "Lkotlin/Function1;", "intellij.swagger.core"})
public final class SwIndexUtilsKt {
    @NotNull
    private static final Key<SwSpecificationType> INDEXED_SPECIFICATION_TYPE_KEY;

    public static final <T> void writeListOfObjects(@NotNull DataOutput dataOutput, @NotNull List<? extends T> objects, @NotNull Function1<? super T, Unit> objectWriter) {
        Intrinsics.checkNotNullParameter((Object)dataOutput, (String)"dataOutput");
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        Intrinsics.checkNotNullParameter(objectWriter, (String)"objectWriter");
        DataInputOutputUtil.writeINT((DataOutput)dataOutput, (int)objects.size());
        for (T singleObject : objects) {
            objectWriter.invoke(singleObject);
        }
    }

    @NotNull
    public static final <T> List<T> readListOfObjects(@NotNull DataInput dataInput, @NotNull Function0<? extends T> objectReader) {
        Intrinsics.checkNotNullParameter((Object)dataInput, (String)"dataInput");
        Intrinsics.checkNotNullParameter(objectReader, (String)"objectReader");
        int size = DataInputOutputUtil.readINT((DataInput)dataInput);
        ArrayList<Object> objects = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            objects.add(objectReader.invoke());
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T processWithPrecomputedSpecificationType(@NotNull PsiFile psiFile2, @NotNull SwSpecificationType specificationType2, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)specificationType2, (String)"specificationType");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            SwIndexUtilsKt.storeVirtualFileInUserData(psiFile2, specificationType2);
            object = action.invoke();
        }
        finally {
            SwIndexUtilsKt.storeVirtualFileInUserData(psiFile2, null);
        }
        return (T)object;
    }

    private static final void storeVirtualFileInUserData(PsiFile psiFile2, SwSpecificationType specificationType2) {
        psiFile2.putUserData(INDEXED_SPECIFICATION_TYPE_KEY, (Object)specificationType2);
    }

    @Nullable
    public static final SwSpecificationType getPrecomputedSpecificationTypeFromUserData(@NotNull PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        return (SwSpecificationType)psiFile2.getUserData(INDEXED_SPECIFICATION_TYPE_KEY);
    }

    public static final boolean isIndexingRightNow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DumbService.Companion.isDumb(project) || FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() != null;
    }

    static {
        Key key = Key.create((String)"swIndexedSpecificationType");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        INDEXED_SPECIFICATION_TYPE_KEY = key;
    }
}

