/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.diff.model;

import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.diff.SwDiffResult;
import com.intellij.swagger.core.diff.SwDiffUtilsKt;
import com.intellij.swagger.core.diff.model.SwModifiedElement;
import com.intellij.swagger.core.diff.model.SwModifiedHttpOperation;
import com.intellij.swagger.core.diff.model.SwModifiedMediaType;
import com.intellij.swagger.core.diff.model.SwModifiedParameter;
import com.intellij.swagger.core.diff.model.SwModifiedPrimitive;
import com.intellij.swagger.core.diff.model.SwModifiedResponse;
import com.intellij.swagger.core.diff.model.SwModifiedRootElement;
import com.intellij.swagger.core.model.api.SwHttpOperation;
import com.intellij.swagger.core.model.api.SwMediaType;
import com.intellij.swagger.core.model.api.SwParameter;
import com.intellij.swagger.core.model.api.SwResponse;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020$0\u000b0#H\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0010\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0010\u001a\u0004\b\u0019\u0010\u000eR!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0010\u001a\u0004\b\u001d\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006%"}, d2={"Lcom/intellij/swagger/core/diff/model/SwModifiedHttpOperation;", "Lcom/intellij/swagger/core/diff/model/SwModifiedElement;", "Lcom/intellij/swagger/core/model/api/SwHttpOperation;", "original", "modified", "root", "Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;", "(Lcom/intellij/swagger/core/model/api/SwHttpOperation;Lcom/intellij/swagger/core/model/api/SwHttpOperation;Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;)V", "getModified", "()Lcom/intellij/swagger/core/model/api/SwHttpOperation;", "myConsumedMediaTypesDiff", "Lcom/intellij/swagger/core/diff/SwDiffResult;", "Lcom/intellij/swagger/core/model/api/SwMediaType;", "getMyConsumedMediaTypesDiff", "()Lcom/intellij/swagger/core/diff/SwDiffResult;", "myConsumedMediaTypesDiff$delegate", "Lkotlin/Lazy;", "myDeprecatedModified", "Lcom/intellij/swagger/core/diff/model/SwModifiedPrimitive;", "", "getMyDeprecatedModified", "()Lcom/intellij/swagger/core/diff/model/SwModifiedPrimitive;", "myDeprecatedModified$delegate", "myParametersDiff", "Lcom/intellij/swagger/core/model/api/SwParameter;", "getMyParametersDiff", "myParametersDiff$delegate", "myResponsesDiff", "Lcom/intellij/swagger/core/model/api/SwResponse;", "getMyResponsesDiff", "myResponsesDiff$delegate", "getOriginal", "getRoot", "()Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;", "computeChildrenDiffs", "", "", "intellij.swagger.core"})
public final class SwModifiedHttpOperation
implements SwModifiedElement<SwHttpOperation> {
    @NotNull
    private final SwHttpOperation original;
    @NotNull
    private final SwHttpOperation modified;
    @NotNull
    private final SwModifiedRootElement root;
    @NotNull
    private final Lazy myDeprecatedModified$delegate;
    @NotNull
    private final Lazy myParametersDiff$delegate;
    @NotNull
    private final Lazy myResponsesDiff$delegate;
    @NotNull
    private final Lazy myConsumedMediaTypesDiff$delegate;

    public SwModifiedHttpOperation(@NotNull SwHttpOperation original, @NotNull SwHttpOperation modified, @NotNull SwModifiedRootElement root) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)modified, (String)"modified");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.original = original;
        this.modified = modified;
        this.root = root;
        this.myDeprecatedModified$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SwModifiedPrimitive<Boolean>>(this){
            final /* synthetic */ SwModifiedHttpOperation this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SwModifiedPrimitive<Boolean> invoke() {
                return new SwModifiedPrimitive<Boolean>(SwaggerBundle.message("diff.fields.deprecated.title", new Object[0]), this.this$0.getOriginal().isDeprecated().getValue(), this.this$0.getModified().isDeprecated().getValue(), this.this$0.getRoot(), myDeprecatedModified.1.INSTANCE);
            }
        }));
        this.myParametersDiff$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SwDiffResult<SwParameter>>(this){
            final /* synthetic */ SwModifiedHttpOperation this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SwDiffResult<SwParameter> invoke() {
                return SwDiffUtilsKt.calculateDiffBetween((Collection)this.this$0.getOriginal().getParameters(), (Collection)this.this$0.getModified().getParameters(), myParametersDiff.1.INSTANCE, (Function2)new Function2<SwParameter, SwParameter, SwModifiedElement<?>>(this.this$0){
                    final /* synthetic */ SwModifiedHttpOperation this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @NotNull
                    public final SwModifiedElement<?> invoke(@NotNull SwParameter before, @NotNull SwParameter after) {
                        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
                        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
                        return new SwModifiedParameter(before, after, this.this$0.getRoot());
                    }
                });
            }
        }));
        this.myResponsesDiff$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SwDiffResult<SwResponse>>(this){
            final /* synthetic */ SwModifiedHttpOperation this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SwDiffResult<SwResponse> invoke() {
                return SwDiffUtilsKt.calculateDiffBetween((Collection)this.this$0.getOriginal().getResponses(), (Collection)this.this$0.getModified().getResponses(), myResponsesDiff.1.INSTANCE, (Function2)new Function2<SwResponse, SwResponse, SwModifiedElement<?>>(this.this$0){
                    final /* synthetic */ SwModifiedHttpOperation this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @NotNull
                    public final SwModifiedElement<?> invoke(@NotNull SwResponse before, @NotNull SwResponse after) {
                        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
                        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
                        return new SwModifiedResponse(before, after, this.this$0.getRoot());
                    }
                });
            }
        }));
        this.myConsumedMediaTypesDiff$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SwDiffResult<SwMediaType>>(this){
            final /* synthetic */ SwModifiedHttpOperation this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SwDiffResult<SwMediaType> invoke() {
                return SwDiffUtilsKt.calculateDiffBetween(this.this$0.getOriginal().getConsumes(), this.this$0.getModified().getConsumes(), (Function1)myConsumedMediaTypesDiff.1.INSTANCE, (Function2)new Function2<SwMediaType, SwMediaType, SwModifiedElement<?>>(this.this$0){
                    final /* synthetic */ SwModifiedHttpOperation this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @NotNull
                    public final SwModifiedElement<?> invoke(@NotNull SwMediaType before, @NotNull SwMediaType after) {
                        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
                        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
                        return new SwModifiedMediaType(before, after, this.this$0.getRoot());
                    }
                });
            }
        }));
    }

    @Override
    @NotNull
    public SwHttpOperation getOriginal() {
        return this.original;
    }

    @Override
    @NotNull
    public SwHttpOperation getModified() {
        return this.modified;
    }

    @Override
    @NotNull
    public SwModifiedRootElement getRoot() {
        return this.root;
    }

    private final SwModifiedPrimitive<Boolean> getMyDeprecatedModified() {
        Lazy lazy = this.myDeprecatedModified$delegate;
        return (SwModifiedPrimitive)lazy.getValue();
    }

    private final SwDiffResult<SwParameter> getMyParametersDiff() {
        Lazy lazy = this.myParametersDiff$delegate;
        return (SwDiffResult)lazy.getValue();
    }

    private final SwDiffResult<SwResponse> getMyResponsesDiff() {
        Lazy lazy = this.myResponsesDiff$delegate;
        return (SwDiffResult)lazy.getValue();
    }

    private final SwDiffResult<SwMediaType> getMyConsumedMediaTypesDiff() {
        Lazy lazy = this.myConsumedMediaTypesDiff$delegate;
        return (SwDiffResult)lazy.getValue();
    }

    @NotNull
    public Collection<SwDiffResult<? extends Object>> computeChildrenDiffs() {
        Object[] objectArray = new SwDiffResult[4];
        objectArray[0] = this.getMyParametersDiff();
        objectArray[1] = this.getMyResponsesDiff();
        objectArray[2] = this.getMyConsumedMediaTypesDiff();
        SwModifiedElement[] swModifiedElementArray = new SwModifiedElement[]{this.getMyDeprecatedModified()};
        objectArray[3] = SwDiffResult.Companion.fromModifications(swModifiedElementArray);
        return SetsKt.setOf((Object[])objectArray);
    }
}

