/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.codegen;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.SwDownloadManager;
import com.intellij.swagger.core.SwDownloadableFileType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.codegen.CliCommand;
import com.intellij.swagger.core.codegen.CodegenCliBuilderKt;
import com.intellij.swagger.core.codegen.SwJdkUtilsKt;
import com.intellij.swagger.core.codegen.SwaggerCodegenRunConfiguration;
import com.intellij.swagger.core.codegen.autoImport.GeneratedCodeProcessor;
import com.intellij.swagger.core.notifications.SwaggerNotifications;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J!\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0014J-\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"H\u0002\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/swagger/core/codegen/SwaggerCodegenState;", "Lcom/intellij/execution/configurations/CommandLineState;", "configuration", "Lcom/intellij/swagger/core/codegen/SwaggerCodegenRunConfiguration;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/intellij/swagger/core/codegen/SwaggerCodegenRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "generatorJar", "Lcom/intellij/openapi/vfs/VirtualFile;", "ensureDirectoriesExist", "", "findGeneratedDirectoryOrNull", "event", "Lcom/intellij/execution/process/ProcessEvent;", "performInBackground", "T", "operation", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "processGeneratedFiles", "", "generatedRoot", "project", "Lcom/intellij/openapi/project/Project;", "startProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "testRunCodegen", "Lcom/intellij/execution/process/ProcessOutput;", "generatorPath", "", "javaPath", "parameters", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lcom/intellij/execution/process/ProcessOutput;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwaggerCodegenState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerCodegenState.kt\ncom/intellij/swagger/core/codegen/SwaggerCodegenState\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,124:1\n23#2:125\n766#3:126\n857#3,2:127\n1477#3:129\n1502#3,3:130\n1505#3,3:140\n1855#3,2:143\n372#4,7:133\n*S KotlinDebug\n*F\n+ 1 SwaggerCodegenState.kt\ncom/intellij/swagger/core/codegen/SwaggerCodegenState\n*L\n90#1:125\n98#1:126\n98#1:127,2\n99#1:129\n99#1:130,3\n99#1:140,3\n101#1:143,2\n99#1:133,7\n*E\n"})
public final class SwaggerCodegenState
extends CommandLineState {
    @NotNull
    private final SwaggerCodegenRunConfiguration configuration;

    public SwaggerCodegenState(@NotNull SwaggerCodegenRunConfiguration configuration, @Nullable ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(environment);
        this.configuration = configuration;
    }

    private final GeneralCommandLine createCommandLine(VirtualFile generatorJar2) {
        String generatorStdErr2 = (String)this.performInBackground((Function0)new Function0<String>(this, generatorJar2){
            final /* synthetic */ SwaggerCodegenState this$0;
            final /* synthetic */ VirtualFile $generatorJar;
            {
                this.this$0 = $receiver;
                this.$generatorJar = $generatorJar;
                super(0);
            }

            @Nullable
            public final String invoke() {
                String string = this.$generatorJar.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                ProcessOutput processOutput = SwaggerCodegenState.access$testRunCodegen(this.this$0, string, SwaggerCodegenState.access$getConfiguration$p(this.this$0).getJdkPath(), new CliCommand().addSingleWordArgument("version").asStringArray());
                return processOutput != null ? processOutput.getStderr() : null;
            }
        });
        CharSequence charSequence = generatorStdErr2;
        if (!(charSequence == null || charSequence.length() == 0)) {
            throw new CantRunException(SwaggerBundle.message("run.configuration.codegen.validation.generator.not.downloaded", new Object[0]));
        }
        String jdkPath = SwJdkUtilsKt.findJdkPathByShortName(this.configuration.getJdkPath());
        if (StringsKt.isBlank((CharSequence)jdkPath)) {
            throw new CantRunException(SwaggerBundle.message("run.configuration.codegen.validation.no.jdk", new Object[0]));
        }
        if (!this.ensureDirectoriesExist(this.configuration)) {
            throw new CantRunException(SwaggerBundle.message("run.configuration.codegen.validation.directories.not.created", new Object[0]));
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(jdkPath).withWorkDirectory(this.configuration.getWorkingDirectory());
        String string = generatorJar2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String[] stringArray = CodegenCliBuilderKt.buildParametersFromConfiguration(this.configuration, string);
        GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters(Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withParameters(...)");
        return generalCommandLine2;
    }

    @NotNull
    protected OSProcessHandler startProcess() {
        ColoredProcessHandler coloredProcessHandler;
        VirtualFile generatorJar2 = (VirtualFile)this.performInBackground((Function0)new Function0<VirtualFile>(this){
            final /* synthetic */ SwaggerCodegenState this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final VirtualFile invoke() {
                return SwDownloadManager.INSTANCE.downloadFile(SwaggerCodegenState.access$getConfiguration$p(this.this$0).getGeneratorType().getUrl(), SwDownloadableFileType.SWAGGER_CODEGEN_JAR, ProgressManager.getGlobalProgressIndicator(), false);
            }
        });
        if (generatorJar2 == null || !generatorJar2.isValid()) {
            throw new CantRunException(SwaggerBundle.message("run.configuration.codegen.validation.generator.not.downloaded", new Object[0]));
        }
        ColoredProcessHandler $this$startProcess_u24lambda_u240 = coloredProcessHandler = new ColoredProcessHandler(this.createCommandLine(generatorJar2));
        boolean bl = false;
        $this$startProcess_u24lambda_u240.addProcessListener((ProcessListener)new ProcessAdapter(this){
            final /* synthetic */ SwaggerCodegenState this$0;
            {
                this.this$0 = $receiver;
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super.processTerminated(event);
                VirtualFile virtualFile2 = SwaggerCodegenState.access$findGeneratedDirectoryOrNull(this.this$0, event);
                if (virtualFile2 == null) {
                    return;
                }
                VirtualFile generatedDirectory = virtualFile2;
                if (generatedDirectory.exists()) {
                    Project project = SwaggerCodegenState.access$getConfiguration$p(this.this$0).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    SwaggerCodegenState.access$processGeneratedFiles(this.this$0, generatedDirectory, project);
                }
            }
        });
        return (OSProcessHandler)coloredProcessHandler;
    }

    private final boolean ensureDirectoriesExist(SwaggerCodegenRunConfiguration configuration) {
        try {
            Path path = Path.of(configuration.getGenerateToPath(), new String[0]);
            Intrinsics.checkNotNull((Object)path);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                PathKt.createDirectories((Path)path);
            }
        }
        catch (IOException exception) {
            SwaggerCodegenState $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(SwaggerCodegenState.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Unable to create directory for generated code", (Throwable)exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void processGeneratedFiles(VirtualFile generatedRoot, Project project) {
        List list;
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = GeneratedCodeProcessor.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GeneratedCodeProcessor it = (GeneratedCodeProcessor)element$iv$iv;
            boolean bl = false;
            if (!it.canImport(generatedRoot, project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            GeneratedCodeProcessor p0 = (GeneratedCodeProcessor)element$iv$iv;
            boolean bl = false;
            Boolean key$iv$iv = p0.shouldInvokeImplicitly();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object importers = destination$iv$iv;
        List list2 = (List)importers.get(true);
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GeneratedCodeProcessor it = (GeneratedCodeProcessor)element$iv;
                boolean bl = false;
                it.importToProject(generatedRoot, project);
            }
        }
        if ((list = (List)importers.get(false)) == null) {
            list = CollectionsKt.emptyList();
        }
        SwaggerNotifications.INSTANCE.notifySuccessfulGenerationWithOptions$intellij_swagger_core(generatedRoot, list, project);
    }

    private final VirtualFile findGeneratedDirectoryOrNull(ProcessEvent event) {
        return event.getExitCode() == 0 ? VfsUtil.findFile((Path)Paths.get(this.configuration.getGenerateToPath(), new String[0]), (boolean)true) : null;
    }

    private final ProcessOutput testRunCodegen(String generatorPath, String javaPath, String[] parameters2) {
        if (StringsKt.isBlank((CharSequence)javaPath) || StringsKt.isBlank((CharSequence)generatorPath)) {
            return null;
        }
        String[] generalCommand = CodegenCliBuilderKt.buildGeneratorLaunchCommand(generatorPath);
        String workingDirectory = new File(generatorPath).getParent();
        Object object = new SpreadBuilder(3);
        object.add((Object)javaPath);
        object.addSpread((Object)generalCommand);
        object.addSpread((Object)parameters2);
        GeneralCommandLine generalCommandLine = new GeneralCommandLine((String[])object.toArray((Object[])new String[object.size()])).withWorkDirectory(workingDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withWorkDirectory(...)");
        GeneralCommandLine testCommandLine = generalCommandLine;
        SwaggerCodegenState swaggerCodegenState = this;
        try {
            SwaggerCodegenState $this$testRunCodegen_u24lambda_u243 = swaggerCodegenState;
            boolean bl = false;
            object = Result.constructor-impl((Object)ExecUtil.execAndGetOutput((GeneralCommandLine)testCommandLine));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        swaggerCodegenState = object;
        return (ProcessOutput)(Result.isFailure-impl((Object)((Object)swaggerCodegenState)) ? null : swaggerCodegenState);
    }

    private final <T> T performInBackground(Function0<? extends T> operation) {
        Callable<Object> callable = () -> SwaggerCodegenState.performInBackground$lambda$4(operation);
        ProgressIndicator progressIndicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"notNullize(...)");
        return (T)ApplicationUtil.runWithCheckCanceled(callable, (ProgressIndicator)progressIndicator);
    }

    private static final Object performInBackground$lambda$4(Function0 $operation) {
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        return $operation.invoke();
    }

    public static final /* synthetic */ ProcessOutput access$testRunCodegen(SwaggerCodegenState $this, String generatorPath, String javaPath, String[] parameters2) {
        return $this.testRunCodegen(generatorPath, javaPath, parameters2);
    }

    public static final /* synthetic */ SwaggerCodegenRunConfiguration access$getConfiguration$p(SwaggerCodegenState $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ VirtualFile access$findGeneratedDirectoryOrNull(SwaggerCodegenState $this, ProcessEvent event) {
        return $this.findGeneratedDirectoryOrNull(event);
    }

    public static final /* synthetic */ void access$processGeneratedFiles(SwaggerCodegenState $this, VirtualFile generatedRoot, Project project) {
        $this.processGeneratedFiles(generatedRoot, project);
    }
}

