/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.toolWindow;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.rider.diagrams.architecture.DiagramHost;
import com.jetbrains.rider.diagrams.architecture.RiderDiagramBundle;
import com.jetbrains.rider.diagrams.architecture.RiderProjectDiagramDataModel;
import com.jetbrains.rider.diagrams.architecture.RiderProjectDiagramProvider;
import com.jetbrains.rider.diagrams.architecture.graph.RiderShowDiagram;
import com.jetbrains.rider.diagrams.architecture.graphElements.RiderDiagramNode;
import com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramToolWindowFactory;
import icons.RiderIcons;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0017J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002J\u0006\u0010\u0019\u001a\u00020\u0017J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u001b\u001a\u00020\u0012J\u0016\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0014\u0010!\u001a\u00020\u00122\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140#J\b\u0010$\u001a\u00020\u0017H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramWindowManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "fqn", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getFqn", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "toolWindowFactory", "Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramToolWindowFactory;", "toolWindowShowed", "", "toolWindowTask", "Lcom/intellij/openapi/wm/RegisterToolWindowTask;", "addToVisibleScope", "", "item", "", "closeToolWindow", "getOrRegisterToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getToolWindow", "registerToolWindow", "removeFromVisibleScope", "showActualTree", "showDiagram", "diagram", "Lcom/jetbrains/rider/diagrams/architecture/RiderProjectDiagramDataModel;", "provider", "Lcom/jetbrains/rider/diagrams/architecture/RiderProjectDiagramProvider;", "updateDiagramToolWindow", "scope", "", "updateToolWindow", "intellij.rider.plugins.diagram"})
public final class RiderProjectDiagramWindowManager {
    @NotNull
    private final Project project;
    @NotNull
    private final String fqn;
    @NotNull
    private final RiderProjectDiagramToolWindowFactory toolWindowFactory;
    @NotNull
    private final RegisterToolWindowTask toolWindowTask;
    private boolean toolWindowShowed;

    public RiderProjectDiagramWindowManager(@NotNull Project project, @NotNull String fqn) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        this.project = project;
        this.fqn = fqn;
        this.toolWindowFactory = new RiderProjectDiagramToolWindowFactory(this.project, this.fqn);
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"LEFT");
        this.toolWindowTask = new RegisterToolWindowTask("Project Diagram", toolWindowAnchor, null, true, false, true, true, (ToolWindowFactory)this.toolWindowFactory, RiderIcons.Toolwindows.ToolwindowProjectDiagram, RiderProjectDiagramWindowManager::toolWindowTask$lambda$0);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getFqn() {
        return this.fqn;
    }

    private final ToolWindow getToolWindow() {
        return ToolWindowManager.Companion.getInstance(this.project).getToolWindow(this.toolWindowTask.getId());
    }

    @NotNull
    public final ToolWindow getOrRegisterToolWindow() {
        ToolWindow toolWindow = this.getToolWindow();
        if (toolWindow == null) {
            toolWindow = this.registerToolWindow();
        }
        return toolWindow;
    }

    private final ToolWindow updateToolWindow() {
        this.closeToolWindow();
        return this.getOrRegisterToolWindow();
    }

    @NotNull
    public final ToolWindow registerToolWindow() {
        return ToolWindowManager.Companion.getInstance(this.project).registerToolWindow(this.toolWindowTask);
    }

    public final void closeToolWindow() {
        ToolWindow toolWindow;
        ToolWindow toolWindow2 = toolWindow = this.getToolWindow();
        boolean bl = toolWindow2 != null ? toolWindow2.isVisible() : false;
        if (bl) {
            toolWindow.remove();
        }
    }

    public final void addToVisibleScope(int item) {
        this.toolWindowFactory.addToVisibleScope(item);
    }

    public final void removeFromVisibleScope(int item) {
        this.toolWindowFactory.removeFromVisibleScope(item);
    }

    public final void showDiagram(@NotNull RiderProjectDiagramDataModel diagram, @NotNull RiderProjectDiagramProvider provider) {
        Intrinsics.checkNotNullParameter((Object)((Object)diagram), (String)"diagram");
        Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)"provider");
        RiderDiagramNode riderDiagramNode = diagram.getOriginalElement();
        if (riderDiagramNode == null) {
            throw new IllegalStateException("Original element is null".toString());
        }
        Runnable runnable = RiderShowDiagram.Companion.createShowDiagramRunnable(riderDiagramNode, provider, this.project, diagram.getFqn());
        if (runnable != null) {
            runnable.run();
        }
    }

    public final void updateDiagramToolWindow(@NotNull Set<Integer> scope) {
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        ToolWindow toolWindow = this.getToolWindow();
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        this.toolWindowFactory.updateToolWindow(scope, toolWindow2);
        if (toolWindow2.isVisible()) {
            this.getOrRegisterToolWindow().show();
        }
    }

    public final void showActualTree() {
        ToolWindow toolWindow = this.updateToolWindow();
        this.toolWindowFactory.setupToolWindow();
        DiagramHost.Companion.getInstance(this.project).setCurrentToolWindowFqn(this.fqn);
        toolWindow.show();
    }

    private static final String toolWindowTask$lambda$0() {
        return RiderDiagramBundle.message("tool.window.title", new Object[0]);
    }
}

