/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.toolWindow;

import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramFolderTreeNode;
import com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramRootTreeNode;
import com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramTreeNode;
import com.jetbrains.rider.diagrams.architecture.toolWindow.RiderProjectDiagramTreeNodeBase;
import com.jetbrains.rider.projectView.ProjectModelIconsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import icons.RiderIcons;
import java.awt.Color;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JD\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramCellRenderer;", "Lcom/intellij/ui/CheckboxTree$CheckboxTreeCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "matcher", "Lcom/intellij/psi/codeStyle/MinusculeMatcher;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "customizeFolderNodeRendering", "", "treeNode", "Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramFolderTreeNode;", "selected", "", "customizeProjectNode", "node", "Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramTreeNode;", "customizeRenderer", "tree", "Ljavax/swing/JTree;", "value", "", "expanded", "leaf", "row", "", "hasFocus", "customizeRootNodeRendering", "Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramRootTreeNode;", "setProjectDiagramRender", "Lcom/jetbrains/rider/diagrams/architecture/toolWindow/RiderProjectDiagramTreeNodeBase;", "intellij.rider.plugins.diagram"})
public final class RiderProjectDiagramCellRenderer
extends CheckboxTree.CheckboxTreeCellRenderer {
    @NotNull
    private final Project project;
    @NotNull
    private MinusculeMatcher matcher;

    public RiderProjectDiagramCellRenderer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)"", (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        Intrinsics.checkNotNullExpressionValue((Object)minusculeMatcher, (String)"buildMatcher(...)");
        this.matcher = minusculeMatcher;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void customizeRenderer(@Nullable JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object object = value;
        if (object instanceof RiderProjectDiagramFolderTreeNode) {
            this.customizeFolderNodeRendering((RiderProjectDiagramFolderTreeNode)value, selected);
        } else if (object instanceof RiderProjectDiagramRootTreeNode) {
            this.customizeRootNodeRendering((RiderProjectDiagramRootTreeNode)value, selected);
        } else if (object instanceof RiderProjectDiagramTreeNode) {
            this.customizeProjectNode((RiderProjectDiagramTreeNode)value, selected);
        } else {
            return;
        }
    }

    private final void customizeProjectNode(RiderProjectDiagramTreeNode node, boolean selected) {
        this.getTextRenderer().setIcon(ProjectModelIconsKt.calculateIcon((ProjectModelEntity)node.getProjectEntity(), (Project)this.project));
        this.setProjectDiagramRender(node, selected);
    }

    private final void customizeFolderNodeRendering(RiderProjectDiagramFolderTreeNode treeNode, boolean selected) {
        this.getTextRenderer().setIcon(RiderIcons.Nodes.FolderSolution);
        this.setProjectDiagramRender(treeNode, selected);
    }

    private final void customizeRootNodeRendering(RiderProjectDiagramRootTreeNode node, boolean selected) {
        this.getTextRenderer().setIcon(RiderIcons.FileTypes.Solution);
        this.setProjectDiagramRender(node, selected);
    }

    private final void setProjectDiagramRender(RiderProjectDiagramTreeNodeBase node, boolean selected) {
        Color color = UIUtil.getListBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getListBackground(...)");
        Color bgColor = color;
        SpeedSearchUtil.appendColoredFragmentForMatcher((String)node.getText(), (SimpleColoredComponent)((SimpleColoredComponent)this.getTextRenderer()), (SimpleTextAttributes)SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES, (Matcher)((Matcher)this.matcher), (Color)bgColor, (boolean)selected);
    }
}

