/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.infrastructure;

import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.HitInfo;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rider.diagrams.architecture.DiagramHost;
import com.jetbrains.rider.diagrams.architecture.ProjectDiagramUtils;
import com.jetbrains.rider.diagrams.architecture.RiderDiagramProviderBase;
import com.jetbrains.rider.diagrams.architecture.graph.RiderGraphBuilder;
import com.jetbrains.rider.diagrams.architecture.graph.RiderGraphUtil;
import com.jetbrains.rider.diagrams.architecture.graphElements.RiderDiagramEdge;
import com.jetbrains.rider.diagrams.architecture.infrastructure.RiderGraphEditMode;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000S\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u000f\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00152\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/infrastructure/RiderGraphEditMode;", "Lcom/intellij/openapi/graph/view/EditMode;", "Lcom/intellij/openapi/Disposable;", "builder", "Lcom/jetbrains/rider/diagrams/architecture/graph/RiderGraphBuilder;", "(Lcom/jetbrains/rider/diagrams/architecture/graph/RiderGraphBuilder;)V", "mergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "presentationModel", "Lcom/intellij/diagram/DiagramPresentationModel;", "collapseGroup", "", "node", "Lcom/intellij/openapi/graph/base/Node;", "createUpdate", "com/jetbrains/rider/diagrams/architecture/infrastructure/RiderGraphEditMode$createUpdate$1", "updateAction", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Lcom/jetbrains/rider/diagrams/architecture/infrastructure/RiderGraphEditMode$createUpdate$1;", "dispose", "getEdgeTip", "", "edge", "Lcom/intellij/openapi/graph/base/Edge;", "getNodeTip", "mouseClicked", "mouseEvent", "Ljava/awt/event/MouseEvent;", "mouseDragged", "throttleCollapseGroup", "intellij.rider.plugins.diagram"})
public final class RiderGraphEditMode
extends EditMode
implements Disposable {
    @NotNull
    private final RiderGraphBuilder builder;
    @NotNull
    private final DiagramPresentationModel presentationModel;
    @NotNull
    private final MergingUpdateQueue mergingUpdateQueue;

    public RiderGraphEditMode(@NotNull RiderGraphBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)((Object)builder), (String)"builder");
        this.builder = builder;
        this.presentationModel = this.builder.getPresentationModel();
        this.mergingUpdateQueue = new MergingUpdateQueue("Diagram Edit Mode", 50, true, null);
    }

    @NotNull
    public String getNodeTip(@Nullable Node node) {
        DiagramNode nodeObject = (DiagramNode)this.builder.getNodeObject(node);
        if (nodeObject != null) {
            String string = this.presentationModel.getNodeTooltip((Object)nodeObject);
            if (string == null) {
                string = "";
            }
            return string;
        }
        return "";
    }

    public void mouseDragged(@Nullable MouseEvent mouseEvent) {
        HitInfo hitInfo;
        Node node;
        super.mouseDragged(mouseEvent);
        if (mouseEvent != null && (node = (hitInfo = this.getHitInfo(mouseEvent)).getHitNode()) != null) {
            RiderGraphUtil.Companion.doPartialLayoutForNodeEdges(this.builder, node);
        }
    }

    @NotNull
    public String getEdgeTip(@Nullable Edge edge) {
        DiagramEdge edgeObject = (DiagramEdge)this.builder.getEdgeObject(edge);
        if (edgeObject != null) {
            String string = this.presentationModel.getEdgeTooltip((Object)edgeObject);
            if (string == null) {
                string = "";
            }
            return string;
        }
        return "";
    }

    public void mouseClicked(@Nullable MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            HitInfo hitInfo = this.getHitInfo(mouseEvent);
            if (mouseEvent.getClickCount() == 2) {
                Node node = hitInfo.getHitNode();
                if (node != null) {
                    this.throttleCollapseGroup(node);
                }
            } else {
                Edge edge = hitInfo.getHitEdge();
                if (edge != null) {
                    RiderDiagramEdge edgeObj;
                    Object object = this.builder.getEdgeObject(edge);
                    RiderDiagramEdge riderDiagramEdge = edgeObj = object instanceof RiderDiagramEdge ? (RiderDiagramEdge)((Object)object) : null;
                    if (edgeObj != null) {
                        DiagramProvider<?> diagramProvider = this.builder.getProvider();
                        RiderDiagramProviderBase riderDiagramProviderBase = diagramProvider instanceof RiderDiagramProviderBase ? (RiderDiagramProviderBase)diagramProvider : null;
                        if (riderDiagramProviderBase == null) {
                            throw new IllegalStateException("Wrong diagram provider set".toString());
                        }
                        RiderDiagramProviderBase prov = riderDiagramProviderBase;
                        Project project = this.builder.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        String string = prov.getDiagramFqn();
                        if (string == null) {
                            throw new IllegalStateException("Forgot to set diagramFqn in provider".toString());
                        }
                        DiagramHost.Companion.getInstance(project).findEdgeUsages(edgeObj, string);
                    }
                }
                super.mouseClicked(mouseEvent);
            }
        }
    }

    private final void collapseGroup(Node node) {
        Graph2D graph2D = this.builder.getGraph();
        Intrinsics.checkNotNullExpressionValue((Object)graph2D, (String)"getGraph(...)");
        Graph2D graph2D2 = graph2D;
        NodeRealizer realizer = graph2D2.getRealizer(node);
        if (realizer instanceof GroupNodeRealizer) {
            NodeGroupDescriptor group = GraphImplUtil.getGroup((GraphDataMaps)this.builder.getDataMaps(), (Node)node);
            if (this.builder.getHierarchyManager().isFolderNode(node)) {
                this.builder.getHierarchyManager().openFolder(node);
                ((GroupNodeRealizer)realizer).setGroupClosed(false);
                if (group != null) {
                    group.setClosed(false);
                }
            } else {
                this.builder.getHierarchyManager().closeGroup(node);
                ((GroupNodeRealizer)realizer).setGroupClosed(true);
                if (group != null) {
                    group.setClosed(true);
                }
                Graph2D graph2D3 = this.builder.getGraph();
                Intrinsics.checkNotNullExpressionValue((Object)graph2D3, (String)"getGraph(...)");
                Graph2DView graph2DView = this.builder.getView();
                Intrinsics.checkNotNullExpressionValue((Object)graph2DView, (String)"getView(...)");
                ProjectDiagramUtils.INSTANCE.setRenderedNodeSizes(graph2D3, graph2DView, node);
            }
        }
    }

    private final void throttleCollapseGroup(Node node) {
        createUpdate.1 update2 = this.createUpdate((Function0<Unit>)((Function0)new Function0<Unit>(this, node){
            final /* synthetic */ RiderGraphEditMode this$0;
            final /* synthetic */ Node $node;
            {
                this.this$0 = $receiver;
                this.$node = $node;
                super(0);
            }

            public final void invoke() {
                RiderGraphEditMode.access$collapseGroup(this.this$0, this.$node);
            }
        }));
        this.mergingUpdateQueue.queue((Update)update2);
    }

    private final createUpdate.1 createUpdate(Function0<Unit> updateAction) {
        return new Update(updateAction){
            final /* synthetic */ Function0<Unit> $updateAction;
            {
                this.$updateAction = $updateAction;
                super((Object)"");
            }

            public void run() {
                if (!this.isDisposed()) {
                    this.$updateAction.invoke();
                }
            }
        };
    }

    public void dispose() {
        this.mergingUpdateQueue.dispose();
    }

    public static final /* synthetic */ void access$collapseGroup(RiderGraphEditMode $this, Node node) {
        $this.collapseGroup(node);
    }
}

