/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.infrastructure;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.view.DefaultGraph2DRenderer;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DRenderer;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.uml.presentation.DiagramSelectionModePresentationModelImpl;
import com.jetbrains.rider.diagrams.architecture.RiderProjectDiagramProvider;
import com.jetbrains.rider.diagrams.architecture.graphElements.RiderDiagramEdge;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0018H\u0016J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0018H\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/infrastructure/RiderDiagramPresentationModel;", "Lcom/intellij/uml/presentation/DiagramSelectionModePresentationModelImpl;", "project", "Lcom/intellij/openapi/project/Project;", "graph", "Lcom/intellij/openapi/graph/view/Graph2D;", "provider", "Lcom/jetbrains/rider/diagrams/architecture/RiderProjectDiagramProvider;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/graph/view/Graph2D;Lcom/jetbrains/rider/diagrams/architecture/RiderProjectDiagramProvider;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getProvider", "()Lcom/jetbrains/rider/diagrams/architecture/RiderProjectDiagramProvider;", "customizeSettings", "", "view", "Lcom/intellij/openapi/graph/view/Graph2DView;", "editMode", "Lcom/intellij/openapi/graph/view/EditMode;", "getCommonActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "getEdgeRealizer", "Lcom/intellij/openapi/graph/view/EdgeRealizer;", "edge", "Lcom/intellij/diagram/DiagramEdge;", "getEdgeTooltip", "", "updateDataPresentation", "intellij.rider.plugins.diagram"})
public final class RiderDiagramPresentationModel
extends DiagramSelectionModePresentationModelImpl {
    @NotNull
    private final Project project;
    @NotNull
    private final RiderProjectDiagramProvider provider;

    public RiderDiagramPresentationModel(@NotNull Project project, @NotNull Graph2D graph, @NotNull RiderProjectDiagramProvider provider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)"provider");
        super(graph, project, (DiagramProvider)provider);
        this.project = project;
        this.provider = provider;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final RiderProjectDiagramProvider getProvider() {
        return this.provider;
    }

    public void customizeSettings(@NotNull Graph2DView view, @NotNull EditMode editMode) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)editMode, (String)"editMode");
        super.customizeSettings(view, editMode);
        Graph2DRenderer renderer = view.getGraph2DRenderer();
        if (renderer instanceof DefaultGraph2DRenderer) {
            ((DefaultGraph2DRenderer)renderer).setDrawEdgesFirst(false);
        }
    }

    @Nullable
    public String getEdgeTooltip(@Nullable DiagramEdge<?> edge) {
        if (edge instanceof RiderDiagramEdge) {
            if (((RiderDiagramEdge)edge).getWeight() == 0) {
                return "No compile-time usages for " + ((RiderDiagramEdge)edge).getSource().getNodeName() + " -> " + ((RiderDiagramEdge)edge).getTarget().getNodeName();
            }
            if (((RiderDiagramEdge)edge).getWeight() == 1) {
                return ((RiderDiagramEdge)edge).getSource().getNodeName() + " -> " + ((RiderDiagramEdge)edge).getTarget().getNodeName() + " - " + ((RiderDiagramEdge)edge).getWeight() + " code usage";
            }
            if (((RiderDiagramEdge)edge).getWeight() >= 0) {
                return ((RiderDiagramEdge)edge).getSource().getNodeName() + " -> " + ((RiderDiagramEdge)edge).getTarget().getNodeName() + " - " + ((RiderDiagramEdge)edge).getWeight() + " code usages";
            }
        }
        return super.getEdgeTooltip(edge);
    }

    protected void updateDataPresentation() {
        DiagramBuilder diagramBuilder = this.getBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)diagramBuilder, (String)"getBuilder(...)");
        DiagramBuilder builder = diagramBuilder;
        DiagramDataModel diagramDataModel = builder.getDataModel();
        Intrinsics.checkNotNullExpressionValue((Object)diagramDataModel, (String)"getDataModel(...)");
        DiagramDataModel dataModel = diagramDataModel;
        if (CommonDiagramExtras.isSelectionMode((DiagramBuilder)builder)) {
            this.callSelectionModeCallbacksIfNeeded(true);
            DiagramSelectionModePresentationModelImpl.updateData((DiagramDataModel)dataModel);
            builder.queryUpdate().withDataReload().withPresentationUpdate().withRelayout().run();
            builder.getGraphBuilder().fitContent(false);
        }
    }

    @NotNull
    protected DefaultActionGroup getCommonActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("UML.RiderDefaultGraphPopup"));
        return actionGroup;
    }

    @NotNull
    public EdgeRealizer getEdgeRealizer(@Nullable DiagramEdge<?> edge) {
        if (edge instanceof RiderDiagramEdge && ((RiderDiagramEdge)edge).getDirty()) {
            EdgeRealizer edgeRealizer = super.getEdgeRealizer(edge);
            Intrinsics.checkNotNullExpressionValue((Object)edgeRealizer, (String)"getEdgeRealizer(...)");
            EdgeRealizer realizer = edgeRealizer;
            realizer.setDirty();
            return realizer;
        }
        EdgeRealizer edgeRealizer = super.getEdgeRealizer(edge);
        Intrinsics.checkNotNullExpressionValue((Object)edgeRealizer, (String)"getEdgeRealizer(...)");
        return edgeRealizer;
    }
}

