/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.graph;

import com.intellij.diagram.BaseDiagramProvider;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.Utils;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.util.DataProviderFactory;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import com.jetbrains.rider.diagrams.architecture.filesystem.RiderDiagramVirtualFile;
import com.jetbrains.rider.diagrams.architecture.graph.RiderGraphBuilder;
import com.jetbrains.rider.diagrams.architecture.graph.RiderGraphLayouter;
import com.jetbrains.rider.diagrams.architecture.graphElements.RiderDiagramNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/graph/RiderGraphBuilderFactory;", "", "()V", "create", "Lcom/jetbrains/rider/diagrams/architecture/graph/RiderGraphBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "diagramProvider", "Lcom/intellij/diagram/BaseDiagramProvider;", "Lcom/jetbrains/rider/diagrams/architecture/graphElements/RiderDiagramNode;", "element", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider.plugins.diagram"})
public final class RiderGraphBuilderFactory {
    @NotNull
    public static final RiderGraphBuilderFactory INSTANCE = new RiderGraphBuilderFactory();

    private RiderGraphBuilderFactory() {
    }

    @NotNull
    public final RiderGraphBuilder create(@NotNull Project project, @NotNull BaseDiagramProvider<RiderDiagramNode> diagramProvider, @NotNull RiderDiagramNode element, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(diagramProvider, (String)"diagramProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)element), (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView(graph);
        view.getJComponent().putClientProperty("Diagram-View-Component-Key", true);
        DiagramPresentationModel presentationModel = diagramProvider.createPresentationModel(project, graph);
        if (presentationModel == null) {
            presentationModel = (DiagramPresentationModel)new DiagramPresentationModelImpl(graph, project, (DiagramProvider)diagramProvider);
        }
        DiagramDataModel diagramDataModel = diagramProvider.createDataModel(project, (Object)element, file, presentationModel);
        Intrinsics.checkNotNullExpressionValue((Object)diagramDataModel, (String)"createDataModel(...)");
        DiagramDataModel model = diagramDataModel;
        Intrinsics.checkNotNull((Object)graph);
        Intrinsics.checkNotNull((Object)view);
        RiderGraphBuilder builder = new RiderGraphBuilder(project, graph, view, new RiderGraphLayouter(), (DiagramDataModel<RiderDiagramNode>)model, presentationModel);
        graph.addDataProvider((Object)"PROJECT", DataProviderFactory.create((Object)project));
        graph.addDataProvider((Object)"ORIGINAL_ELEMENT", DataProviderFactory.create((Object)((Object)element)));
        graph.addDataProvider((Object)DiagramDataKeys.GRAPH_BUILDER, DataProviderFactory.create((Object)((Object)builder)));
        builder.putUserData(Utils.UML_PROVIDER, diagramProvider);
        model.putUserData(Utils.GRAPH_BUILDER, (Object)builder);
        if (file instanceof RiderDiagramVirtualFile) {
            ((RiderDiagramVirtualFile)file).addBuilder(builder);
            builder.putUserData(UmlGraphBuilder.EDITOR_FILE, file);
        }
        return builder;
    }
}

