/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.graph;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.diagrams.architecture.RiderProjectDiagramDataModel;
import com.jetbrains.rider.diagrams.architecture.graph.RiderDiagramUpdater;
import com.jetbrains.rider.diagrams.architecture.graph.RiderGraphBuilder;
import com.jetbrains.rider.diagrams.architecture.graphElements.RiderDiagramEdge;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\b*\u0001\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0006\u0010\u0014\u001a\u00020\rJ,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001e\u0010\u0017\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\u0004\u0012\u00020\u00120\u0018J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001c2\u001e\u0010\u0017\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\u0004\u0012\u00020\u00120\u0018J\u0014\u0010\u001d\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016J\r\u0010\u001e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\rH\u0002J\b\u0010!\u001a\u00020\rH\u0002J\u000f\u0010\"\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u000f\u0010#\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/graph/RiderDiagramUpdater;", "", "project", "Lcom/intellij/openapi/project/Project;", "dataModel", "Lcom/jetbrains/rider/diagrams/architecture/RiderProjectDiagramDataModel;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/diagrams/architecture/RiderProjectDiagramDataModel;)V", "mergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "createUpdate", "com/jetbrains/rider/diagrams/architecture/graph/RiderDiagramUpdater$createUpdate$1", "updateAction", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)Lcom/jetbrains/rider/diagrams/architecture/graph/RiderDiagramUpdater$createUpdate$1;", "edgesDifferent", "", "old", "Lcom/jetbrains/rider/diagrams/architecture/graphElements/RiderDiagramEdge;", "new", "groupRelayout", "runEdgesChangeLight", "", "edges", "", "Lkotlin/Pair;", "", "runEdgesChanges", "", "runFullEdgeChanges", "runUpdate", "()Lkotlin/Unit;", "throttleUpdateEdges", "throttleUpdateGraph", "updateEdges", "updateGraph", "intellij.rider.plugins.diagram"})
@SourceDebugExtension(value={"SMAP\nRiderDiagramUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDiagramUpdater.kt\ncom/jetbrains/rider/diagrams/architecture/graph/RiderDiagramUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1855#2,2:82\n*S KotlinDebug\n*F\n+ 1 RiderDiagramUpdater.kt\ncom/jetbrains/rider/diagrams/architecture/graph/RiderDiagramUpdater\n*L\n38#1:82,2\n*E\n"})
public final class RiderDiagramUpdater {
    @NotNull
    private final Project project;
    @NotNull
    private final RiderProjectDiagramDataModel dataModel;
    @NotNull
    private final MergingUpdateQueue mergingUpdateQueue;

    public RiderDiagramUpdater(@NotNull Project project, @NotNull RiderProjectDiagramDataModel dataModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)dataModel), (String)"dataModel");
        this.project = project;
        this.dataModel = dataModel;
        this.mergingUpdateQueue = new MergingUpdateQueue("Diagram Scope Manager", 500, true, null, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), null, (int)1, null));
    }

    @Nullable
    public final Unit runUpdate() {
        return this.updateGraph();
    }

    @NotNull
    public final List<RiderDiagramEdge> runEdgesChanges(@NotNull Map<Pair<Integer, Integer>, ? extends RiderDiagramEdge> edges) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        int n = this.dataModel.getModelEdges().size();
        for (int i = 0; i < n; ++i) {
            RiderDiagramEdge edge = this.dataModel.getModelEdges().get(i);
            RiderDiagramEdge changedEdge = edges.get(new Pair((Object)edge.getSource().getId(), (Object)edge.getTarget().getId()));
            if (changedEdge == null || !this.edgesDifferent(edge, changedEdge)) continue;
            this.dataModel.getModelEdges().set(i, changedEdge);
        }
        this.throttleUpdateGraph();
        return this.dataModel.getModelEdges();
    }

    @NotNull
    public final List<RiderDiagramEdge> runEdgesChangeLight(@NotNull Map<Pair<Integer, Integer>, ? extends RiderDiagramEdge> edges) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        Iterable $this$forEach$iv = this.dataModel.getModelEdges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RiderDiagramEdge it = (RiderDiagramEdge)((Object)element$iv);
            boolean bl = false;
            RiderDiagramEdge changedEdge = edges.get(new Pair((Object)it.getSource().getId(), (Object)it.getTarget().getId()));
            if (changedEdge == null) continue;
            it.setWeight(changedEdge.getWeight());
            it.setRelationship(changedEdge.getRelationship());
            it.setDirty(true);
        }
        this.throttleUpdateEdges();
        return this.dataModel.getModelEdges();
    }

    public final void runFullEdgeChanges(@NotNull List<RiderDiagramEdge> edges) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        this.dataModel.updateEdges(edges);
        this.throttleUpdateEdges();
    }

    private final Unit updateGraph() {
        Unit unit;
        RiderGraphBuilder riderGraphBuilder = this.dataModel.getRiderGraphBuilder();
        if (riderGraphBuilder != null) {
            riderGraphBuilder.update(true, true);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final Unit updateEdges() {
        Unit unit;
        RiderGraphBuilder riderGraphBuilder = this.dataModel.getRiderGraphBuilder();
        if (riderGraphBuilder != null) {
            riderGraphBuilder.updateEdgesView();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void groupRelayout() {
        block0: {
            DiagramBuilder diagramBuilder = this.dataModel.getBuilder();
            RiderGraphBuilder riderGraphBuilder = diagramBuilder instanceof RiderGraphBuilder ? (RiderGraphBuilder)diagramBuilder : null;
            if (riderGraphBuilder == null) break block0;
            riderGraphBuilder.groupRelayout();
        }
    }

    private final createUpdate.1 createUpdate(Function0<Unit> updateAction) {
        return new Update(this, updateAction){
            final /* synthetic */ RiderDiagramUpdater this$0;
            final /* synthetic */ Function0<Unit> $updateAction;
            {
                this.this$0 = $receiver;
                this.$updateAction = $updateAction;
                super((Object)"");
            }

            public void run() {
                if (!RiderDiagramUpdater.access$getProject$p(this.this$0).isDisposed()) {
                    this.$updateAction.invoke();
                }
            }
        };
    }

    private final void throttleUpdateGraph() {
        this.mergingUpdateQueue.queue((Update)this.createUpdate((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RiderDiagramUpdater this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RiderDiagramUpdater.access$updateGraph(this.this$0);
            }
        })));
    }

    private final void throttleUpdateEdges() {
        this.mergingUpdateQueue.queue((Update)this.createUpdate((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RiderDiagramUpdater this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RiderDiagramUpdater.access$updateEdges(this.this$0);
            }
        })));
    }

    private final boolean edgesDifferent(RiderDiagramEdge old, RiderDiagramEdge riderDiagramEdge) {
        return old.getWeight() != riderDiagramEdge.getWeight() ? true : (old.getRelationship().getLineType() != riderDiagramEdge.getRelationship().getLineType() ? true : !Intrinsics.areEqual((Object)old.getRelationship().getName(), (Object)riderDiagramEdge.getRelationship().getName()));
    }

    public static final /* synthetic */ Project access$getProject$p(RiderDiagramUpdater $this) {
        return $this.project;
    }

    public static final /* synthetic */ Unit access$updateGraph(RiderDiagramUpdater $this) {
        return $this.updateGraph();
    }

    public static final /* synthetic */ Unit access$updateEdges(RiderDiagramUpdater $this) {
        return $this.updateEdges();
    }
}

