/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.filesystem;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.rider.diagrams.architecture.filesystem.RiderDiagramVirtualFileType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u001d\u001a\u00020\u001cJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0004H\u0016J\b\u0010!\u001a\u0004\u0018\u00010\u0004J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0004H\u0016J\b\u0010%\u001a\u00020\u0004H\u0016J\b\u0010&\u001a\u00020\u0004H\u0016J\f\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010(J\b\u0010)\u001a\u00020\u001fH\u0016J\u0010\u0010*\u001a\u00020\u001c2\b\u0010+\u001a\u0004\u0018\u00010\u0004R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006,"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/filesystem/RiderDiagramVirtualFile;", "Lcom/intellij/testFramework/LightVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "myName", "", "(Ljava/lang/String;)V", "builder", "Lcom/intellij/diagram/DiagramBuilder;", "getBuilder", "()Lcom/intellij/diagram/DiagramBuilder;", "myBuilders", "", "myProject", "Lcom/intellij/openapi/project/Project;", "presentableName", "value", "project", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "state", "Lcom/intellij/diagram/presentation/DiagramState;", "getState", "()Lcom/intellij/diagram/presentation/DiagramState;", "setState", "(Lcom/intellij/diagram/presentation/DiagramState;)V", "addBuilder", "", "clearCache", "enforcePresentableName", "", "getExtension", "getFQN", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getPath", "getPresentableName", "getPresentablePath", "getUmlProvider", "Lcom/intellij/diagram/DiagramProvider;", "isWritable", "setPresentableName", "name", "intellij.rider.plugins.diagram"})
public final class RiderDiagramVirtualFile
extends LightVirtualFile
implements VirtualFilePathWrapper {
    @NotNull
    private final String myName;
    @Nullable
    private Project myProject;
    @Nullable
    private DiagramState state;
    @Nullable
    private String presentableName;
    @NotNull
    private final List<DiagramBuilder> myBuilders;

    public RiderDiagramVirtualFile(@NotNull String myName) {
        Intrinsics.checkNotNullParameter((Object)myName, (String)"myName");
        super(myName, RiderDiagramVirtualFileType.Companion.getINSTANCE(), (CharSequence)"");
        this.myName = myName;
        this.presentableName = "Project Diagram";
        this.myBuilders = new ArrayList();
    }

    @Nullable
    public final Project getProject() {
        return this.myProject;
    }

    public final void setProject(@Nullable Project value) {
        Project project = this.myProject = value;
        if (project == null) {
            return;
        }
        Disposer.register((Disposable)((Disposable)project), this::clearCache);
    }

    @Nullable
    public final DiagramState getState() {
        return this.state;
    }

    public final void setState(@Nullable DiagramState diagramState) {
        this.state = diagramState;
    }

    @Nullable
    public final DiagramBuilder getBuilder() {
        return !CollectionsKt.any((Iterable)this.myBuilders) ? null : (DiagramBuilder)CollectionsKt.last(this.myBuilders);
    }

    @Nullable
    public final DiagramProvider<?> getUmlProvider() {
        DiagramProvider diagramProvider;
        int ind = StringsKt.indexOf$default((CharSequence)this.myName, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (ind == -1) {
            diagramProvider = null;
        } else {
            String string = this.myName.substring(0, ind);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            diagramProvider = DiagramProvider.findByID((String)string);
        }
        return diagramProvider;
    }

    @Nullable
    public final String getFQN() {
        String string;
        int ind = StringsKt.indexOf$default((CharSequence)this.myName, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (ind == -1) {
            string = null;
        } else {
            String string2 = this.myName.substring(ind + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return string;
    }

    public final void addBuilder(@Nullable DiagramBuilder builder) {
        if (!CollectionsKt.contains((Iterable)this.myBuilders, (Object)builder)) {
            DiagramBuilder diagramBuilder = builder;
            Intrinsics.checkNotNull((Object)diagramBuilder);
            this.myBuilders.add(diagramBuilder);
        }
        DiagramBuilder diagramBuilder = builder;
        Intrinsics.checkNotNull((Object)diagramBuilder);
        Disposer.register((Disposable)((Disposable)diagramBuilder), () -> RiderDiagramVirtualFile.addBuilder$lambda$0(this, builder));
    }

    public final void clearCache() {
        this.myBuilders.clear();
    }

    public boolean isWritable() {
        return true;
    }

    @NotNull
    public String getExtension() {
        return "argr";
    }

    @NotNull
    public String getPresentableName() {
        String string = this.presentableName;
        if (string == null) {
            string = "Project Diagram";
        }
        return string;
    }

    public final void setPresentableName(@Nullable String name) {
        this.presentableName = name;
    }

    @NotNull
    public String getPath() {
        return this.myName;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem("riderDiagram");
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
        return virtualFileSystem;
    }

    public boolean enforcePresentableName() {
        return true;
    }

    @NotNull
    public String getPresentablePath() {
        return "Project Diagram";
    }

    private static final void addBuilder$lambda$0(RiderDiagramVirtualFile this$0, DiagramBuilder $builder) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.myBuilders.remove($builder);
        if (this$0.myBuilders.isEmpty()) {
            this$0.clearCache();
        }
    }
}

