/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagrams.architecture.editor;

import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.uml.utils.VcsUtils;
import com.jetbrains.rider.diagrams.architecture.editor.RiderProjectDiagramEditor;
import com.jetbrains.rider.diagrams.architecture.filesystem.RiderDiagramVirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001aH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/diagrams/architecture/editor/RiderDiagramEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "createEditorFromPsiElement", "Lcom/jetbrains/rider/diagrams/architecture/filesystem/RiderDiagramVirtualFile;", "disposeEditor", "", "editor", "getEditorTypeId", "", "getElementFromFile", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "readState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "sourceElement", "Lorg/jdom/Element;", "writeState", "state", "targetElement", "intellij.rider.plugins.diagram"})
public final class RiderDiagramEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        DiagramProvider<?> provider;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file instanceof RiderDiagramVirtualFile && (provider = ((RiderDiagramVirtualFile)file).getUmlProvider()) != null) {
            return !DumbService.Companion.getInstance(project).isUsableInCurrentContext(provider) ? false : this.getElementFromFile(project, (RiderDiagramVirtualFile)file) != null || VcsUtils.isShowChangesFile((VirtualFile)file);
        }
        return false;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof RiderDiagramVirtualFile ? this.createEditorFromPsiElement(project, (RiderDiagramVirtualFile)file) : (FileEditor)new RiderProjectDiagramEditor(null, false, file, project);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorState, (String)"INSTANCE");
        return fileEditorState;
    }

    @NotNull
    public String getEditorTypeId() {
        return "UmlEditorProvider";
    }

    private final FileEditor createEditorFromPsiElement(Project project, RiderDiagramVirtualFile file) {
        return (FileEditor)new RiderProjectDiagramEditor(this.getElementFromFile(project, file), true, (VirtualFile)file, project);
    }

    private final Object getElementFromFile(Project project, RiderDiagramVirtualFile file) {
        Object result;
        DiagramVfsResolver umlProvider = file.getUmlProvider();
        DiagramVfsResolver diagramVfsResolver = umlProvider;
        if (diagramVfsResolver != null && (diagramVfsResolver = diagramVfsResolver.getVfsResolver()) != null) {
            String string = file.getFQN();
            Intrinsics.checkNotNull((Object)string);
            v2 = diagramVfsResolver.resolveElementByFQN(string, project);
        } else {
            v2 = result = null;
        }
        if (result == null && umlProvider != null) {
            Object element = file.getUserData(DiagramDataKeys.ORIGINAL_ELEMENT);
            if (umlProvider.getElementManager().isAcceptableAsNode(element) && !(element instanceof PsiElement)) {
                return element;
            }
        }
        return result;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Disposer.dispose((Disposable)((Disposable)editor));
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

