/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.reactive;

import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.IMutableViewableList;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rd.util.reactive.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\u000b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00019B\u0015\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u0016\u0010\u0017\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J*\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0018\u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0004\u0012\u00020\u00140\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\u0016\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010!\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J7\u0010\"\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u001e\u0010#\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000%\u0012\u0004\u0012\u00020\u00110$H\u0082\bJ\u0016\u0010&\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\rH\u0096\u0002\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u0011H\u0016J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,H\u0096\u0002J\u0015\u0010-\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000/H\u0016J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000/2\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0015\u00100\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0016\u00101\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u0015\u00102\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010'J\u0016\u00103\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u001e\u00104\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u00105J\u001e\u00106\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u00107\u001a\u00020\r2\u0006\u00108\u001a\u00020\rH\u0016R \u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/jetbrains/rd/util/reactive/ViewableList;", "T", "", "Lcom/jetbrains/rd/util/reactive/IMutableViewableList;", "storage", "", "(Ljava/util/List;)V", "change", "Lcom/jetbrains/rd/util/reactive/Signal;", "Lcom/jetbrains/rd/util/reactive/IViewableList$Event;", "getChange", "()Lcom/jetbrains/rd/util/reactive/Signal;", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "advise", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "handler", "Lkotlin/Function1;", "clear", "contains", "containsAll", "filterElementsInplace", "predicate", "Lkotlin/Function2;", "", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "MyIterator", "rd-core"})
@SourceDebugExtension(value={"SMAP\nViewableList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewableList.kt\ncom/jetbrains/rd/util/reactive/ViewableList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n*L\n1#1,136:1\n83#1,8:153\n91#1:163\n83#1,8:166\n91#1:176\n1855#2:137\n1856#2:146\n1855#2,2:147\n1855#2,2:149\n1855#2,2:151\n1855#2,2:161\n1855#2,2:164\n1855#2,2:174\n138#3:138\n131#3,7:139\n*S KotlinDebug\n*F\n+ 1 ViewableList.kt\ncom/jetbrains/rd/util/reactive/ViewableList\n*L\n79#1:153,8\n79#1:163\n96#1:166,8\n96#1:176\n14#1:137\n14#1:146\n55#1:147,2\n65#1:149,2\n75#1:151,2\n79#1:161,2\n90#1:164,2\n96#1:174,2\n14#1:138\n14#1:139,7\n*E\n"})
public final class ViewableList<T>
implements IMutableViewableList<T> {
    @NotNull
    private final List<T> storage;
    @NotNull
    private final Signal<IViewableList.Event<T>> change;

    public ViewableList(@NotNull List<T> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        this.storage = storage;
        this.change = new Signal();
    }

    public /* synthetic */ ViewableList(List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = new ArrayList();
        }
        this(list2);
    }

    @Override
    @NotNull
    public Signal<IViewableList.Event<T>> getChange() {
        return this.change;
    }

    @Override
    public void advise(@NotNull Lifetime lifetime, @NotNull Function1<? super IViewableList.Event<? extends T>, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (!RLifetimeKt.isAlive(lifetime)) {
            return;
        }
        ((Signal)this.getChange()).advise(lifetime, handler);
        Iterable $this$forEach$iv = CollectionsKt.withIndex((Iterable)this);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedValue it = (IndexedValue)element$iv;
            boolean bl = false;
            boolean $i$f$catch = false;
            Object comment$iv$iv = null;
            boolean $i$f$catch2 = false;
            try {
                boolean bl2 = false;
                handler.invoke(new IViewableList.Event.Add<Object>(it.getIndex(), it.getValue()));
            }
            catch (Throwable e$iv$iv) {
                String sfx$iv$iv = "";
                LoggerKt.getLogger("Default-Error-Logger").log(LogLevel.Error, "Catch" + sfx$iv$iv, e$iv$iv);
            }
        }
    }

    @Override
    public boolean add(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        this.storage.add(element);
        ((Signal)this.getChange()).fire(new IViewableList.Event.Add<T>(this.size() - 1, element));
        return true;
    }

    @Override
    public void add(int index, @NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        this.storage.add(index, element);
        ((Signal)this.getChange()).fire(new IViewableList.Event.Add<T>(index, element));
    }

    @NotNull
    public T removeAt(int index) {
        T res2 = this.storage.remove(index);
        ((Signal)this.getChange()).fire(new IViewableList.Event.Remove<T>(index, res2));
        return res2;
    }

    @Override
    public boolean remove(@Nullable Object element) {
        if (element == null) {
            return false;
        }
        int index = this.storage.indexOf(element);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    @NotNull
    public T set(int index, @NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        T old = this.storage.set(index, element);
        ((Signal)this.getChange()).fire(new IViewableList.Event.Update<T>(index, old, element));
        return old;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ArrayList<IViewableList.Event.Add<T>> changes = new ArrayList<IViewableList.Event.Add<T>>();
        int idx = index;
        for (T element : elements) {
            this.storage.add(idx, element);
            changes.add(new IViewableList.Event.Add<T>(idx, element));
            ++idx;
        }
        Iterable $this$forEach$iv = changes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IViewableList.Event it = (IViewableList.Event)element$iv;
            boolean bl = false;
            ((Signal)this.getChange()).fire(it);
        }
        return !((Collection)changes).isEmpty();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ArrayList<IViewableList.Event.Add<T>> changes = new ArrayList<IViewableList.Event.Add<T>>();
        for (T element : elements) {
            this.storage.add(element);
            changes.add(new IViewableList.Event.Add<T>(this.size() - 1, element));
        }
        Iterable $this$forEach$iv = changes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IViewableList.Event it = (IViewableList.Event)element$iv;
            boolean bl = false;
            ((Signal)this.getChange()).fire(it);
        }
        return !((Collection)changes).isEmpty();
    }

    @Override
    public void clear() {
        ArrayList<IViewableList.Event.Remove<T>> changes = new ArrayList<IViewableList.Event.Remove<T>>();
        for (int i = this.storage.size() - 1; -1 < i; --i) {
            changes.add(new IViewableList.Event.Remove<T>(i, this.storage.get(i)));
        }
        this.storage.clear();
        Iterable $this$forEach$iv = changes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IViewableList.Event it = (IViewableList.Event)element$iv;
            boolean bl = false;
            ((Signal)this.getChange()).fire(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ViewableList this_$iv = this;
        boolean $i$f$filterElementsInplace = false;
        Set elementsSet$iv = CollectionsKt.toSet((Iterable)elements);
        ArrayList<IViewableList.Event.Remove<T>> changes$iv = new ArrayList<IViewableList.Event.Remove<T>>();
        for (int index$iv = CollectionsKt.getLastIndex(this_$iv.storage); -1 < index$iv; --index$iv) {
            void elementsSet;
            Set set2 = elementsSet$iv;
            int index = index$iv;
            boolean bl = false;
            if (!elementsSet.contains(this.storage.get(index))) continue;
            changes$iv.add(new IViewableList.Event.Remove<T>(index$iv, this_$iv.storage.remove(index$iv)));
        }
        Iterable $this$forEach$iv$iv = changes$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            IViewableList.Event it$iv = (IViewableList.Event)element$iv$iv;
            boolean bl = false;
            ((Signal)this_$iv.getChange()).fire(it$iv);
        }
        return !((Collection)changes$iv).isEmpty();
    }

    private final boolean filterElementsInplace(Collection<? extends T> elements, Function2<? super Integer, ? super Set<? extends T>, Boolean> predicate) {
        boolean $i$f$filterElementsInplace = false;
        Set elementsSet = CollectionsKt.toSet((Iterable)elements);
        ArrayList<IViewableList.Event.Remove<T>> changes = new ArrayList<IViewableList.Event.Remove<T>>();
        for (int index = CollectionsKt.getLastIndex(this.storage); -1 < index; --index) {
            if (!((Boolean)predicate.invoke((Object)index, (Object)elementsSet)).booleanValue()) continue;
            changes.add(new IViewableList.Event.Remove<T>(index, this.storage.remove(index)));
        }
        Iterable $this$forEach$iv = changes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IViewableList.Event it = (IViewableList.Event)element$iv;
            boolean bl = false;
            ((Signal)this.getChange()).fire(it);
        }
        return !((Collection)changes).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ViewableList this_$iv = this;
        boolean $i$f$filterElementsInplace = false;
        Set elementsSet$iv = CollectionsKt.toSet((Iterable)elements);
        ArrayList<IViewableList.Event.Remove<T>> changes$iv = new ArrayList<IViewableList.Event.Remove<T>>();
        for (int index$iv = CollectionsKt.getLastIndex(this_$iv.storage); -1 < index$iv; --index$iv) {
            void elementsSet;
            Set set2 = elementsSet$iv;
            int index = index$iv;
            boolean bl = false;
            if (!(!elementsSet.contains(this.storage.get(index)))) continue;
            changes$iv.add(new IViewableList.Event.Remove<T>(index$iv, this_$iv.storage.remove(index$iv)));
        }
        Iterable $this$forEach$iv$iv = changes$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            IViewableList.Event it$iv = (IViewableList.Event)element$iv$iv;
            boolean bl = false;
            ((Signal)this_$iv.getChange()).fire(it$iv);
        }
        return !((Collection)changes$iv).isEmpty();
    }

    public int getSize() {
        return this.storage.size();
    }

    @Override
    public boolean contains(@Nullable Object element) {
        if (element == null) {
            return false;
        }
        return this.storage.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.storage.containsAll(elements);
    }

    @Override
    @NotNull
    public T get(int index) {
        return this.storage.get(index);
    }

    @Override
    public int indexOf(@Nullable Object element) {
        if (element == null) {
            return -1;
        }
        return this.storage.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(@Nullable Object element) {
        if (element == null) {
            return -1;
        }
        return this.storage.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return new MyIterator(this.storage.listIterator());
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        return new MyIterator(this.storage.listIterator(index));
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getChanging() {
        return IMutableViewableList.DefaultImpls.getChanging(this);
    }

    @Override
    public void adviseAddRemove(@NotNull Lifetime lifetime, @NotNull Function3<? super AddRemove, ? super Integer, ? super T, Unit> handler) {
        IMutableViewableList.DefaultImpls.adviseAddRemove(this, lifetime, handler);
    }

    @Override
    public void view(@NotNull Lifetime lifetime, @NotNull Function2<? super Lifetime, ? super Pair<Integer, ? extends T>, Unit> handler) {
        IMutableViewableList.DefaultImpls.view(this, lifetime, handler);
    }

    @Override
    public void view(@NotNull Lifetime lifetime, @NotNull Function3<? super Lifetime, ? super Integer, ? super T, Unit> handler) {
        IMutableViewableList.DefaultImpls.view(this, lifetime, handler);
    }

    public ViewableList() {
        this(null, 1, null);
    }

    @Override
    public <T> T[] toArray(T[] array2) {
        Intrinsics.checkNotNullParameter(array2, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array2);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010+\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\tJ\t\u0010\n\u001a\u00020\u000bH\u0096\u0003J\t\u0010\f\u001a\u00020\u000bH\u0096\u0001J\u000e\u0010\r\u001a\u00028\u0000H\u0096\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J\r\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0012\u001a\u00020\u0010H\u0096\u0001J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u0015\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rd/util/reactive/ViewableList$MyIterator;", "", "baseIterator", "(Lcom/jetbrains/rd/util/reactive/ViewableList;Ljava/util/ListIterator;)V", "getBaseIterator", "()Ljava/util/ListIterator;", "add", "", "element", "(Ljava/lang/Object;)V", "hasNext", "", "hasPrevious", "next", "()Ljava/lang/Object;", "nextIndex", "", "previous", "previousIndex", "remove", "set", "rd-core"})
    private final class MyIterator
    implements ListIterator<T>,
    KMutableListIterator {
        @NotNull
        private final ListIterator<T> baseIterator;

        public MyIterator(ListIterator<T> baseIterator) {
            Intrinsics.checkNotNullParameter(baseIterator, (String)"baseIterator");
            this.baseIterator = baseIterator;
        }

        @NotNull
        public final ListIterator<T> getBaseIterator() {
            return this.baseIterator;
        }

        @Override
        public boolean hasNext() {
            return this.baseIterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.baseIterator.hasPrevious();
        }

        @Override
        @NotNull
        public T next() {
            return this.baseIterator.next();
        }

        @Override
        public int nextIndex() {
            return this.baseIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.baseIterator.previousIndex();
        }

        @Override
        public void add(@NotNull T element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            this.baseIterator.add(element);
            ((Signal)ViewableList.this.getChange()).fire(new IViewableList.Event.Add(this.previousIndex(), element));
        }

        @Override
        public void remove() {
            int index = this.previousIndex();
            Object element = ViewableList.this.storage.get(index);
            this.baseIterator.remove();
            ((Signal)ViewableList.this.getChange()).fire(new IViewableList.Event.Remove(index, element));
        }

        @Override
        public void set(@NotNull T element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            int index = this.previousIndex();
            Object oldElement = ViewableList.this.storage.get(index);
            this.baseIterator.set(element);
            ((Signal)ViewableList.this.getChange()).fire(new IViewableList.Event.Update(index, oldElement, element));
        }

        @Override
        @NotNull
        public T previous() {
            throw new UnsupportedOperationException("Can't use previous here");
        }
    }
}

