/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.dap.xdebugger;

import com.intellij.icons.AllIcons;
import com.intellij.platform.dap.CommandScope;
import com.intellij.platform.dap.DapCommandProcessor;
import com.intellij.platform.dap.DapStackFrame;
import com.intellij.platform.dap.DapThread;
import com.intellij.platform.dap.DapThreadState;
import com.intellij.platform.dap.xdebugger.DapXDebuggerPresentationFactory;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\fH\u0016R\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lcom/intellij/platform/dap/xdebugger/DefaultDapXExecutionStack;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "factory", "Lcom/intellij/platform/dap/xdebugger/DapXDebuggerPresentationFactory;", "commandProcessor", "Lcom/intellij/platform/dap/DapCommandProcessor;", "thread", "Lcom/intellij/platform/dap/DapThread;", "isActive", "", "(Lcom/intellij/platform/dap/xdebugger/DapXDebuggerPresentationFactory;Lcom/intellij/platform/dap/DapCommandProcessor;Lcom/intellij/platform/dap/DapThread;Z)V", "_topFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "get_topFrame", "()Lcom/intellij/xdebugger/frame/XStackFrame;", "_topFrame$delegate", "Lkotlin/Lazy;", "getCommandProcessor", "()Lcom/intellij/platform/dap/DapCommandProcessor;", "getFactory", "()Lcom/intellij/platform/dap/xdebugger/DapXDebuggerPresentationFactory;", "()Z", "getThread", "()Lcom/intellij/platform/dap/DapThread;", "computeStackFrames", "", "firstFrameIndex", "", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "getTopFrame", "Companion", "intellij.platform.dap"})
@ApiStatus.Experimental
public final class DefaultDapXExecutionStack
extends XExecutionStack {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DapXDebuggerPresentationFactory factory;
    @NotNull
    private final DapCommandProcessor commandProcessor;
    @NotNull
    private final DapThread thread;
    private final boolean isActive;
    @NotNull
    private final Lazy _topFrame$delegate;

    public DefaultDapXExecutionStack(@NotNull DapXDebuggerPresentationFactory factory, @NotNull DapCommandProcessor commandProcessor, @NotNull DapThread thread2, boolean isActive) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)commandProcessor, (String)"commandProcessor");
        Intrinsics.checkNotNullParameter((Object)thread2, (String)"thread");
        super(thread2.getName(), Companion.getIcon(thread2.getState(), isActive));
        this.factory = factory;
        this.commandProcessor = commandProcessor;
        this.thread = thread2;
        this.isActive = isActive;
        this._topFrame$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XStackFrame>(this){
            final /* synthetic */ DefaultDapXExecutionStack this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final XStackFrame invoke() {
                XStackFrame xStackFrame;
                DapStackFrame dapStackFrame = this.this$0.getThread().getTopFrame();
                if (dapStackFrame != null) {
                    DapStackFrame dapStackFrame2 = dapStackFrame;
                    DefaultDapXExecutionStack defaultDapXExecutionStack = this.this$0;
                    DapStackFrame it = dapStackFrame2;
                    boolean bl = false;
                    DapXDebuggerPresentationFactory dapXDebuggerPresentationFactory = defaultDapXExecutionStack.getFactory();
                    DapCommandProcessor dapCommandProcessor = defaultDapXExecutionStack.getCommandProcessor();
                    DapThread dapThread = defaultDapXExecutionStack.getThread();
                    DapStackFrame dapStackFrame3 = defaultDapXExecutionStack.getThread().getTopFrame();
                    Intrinsics.checkNotNull((Object)dapStackFrame3);
                    xStackFrame = dapXDebuggerPresentationFactory.createStackFrame(dapCommandProcessor, dapThread, dapStackFrame3);
                } else {
                    xStackFrame = null;
                }
                return xStackFrame;
            }
        }));
    }

    @NotNull
    public final DapXDebuggerPresentationFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final DapCommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    @NotNull
    public final DapThread getThread() {
        return this.thread;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    private final XStackFrame get_topFrame() {
        Lazy lazy = this._topFrame$delegate;
        return (XStackFrame)lazy.getValue();
    }

    @Nullable
    public XStackFrame getTopFrame() {
        return this.get_topFrame();
    }

    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!(this.thread.getState() instanceof DapThreadState.Paused)) {
            container.errorOccurred(XDebuggerBundle.message((String)"debugger.frames.dialog.message.not.available.for.unsuspended", (Object[])new Object[0]));
            return;
        }
        this.commandProcessor.submitCommand((Function2<? super CommandScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CommandScope, Continuation<? super Unit>, Object>(this, container, firstFrameIndex, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DefaultDapXExecutionStack this$0;
            final /* synthetic */ XExecutionStack.XStackFrameContainer $container;
            final /* synthetic */ int $firstFrameIndex;
            {
                this.this$0 = $receiver;
                this.$container = $container;
                this.$firstFrameIndex = $firstFrameIndex;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var20_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$submitCommand = (CommandScope)this.L$0;
                        $this$invokeSuspend_u24lambda_u240 = this.this$0.getThread();
                        $i$a$-run-DefaultDapXExecutionStack$computeStackFrames$1$frames$1 = false;
                        this.label = 1;
                        v0 = $this$invokeSuspend_u24lambda_u240.stackFrames($this$submitCommand, (Continuation<? super List<? extends DapStackFrame>>)this);
                        if (v0 == var20_2) {
                            return var20_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        $i$a$-run-DefaultDapXExecutionStack$computeStackFrames$1$frames$1 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        frames = (List)v0;
                        var4_9 = frames.subList(this.$firstFrameIndex, frames.size());
                        var5_5 = this.$firstFrameIndex;
                        var6_7 = this.this$0;
                        var18_10 = this.$container;
                        $i$f$mapIndexed = false;
                        var8_12 = $this$mapIndexed$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                        $i$f$mapIndexedTo = false;
                        index$iv$iv = 0;
                        for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                            if ((var14_18 = index$iv$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            var15_19 = (DapStackFrame)item$iv$iv;
                            var16_20 = var14_18;
                            var19_22 = destination$iv$iv;
                            $i$a$-mapIndexed-DefaultDapXExecutionStack$computeStackFrames$1$1 = false;
                            var19_22.add(var5_5 + i == 0 ? DefaultDapXExecutionStack.access$get_topFrame(var6_7) : var6_7.getFactory().createStackFrame(var6_7.getCommandProcessor(), var6_7.getThread(), (DapStackFrame)frame));
                        }
                        var18_10.addStackFrames((List)destination$iv$iv, true);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CommandScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ XStackFrame access$get_topFrame(DefaultDapXExecutionStack $this) {
        return $this.get_topFrame();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/dap/xdebugger/DefaultDapXExecutionStack$Companion;", "", "()V", "getIcon", "Ljavax/swing/Icon;", "state", "Lcom/intellij/platform/dap/DapThreadState;", "isCurrent", "", "intellij.platform.dap"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Icon getIcon(@NotNull DapThreadState state, boolean isCurrent) {
            Icon icon;
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (isCurrent) {
                return AllIcons.Debugger.ThreadCurrent;
            }
            DapThreadState dapThreadState = state;
            if (Intrinsics.areEqual((Object)dapThreadState, (Object)DapThreadState.Running.INSTANCE)) {
                icon = AllIcons.Debugger.ThreadRunning;
            } else if (dapThreadState instanceof DapThreadState.Paused) {
                icon = !((Collection)((DapThreadState.Paused)state).getHitBreakpoints()).isEmpty() ? AllIcons.Debugger.ThreadAtBreakpoint : (((DapThreadState.Paused)state).getExceptionInfo() != null ? AllIcons.Debugger.Db_exception_breakpoint : AllIcons.Debugger.ThreadSuspended);
            } else if (Intrinsics.areEqual((Object)dapThreadState, (Object)DapThreadState.Exited.INSTANCE)) {
                icon = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return icon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

