/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.web.psi;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.rider.razor.highlighting.WebTemplateTextCreatorState;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/web/psi/WebTemplateDataElementType;", "Lcom/intellij/psi/templateLanguages/TemplateDataElementType;", "debugName", "", "language", "Lcom/intellij/lang/Language;", "templateElementType", "Lcom/intellij/psi/tree/IElementType;", "outerElementType", "transitionTokenTypes", "", "(Ljava/lang/String;Lcom/intellij/lang/Language;Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;Ljava/util/List;)V", "createTemplateText", "", "sourceCode", "baseLexer", "Lcom/intellij/lexer/Lexer;", "rangeCollector", "Lcom/intellij/psi/templateLanguages/TemplateDataElementType$RangeCollector;", "intellij.rider.plugins.razor"})
public abstract class WebTemplateDataElementType
extends TemplateDataElementType {
    @NotNull
    private final IElementType templateElementType;
    @NotNull
    private final List<IElementType> transitionTokenTypes;

    public WebTemplateDataElementType(@NotNull String debugName, @NotNull Language language, @NotNull IElementType templateElementType, @NotNull IElementType outerElementType, @NotNull List<? extends IElementType> transitionTokenTypes) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)templateElementType, (String)"templateElementType");
        Intrinsics.checkNotNullParameter((Object)outerElementType, (String)"outerElementType");
        Intrinsics.checkNotNullParameter(transitionTokenTypes, (String)"transitionTokenTypes");
        super(debugName, language, templateElementType, outerElementType);
        this.templateElementType = templateElementType;
        this.transitionTokenTypes = transitionTokenTypes;
    }

    public /* synthetic */ WebTemplateDataElementType(String string, Language language, IElementType iElementType, IElementType iElementType2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, language, iElementType, iElementType2, list);
    }

    @NotNull
    protected CharSequence createTemplateText(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer, @NotNull TemplateDataElementType.RangeCollector rangeCollector) {
        Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        Intrinsics.checkNotNullParameter((Object)rangeCollector, (String)"rangeCollector");
        baseLexer.start(sourceCode);
        WebTemplateTextCreatorState state = new WebTemplateTextCreatorState(sourceCode, this.templateElementType, this.transitionTokenTypes);
        StringBuilder result2 = new StringBuilder(sourceCode.length());
        TextRange textRange = TextRange.EMPTY_RANGE;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
        TextRange currentRange = textRange;
        while (baseLexer.getTokenType() != null) {
            boolean bl;
            boolean bl2 = bl = currentRange.getEndOffset() == baseLexer.getTokenStart();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Intrinsics.checkNotNullExpressionValue((Object)TextRange.create((int)baseLexer.getTokenStart(), (int)baseLexer.getTokenEnd()), (String)"create(...)");
            if (state.isTemplateToken(baseLexer.getTokenType())) {
                CharSequence charSequence = baseLexer.getTokenSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getTokenSequence(...)");
                String dummy = state.getDummyIfNeeded(charSequence);
                if (dummy != null) {
                    result2.append(dummy);
                    rangeCollector.addRangeToRemove(TextRange.from((int)baseLexer.getTokenStart(), (int)dummy.length()));
                }
                state.consumeTemplateRange(currentRange);
                result2.append(sourceCode, baseLexer.getTokenStart(), baseLexer.getTokenEnd());
            } else {
                state.consumeNonTemplateToken(baseLexer.getTokenType());
                rangeCollector.addOuterRange(currentRange);
            }
            state.savePreviousTokenType(baseLexer.getTokenType());
            baseLexer.advance();
        }
        return result2;
    }
}

