/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.services.formatting;

import com.intellij.openapi.util.TextRange;
import com.jetbrains.rider.model.FormatterOperation;
import com.jetbrains.rider.razor.services.formatting.FormatterOperationWithRange;
import com.jetbrains.rider.razor.services.formatting.RiderIndentRegion;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0002\u001a\u00020\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/razor/services/formatting/RiderFormattingNode;", "Lcom/jetbrains/rider/model/FormatterOperation;", "range", "Lcom/intellij/openapi/util/TextRange;", "elements", "", "Lcom/jetbrains/rider/razor/services/formatting/FormatterOperationWithRange;", "(Lcom/intellij/openapi/util/TextRange;Ljava/util/List;)V", "getElements", "()Ljava/util/List;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "findByRange", "Lkotlin/Triple;", "", "intellij.rider.plugins.razor"})
public class RiderFormattingNode
extends FormatterOperation {
    @NotNull
    private final TextRange range;
    @NotNull
    private final List<FormatterOperationWithRange> elements;

    public RiderFormattingNode(@NotNull TextRange range, @NotNull List<FormatterOperationWithRange> elements) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.range = range;
        this.elements = elements;
    }

    @NotNull
    public final TextRange getRange() {
        return this.range;
    }

    @NotNull
    public final List<FormatterOperationWithRange> getElements() {
        return this.elements;
    }

    @NotNull
    public final Triple<RiderFormattingNode, Integer, Integer> findByRange(@NotNull TextRange range) {
        FormatterOperationWithRange op;
        FormatterOperation operation;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (!this.range.contains(range)) {
            return new Triple((Object)this, (Object)0, (Object)CollectionsKt.getLastIndex(this.elements));
        }
        int startIndex2 = CollectionsKt.binarySearch$default(this.elements, (int)0, (int)0, (Function1)((Function1)new Function1<FormatterOperationWithRange, Integer>(range){
            final /* synthetic */ TextRange $range;
            {
                this.$range = $range;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull FormatterOperationWithRange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getRange().getEndOffset() <= this.$range.getStartOffset() ? -1 : (it.getRange().getStartOffset() > this.$range.getStartOffset() ? 1 : 0);
            }
        }), (int)3, null);
        if (startIndex2 >= 0 && (operation = (op = this.elements.get(startIndex2)).getOperation()) instanceof RiderIndentRegion && op.getRange().contains(range)) {
            return ((RiderIndentRegion)operation).findByRange(range);
        }
        startIndex2 = startIndex2 < 0 ? -(startIndex2 + 1) : startIndex2;
        int endIndex2 = CollectionsKt.binarySearch$default(this.elements, (int)0, (int)0, (Function1)((Function1)new Function1<FormatterOperationWithRange, Integer>(range){
            final /* synthetic */ TextRange $range;
            {
                this.$range = $range;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull FormatterOperationWithRange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getRange().getEndOffset() <= this.$range.getEndOffset() ? -1 : (it.getRange().getStartOffset() >= this.$range.getEndOffset() ? 1 : 0);
            }
        }), (int)3, null);
        endIndex2 = endIndex2 < 0 ? -(endIndex2 + 1) - 1 : endIndex2;
        return new Triple((Object)this, (Object)startIndex2, (Object)endIndex2);
    }
}

