/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.services.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.CustomFormattingModelBuilder;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.xml.template.formatter.TemplateFormatUtil;
import com.jetbrains.rider.razor.psi.RazorFileViewProvider;
import com.jetbrains.rider.razor.services.formatting.RiderFormatUtilsKt;
import com.jetbrains.rider.razor.services.formatting.RiderFormatterBlockMerger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/razor/services/formatting/RazorCssFormattingModelBuilder;", "Lcom/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder;", "Lcom/intellij/formatting/CustomFormattingModelBuilder;", "()V", "createExtension", "Lcom/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssFormattingExtension;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "isEngagedToFormat", "", "context", "Lcom/intellij/psi/PsiElement;", "RazorCssFormattingExtension", "intellij.rider.plugins.razor"})
public final class RazorCssFormattingModelBuilder
extends CssFormattingModelBuilder
implements CustomFormattingModelBuilder {
    public boolean isEngagedToFormat(@Nullable PsiElement context) {
        PsiFile psiFile;
        PsiElement psiElement = context;
        PsiFile psiFile2 = psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        return (psiFile2 != null ? psiFile2.getViewProvider() : null) instanceof RazorFileViewProvider;
    }

    @NotNull
    protected CssFormattingModelBuilder.CssFormattingExtension createExtension(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)CSSLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(CssCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        return new RazorCssFormattingExtension(settings, commonCodeStyleSettings, (CssCodeStyleSettings)customCodeStyleSettings);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0016J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/razor/services/formatting/RazorCssFormattingModelBuilder$RazorCssFormattingExtension;", "Lcom/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssFormattingExtension;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "commonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "customSettings", "Lcom/intellij/psi/css/codeStyle/CssCodeStyleSettings;", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;Lcom/intellij/psi/css/codeStyle/CssCodeStyleSettings;)V", "getSettings", "()Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "createOuterLanguageBlock", "Lcom/intellij/formatting/Block;", "element", "Lcom/intellij/psi/templateLanguages/OuterLanguageElement;", "modifySpacingInCaseOfTemplateBlocks", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "defaultSpacing", "modifySubBlocksIfNeeded", "", "parentNode", "Lcom/intellij/lang/ASTNode;", "list", "intellij.rider.plugins.razor"})
    public static final class RazorCssFormattingExtension
    extends CssFormattingModelBuilder.CssFormattingExtension {
        @NotNull
        private final CodeStyleSettings settings;

        public RazorCssFormattingExtension(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings commonSettings, @NotNull CssCodeStyleSettings customSettings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)commonSettings, (String)"commonSettings");
            Intrinsics.checkNotNullParameter((Object)customSettings, (String)"customSettings");
            super(commonSettings, customSettings);
            this.settings = settings;
        }

        @NotNull
        public final CodeStyleSettings getSettings() {
            return this.settings;
        }

        @NotNull
        public Block createOuterLanguageBlock(@NotNull OuterLanguageElement element) {
            Block block;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Block block2 = TemplateFormatUtil.buildTemplateLanguageBlock((OuterLanguageElement)element, (CodeStyleSettings)this.settings, null);
            if (block2 == null) {
                Block block3 = super.createOuterLanguageBlock(element);
                block = block3;
                Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"createOuterLanguageBlock(...)");
            } else {
                block = block2;
            }
            return block;
        }

        @NotNull
        public List<Block> modifySubBlocksIfNeeded(@NotNull ASTNode parentNode, @NotNull List<Block> list) {
            Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
            Intrinsics.checkNotNullParameter(list, (String)"list");
            PsiFile psiFile = parentNode.getPsi().getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            return RiderFormatterBlockMerger.INSTANCE.modifySubBlocksIfNeeded$intellij_rider_plugins_razor(list, psiFile);
        }

        @Nullable
        public Spacing modifySpacingInCaseOfTemplateBlocks(@Nullable Block child1, @NotNull Block child2, @Nullable Spacing defaultSpacing) {
            Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
            return RiderFormatUtilsKt.getRiderSpacing(child1, child2, defaultSpacing);
        }
    }
}

