/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.razor.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.completion.CompletionSessionHeuristics;
import com.jetbrains.rider.completion.CompletionSessionStrategy;
import com.jetbrains.rider.razor.psi.RazorTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J1\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/razor/completion/RazorCompletionStrategy;", "Lcom/jetbrains/rider/completion/CompletionSessionStrategy;", "()V", "shouldExpectFrontendCompletion", "", "shouldForbidCompletion", "editor", "Lcom/intellij/openapi/editor/Editor;", "type", "Lcom/intellij/codeInsight/completion/CompletionType;", "shouldRescheduleCompletion", "prefix", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "char", "", "offset", "", "(Ljava/lang/String;Lcom/intellij/psi/PsiFile;Ljava/lang/Character;I)Ljava/lang/Boolean;", "intellij.rider.plugins.razor"})
public final class RazorCompletionStrategy
implements CompletionSessionStrategy {
    @Nullable
    public Boolean shouldRescheduleCompletion(@NotNull String prefix, @NotNull PsiFile psiFile, @Nullable Character c, int offset) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!RazorTreeUtilKt.isRazorFile(psiFile)) {
            return false;
        }
        Character c2 = c;
        char c3 = '@';
        if (c2 != null && c2.charValue() == c3) {
            return true;
        }
        Character c4 = c;
        c3 = '-';
        if (c4 != null && c4.charValue() == c3) {
            return false;
        }
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return CompletionSessionHeuristics.Companion.getInstance(project).shouldRescheduleDefaultStrategy(c);
    }

    public boolean shouldForbidCompletion(@NotNull Editor editor, @NotNull CompletionType type) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    public boolean shouldExpectFrontendCompletion() {
        return true;
    }
}

