/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.blazor.wasm.wip;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.RollingFileHandler;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.wip.protocol.CommandResponse;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J \u0010\f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0006J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/blazor/wasm/wip/BlazorWasmWipLogger;", "", "javaLogger", "Ljava/util/logging/Logger;", "(Ljava/util/logging/Logger;)V", "formatCommandLogEntry", "", "kind", "id", "", "methodName", "result", "formatErrorLogEntry", "error", "Lorg/jetbrains/wip/protocol/CommandResponse$ErrorInfo;", "formatEventLogEntry", "params", "logErrorResponseMessage", "", "logEventMessage", "paramsJson", "logInfo", "message", "logRequestMessage", "logResultResponseMessage", "resultJson", "Companion", "LoggerFormatter", "intellij.rider.plugins.razor"})
public final class BlazorWasmWipLogger {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Logger javaLogger;
    private static final String lineSeparator;
    @NotNull
    private static final ObjectMapper json;
    private static final Logger internalLoggerInstance;

    public BlazorWasmWipLogger(@NotNull Logger javaLogger) {
        Intrinsics.checkNotNullParameter((Object)javaLogger, (String)"javaLogger");
        this.javaLogger = javaLogger;
    }

    public final void logInfo(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.javaLogger.info(message);
    }

    public final void logResultResponseMessage(int id, @NotNull String methodName, @NotNull String resultJson) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)resultJson, (String)"resultJson");
        this.javaLogger.info(this.formatCommandLogEntry("RESPONSE", id, methodName, resultJson));
    }

    public final void logErrorResponseMessage(int id, @NotNull String methodName, @NotNull CommandResponse.ErrorInfo error) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.javaLogger.warning(this.formatErrorLogEntry(id, methodName, error));
    }

    public final void logRequestMessage(int id, @NotNull String methodName, @NotNull String paramsJson) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)paramsJson, (String)"paramsJson");
        this.javaLogger.info(this.formatCommandLogEntry("REQUEST", id, methodName, paramsJson));
    }

    public final void logEventMessage(@NotNull String methodName, @NotNull String paramsJson) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)paramsJson, (String)"paramsJson");
        this.javaLogger.info(this.formatEventLogEntry(methodName, paramsJson));
    }

    private final String formatCommandLogEntry(String kind, int id, String methodName, String result2) {
        return StringsKt.padEnd$default((String)kind, (int)8, (char)'\u0000', (int)2, null) + " " + StringsKt.padEnd$default((String)("(" + id + ")"), (int)5, (char)'\u0000', (int)2, null) + " [" + methodName + "] " + result2;
    }

    private final String formatEventLogEntry(String methodName, String params) {
        return StringsKt.padEnd$default((String)"EVENT", (int)8, (char)'\u0000', (int)2, null) + "       [" + methodName + "] " + params;
    }

    private final String formatErrorLogEntry(int id, String methodName, CommandResponse.ErrorInfo error) {
        StringBuilder stringBuilder;
        StringBuilder $this$formatErrorLogEntry_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$formatErrorLogEntry_u24lambda_u240.append(StringsKt.padEnd$default((String)"ERROR", (int)8, (char)'\u0000', (int)2, null) + " " + StringsKt.padEnd$default((String)("(" + id + ")"), (int)5, (char)'\u0000', (int)2, null) + " [" + methodName + "]:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$formatErrorLogEntry_u24lambda_u240.append("    Message: " + error.message());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$formatErrorLogEntry_u24lambda_u240;
        JsonReaderEx jsonReaderEx = error.result();
        StringBuilder stringBuilder5 = stringBuilder4.append("    JSON:    " + (jsonReaderEx != null ? jsonReaderEx.getSourceSequence() : null));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder6 = $this$formatErrorLogEntry_u24lambda_u240.append("    Code:    " + error.code());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder7 = $this$formatErrorLogEntry_u24lambda_u240.append("    Data:    " + error.data());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        Logger logger2;
        Companion = new Companion(null);
        lineSeparator = System.lineSeparator();
        json = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null);
        Logger $this$internalLoggerInstance_u24lambda_u242 = logger2 = Logger.getLogger("blazor-wip");
        boolean bl = false;
        String string = PathManager.getLogPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLogPath(...)");
        String string2 = string;
        String[] stringArray = new String[]{"blazor-wip-protocol.log"};
        Path path = Paths.get(string2, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        String $this$internalLoggerInstance_u24lambda_u242_u24lambda_u241 = string2 = new RollingFileHandler(path, 50000000L, 6, false, null);
        boolean bl2 = false;
        $this$internalLoggerInstance_u24lambda_u242_u24lambda_u241.setFormatter((Formatter)new LoggerFormatter());
        $this$internalLoggerInstance_u24lambda_u242_u24lambda_u241.setLevel(Level.FINER);
        String handler = string2;
        $this$internalLoggerInstance_u24lambda_u242.setUseParentHandlers(false);
        $this$internalLoggerInstance_u24lambda_u242.addHandler((Handler)((Object)handler));
        internalLoggerInstance = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/blazor/wasm/wip/BlazorWasmWipLogger$Companion;", "", "()V", "internalLoggerInstance", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "json", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "lineSeparator", "", "getInstance", "Lcom/jetbrains/rider/blazor/wasm/wip/BlazorWasmWipLogger;", "intellij.rider.plugins.razor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlazorWasmWipLogger getInstance() {
            Logger logger2 = internalLoggerInstance;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"access$getInternalLoggerInstance$cp(...)");
            return new BlazorWasmWipLogger(logger2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/blazor/wasm/wip/BlazorWasmWipLogger$LoggerFormatter;", "Ljava/util/logging/Formatter;", "()V", "dateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "format", "", "record", "Ljava/util/logging/LogRecord;", "intellij.rider.plugins.razor"})
    @SourceDebugExtension(value={"SMAP\nBlazorWasmWipLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlazorWasmWipLogger.kt\ncom/jetbrains/rider/blazor/wasm/wip/BlazorWasmWipLogger$LoggerFormatter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
    private static final class LoggerFormatter
    extends Formatter {
        private final DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendInstant(3).toFormatter();

        @Override
        @NotNull
        public String format(@Nullable LogRecord record) {
            Object object;
            String string;
            String string2;
            if (record == null) {
                String string3 = lineSeparator;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"access$getLineSeparator$cp(...)");
                return string3;
            }
            Instant instant = record.getInstant();
            if (instant != null) {
                Instant instant2 = instant;
                DateTimeFormatter dateTimeFormatter = this.dateTimeFormatter;
                Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"dateTimeFormatter");
                DateTimeFormatter dateTimeFormatter2 = dateTimeFormatter;
                TemporalAccessor p0 = instant2;
                boolean bl = false;
                string2 = dateTimeFormatter2.format(p0);
            } else {
                string2 = null;
            }
            String dateTime = string2;
            Throwable throwable = record.getThrown();
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                string = lineSeparator + it + lineSeparator + ExceptionsKt.stackTraceToString((Throwable)it);
            } else {
                string = null;
            }
            String error = string;
            String string4 = record.getLevel().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            String level = StringsKt.take((String)string4, (int)4);
            String string5 = record.getMessage();
            if (string5 == null) {
                string5 = "";
            }
            if ((object = error) == null) {
                object = "";
            }
            String message = string5 + (String)object;
            return dateTime + " | " + level + " : " + message + " " + lineSeparator;
        }
    }
}

