/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.blazor.wasm.browser;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PathUtil;
import com.jetbrains.rider.RiderRazorBundle;
import com.jetbrains.rider.blazor.wasm.BlazorWasmDebugNotificationsUtil;
import com.jetbrains.rider.blazor.wasm.browser.BlazorWasmBrowserUtil;
import com.jetbrains.rider.blazor.wasm.browser.BrowserSessionBuilder;
import com.jetbrains.rider.blazor.wasm.browser.BrowserSessionInstance;
import com.jetbrains.rider.blazor.wasm.browser.BrowserSessionLauncher;
import com.jetbrains.rider.blazor.wasm.stateMachine.BlazorWasmDebugState;
import com.jetbrains.rider.blazor.wasm.stateMachine.BlazorWasmDebugStateNotifier;
import com.jetbrains.rider.debugger.settings.DotNetDebuggerSettings;
import com.jetbrains.rider.run.TerminalProcessHandler;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 22\u00020\u0001:\u00012B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\"\u0010!\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\u001fH\u0002J\b\u0010&\u001a\u00020\u001bH\u0002J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u0011H\u0002J\u0016\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020$H\u0086@\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u0003H\u0002J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u0003H\u0002J\u001e\u00100\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0082@\u00a2\u0006\u0002\u00101R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\u00a8\u00063"}, d2={"Lcom/jetbrains/rider/blazor/wasm/browser/BrowserSessionLauncher;", "", "pageUrl", "", "userDataDir", "stdErrFile", "Ljava/io/File;", "remoteDebuggingPort", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "sessionId", "notifier", "Lcom/jetbrains/rider/blazor/wasm/stateMachine/BlazorWasmDebugStateNotifier;", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;ILcom/intellij/execution/configurations/GeneralCommandLine;Ljava/lang/String;Lcom/jetbrains/rider/blazor/wasm/stateMachine/BlazorWasmDebugStateNotifier;)V", "devtoolsUriFuture", "Lkotlinx/coroutines/CompletableDeferred;", "Ljava/net/URI;", "getPageUrl", "()Ljava/lang/String;", "proposedUri", "getRemoteDebuggingPort", "()I", "getStdErrFile", "()Ljava/io/File;", "getUserDataDir", "attachDevToolsListener", "", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "checkChromeLockExists", "", "checkErrorFile", "checkPortFile", "Lcom/jetbrains/rider/run/TerminalProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "throwOnPortFileNotExist", "clearPreviousDevToolsPortFile", "complete", "uri", "launchBrowser", "Lcom/jetbrains/rider/blazor/wasm/browser/BrowserSessionInstance;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logLdd", "path", "processUriString", "text", "waitOrBreak", "(Lcom/jetbrains/rider/run/TerminalProcessHandler;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.rider.plugins.razor"})
@SourceDebugExtension(value={"SMAP\nBrowserSessionLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserSessionLauncher.kt\ncom/jetbrains/rider/blazor/wasm/browser/BrowserSessionLauncher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1#2:321\n*E\n"})
public final class BrowserSessionLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pageUrl;
    @NotNull
    private final String userDataDir;
    @NotNull
    private final File stdErrFile;
    private final int remoteDebuggingPort;
    @NotNull
    private final GeneralCommandLine commandLine;
    @NotNull
    private final String sessionId;
    @NotNull
    private final BlazorWasmDebugStateNotifier notifier;
    @NotNull
    private final URI proposedUri;
    @NotNull
    private final CompletableDeferred<URI> devtoolsUriFuture;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Pattern devToolsPattern;
    @NotNull
    public static final String exposedPortFileName = "DevToolsActivePort";

    public BrowserSessionLauncher(@NotNull String pageUrl, @NotNull String userDataDir, @NotNull File stdErrFile, int remoteDebuggingPort, @NotNull GeneralCommandLine commandLine, @NotNull String sessionId, @NotNull BlazorWasmDebugStateNotifier notifier) {
        Intrinsics.checkNotNullParameter((Object)pageUrl, (String)"pageUrl");
        Intrinsics.checkNotNullParameter((Object)userDataDir, (String)"userDataDir");
        Intrinsics.checkNotNullParameter((Object)stdErrFile, (String)"stdErrFile");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)notifier, (String)"notifier");
        this.pageUrl = pageUrl;
        this.userDataDir = userDataDir;
        this.stdErrFile = stdErrFile;
        this.remoteDebuggingPort = remoteDebuggingPort;
        this.commandLine = commandLine;
        this.sessionId = sessionId;
        this.notifier = notifier;
        this.proposedUri = new URI("https://localhost:" + this.remoteDebuggingPort);
        this.devtoolsUriFuture = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    }

    @NotNull
    public final String getPageUrl() {
        return this.pageUrl;
    }

    @NotNull
    public final String getUserDataDir() {
        return this.userDataDir;
    }

    @NotNull
    public final File getStdErrFile() {
        return this.stdErrFile;
    }

    public final int getRemoteDebuggingPort() {
        return this.remoteDebuggingPort;
    }

    private final void logLdd(String path) {
        if (SystemInfo.isLinux && ApplicationKt.getApplication().isUnitTestMode()) {
            String string = BrowserSessionBuilder.Companion.getBrowserPath();
            Intrinsics.checkNotNull((Object)string);
            String libs = new File(PathUtil.getParentPath((String)string), "lib").getCanonicalPath();
            Object object = new String[]{"/usr/bin/ldd", path};
            Object $this$logLdd_u24lambda_u240 = object = new ProcessBuilder((String[])object);
            boolean bl = false;
            Map<String, String> map = ((ProcessBuilder)$this$logLdd_u24lambda_u240).environment();
            Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
            Map<String, String> map2 = map;
            map2.put("LD_LIBRARY_PATH", libs);
            Process process = ((ProcessBuilder)object).start();
            OSProcessHandler handler = new OSProcessHandler(process, "blazor ldd");
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    if (Intrinsics.areEqual(outputType, (Object)ProcessOutputType.STDOUT)) {
                        BrowserSessionLauncher.access$getLogger$cp().info("ldd: " + event.getText());
                    }
                }
            });
            handler.startNotify();
            if (!process.waitFor(10L, TimeUnit.SECONDS)) {
                process.destroyForcibly();
            }
        }
    }

    private final boolean checkChromeLockExists() {
        boolean bl;
        File userDataDirFile = new File(this.userDataDir);
        if (SystemInfo.isWindows) {
            bl = FilesKt.resolve((File)userDataDirFile, (String)"lockfile").exists();
        } else if (SystemInfo.isUnix) {
            Object[] objectArray = userDataDirFile.list(BrowserSessionLauncher::checkChromeLockExists$lambda$1);
            bl = objectArray != null ? ArraysKt.any((Object[])objectArray) : false;
        } else {
            logger.warn("trying to check chrome lockfile on unsupported platform: " + SystemInfo.OS_NAME + ", " + SystemInfo.OS_VERSION + ", " + SystemInfo.OS_ARCH);
            return false;
        }
        return bl;
    }

    private final void clearPreviousDevToolsPortFile() {
        File devToolPortFile = new File(this.userDataDir, exposedPortFileName);
        boolean lockFileExists = this.checkChromeLockExists();
        if (!lockFileExists) {
            try {
                Files.deleteIfExists(devToolPortFile.toPath());
            }
            catch (Exception e) {
                logger.info("DevToolsActivePort delete failed, reason: ", (Throwable)e);
                Object[] objectArray = new Object[]{this.userDataDir};
                throw new CantRunException(RiderRazorBundle.Companion.message("blazor.wasm.debug.exception.access.userdatadir", objectArray));
            }
        } else if (devToolPortFile.exists()) {
            BlazorWasmDebugNotificationsUtil.INSTANCE.notifyInfoSilent(RiderRazorBundle.Companion.message("blazor.wasm.debug.notification.lockfile.ok", new Object[0]), this.notifier.getProject());
        } else {
            Object[] objectArray = new Object[]{this.userDataDir};
            BlazorWasmDebugNotificationsUtil.INSTANCE.notifyWarningBalloon(RiderRazorBundle.Companion.message("blazor.wasm.debug.notification.lockfile.force", objectArray), this.notifier.getProject());
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object launchBrowser(@NotNull Project var1_1, @NotNull Continuation<? super BrowserSessionInstance> var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[SWITCH], 4[CASE]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void complete(URI uri) {
        BlazorWasmDebugStateNotifier.notify$default(this.notifier, BlazorWasmDebugState.COMPLETING_URI, null, 2, null);
        this.devtoolsUriFuture.complete((Object)uri);
    }

    private final boolean processUriString(String text) {
        Matcher matcher = devToolsPattern.matcher(text);
        if (matcher.find()) {
            String group = matcher.group("url");
            URI uri = new URI(group);
            logger.info("devToolsUri found: " + uri);
            this.complete(uri);
            return true;
        }
        return false;
    }

    private final void attachDevToolsListener(ProcessHandler processHandler2) {
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(this, processHandler2){
            final /* synthetic */ BrowserSessionLauncher this$0;
            final /* synthetic */ ProcessHandler $processHandler;
            {
                this.this$0 = $receiver;
                this.$processHandler = $processHandler;
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                String text = event.getText();
                BrowserSessionLauncher.access$getLogger$cp().info(text);
                if (!BrowserSessionLauncher.access$getDevtoolsUriFuture$p(this.this$0).isCompleted() && Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDERR)) {
                    Intrinsics.checkNotNull((Object)text);
                    if (BrowserSessionLauncher.access$processUriString(this.this$0, text) && !DotNetDebuggerSettings.Companion.getInstance().getEnableBrowserLogs()) {
                        this.$processHandler.removeProcessListener((ProcessListener)this);
                    }
                }
            }
        });
    }

    private final boolean checkErrorFile() {
        if (!this.stdErrFile.exists()) {
            logger.info("stderr file don't exist");
            return false;
        }
        logger.info("searching in stderr file");
        List fileLines = FilesKt.readLines$default((File)this.stdErrFile, null, (int)1, null);
        for (String line : CollectionsKt.asReversed((List)fileLines)) {
            logger.trace("searching in line " + line);
            if (!this.processUriString(line)) continue;
            return true;
        }
        logger.info("stderr file did not contain devtools uri");
        return false;
    }

    private final boolean checkPortFile(TerminalProcessHandler processHandler2, Project project, boolean throwOnPortFileNotExist) {
        File userDataDir;
        File portFile;
        if (throwOnPortFileNotExist) {
            BlazorWasmDebugStateNotifier.notify$default(this.notifier, BlazorWasmDebugState.CHECKING_PORT_FILE, null, 2, null);
        }
        if (!(portFile = new File(userDataDir = new File(this.userDataDir), exposedPortFileName)).exists()) {
            logger.info("port file does not exist");
            BrowserSessionLauncher.checkPortFile$checkOrThrow(throwOnPortFileNotExist, processHandler2, this, project);
            return false;
        }
        List portFileContent = FilesKt.readLines$default((File)portFile, null, (int)1, null);
        int devToolsPort = Integer.parseInt((String)CollectionsKt.first((List)portFileContent));
        String devToolsPath = (String)CollectionsKt.last((List)portFileContent);
        URI resultUri = new URI("https://localhost:" + devToolsPort + devToolsPath);
        this.complete(resultUri);
        logger.info("DevTools uri obtained from port file: " + resultUri);
        return true;
    }

    static /* synthetic */ boolean checkPortFile$default(BrowserSessionLauncher browserSessionLauncher, TerminalProcessHandler terminalProcessHandler, Project project, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return browserSessionLauncher.checkPortFile(terminalProcessHandler, project, bl);
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitOrBreak(TerminalProcessHandler var1_1, Project var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof waitOrBreak.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ BrowserSessionLauncher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BrowserSessionLauncher.access$waitOrBreak(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                ApplicationManager.getApplication().assertIsNonDispatchThread();
                var4_7 = processHandler.isStartNotified();
                if (_Assertions.ENABLED && !var4_7) {
                    var5_9 = "Assertion failed";
                    throw new AssertionError((Object)var5_9);
                }
                BlazorWasmDebugStateNotifier.notify$default(this.notifier, BlazorWasmDebugState.SPINNING_FOR_DEVTOOLS, null, 2, null);
                $continuation.L$0 = this;
                $continuation.L$1 = processHandler;
                $continuation.L$2 = project;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeout((long)6000L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, processHandler, project, null){
                    int label;
                    final /* synthetic */ BrowserSessionLauncher this$0;
                    final /* synthetic */ TerminalProcessHandler $processHandler;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$processHandler = $processHandler;
                        this.$project = $project;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        block0 : switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
lbl6:
                                // 2 sources

                                while (true) {
                                    BrowserSessionLauncher.access$getLogger$cp().info("spinning on devTools");
                                    if (SystemInfo.isMacOSBigSur && BrowserSessionLauncher.access$checkErrorFile(this.this$0) || BrowserSessionLauncher.checkPortFile$default(this.this$0, this.$processHandler, this.$project, false, 4, null)) break block0;
                                    BlazorWasmBrowserUtil.INSTANCE.checkBrowserExists(this.$processHandler, BrowserSessionLauncher.access$getNotifier$p(this.this$0));
                                    if (BrowserSessionLauncher.access$getDevtoolsUriFuture$p(this.this$0).isCompleted() || BrowserSessionLauncher.access$getDevtoolsUriFuture$p(this.this$0).isCancelled()) break block0;
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)150L, (Continuation)((Continuation)this));
                                    if (v0 != var2_2) continue;
                                    return var2_2;
                                }
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** continue;
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var8_6) goto lbl27
lbl26:
                // 1 sources

                return var8_6;
lbl27:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                project = (Project)$continuation.L$2;
                processHandler = (TerminalProcessHandler)$continuation.L$1;
                this = (BrowserSessionLauncher)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (TimeoutCancellationException var4_8) {
                    BrowserSessionLauncher.logger.info("after 6 seconds of waiting browser dev tools uri was not obtained, trying to obtain from DevToolPort file");
                    this.checkPortFile(processHandler, project, true);
                }
lbl41:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final boolean checkChromeLockExists$lambda$1(File file, String name) {
        String string = name;
        return string != null ? StringsKt.startsWith$default((String)string, (String)"SingletonLock", (boolean)false, (int)2, null) : false;
    }

    private static final void checkPortFile$checkOrThrow(boolean $throwOnPortFileNotExist, TerminalProcessHandler $processHandler, BrowserSessionLauncher this$0, Project $project) {
        if (!$throwOnPortFileNotExist || !BlazorWasmBrowserUtil.INSTANCE.checkBrowserExists($processHandler, this$0.notifier)) {
            return;
        }
        String message = RiderRazorBundle.Companion.message("blazor.wasm.debug.gateway.notification.text", new Object[0]);
        BlazorWasmDebugNotificationsUtil.INSTANCE.notifyWarningBalloon(message, $project);
        BlazorWasmDebugStateNotifier.notify$default(this$0.notifier, BlazorWasmDebugState.PORT_FILE_NOT_EXISTS, null, 2, null);
        throw new CantRunException(RiderRazorBundle.Companion.message("blazor.wasm.debug.gateway.exception.text", new Object[0]));
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ CompletableDeferred access$getDevtoolsUriFuture$p(BrowserSessionLauncher $this) {
        return $this.devtoolsUriFuture;
    }

    public static final /* synthetic */ boolean access$processUriString(BrowserSessionLauncher $this, String text) {
        return $this.processUriString(text);
    }

    public static final /* synthetic */ Object access$waitOrBreak(BrowserSessionLauncher $this, TerminalProcessHandler processHandler2, Project project, Continuation $completion) {
        return $this.waitOrBreak(processHandler2, project, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ boolean access$checkErrorFile(BrowserSessionLauncher $this) {
        return $this.checkErrorFile();
    }

    public static final /* synthetic */ BlazorWasmDebugStateNotifier access$getNotifier$p(BrowserSessionLauncher $this) {
        return $this.notifier;
    }

    static {
        Logger logger2 = Logger.getInstance(((Object)((Object)Companion.logger.1.INSTANCE)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
        Pattern pattern = Pattern.compile("^\\s*DevTools listening on (?<url>.*)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        devToolsPattern = pattern;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/blazor/wasm/browser/BrowserSessionLauncher$Companion;", "", "()V", "devToolsPattern", "Ljava/util/regex/Pattern;", "exposedPortFileName", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rider.plugins.razor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

