/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.asp.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.rider.asp.AspFileElementTypes;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0006H\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0014J\b\u0010\u0017\u001a\u00020\nH\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\n0\u000fj\b\u0012\u0004\u0012\u00020\n`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/asp/psi/AspFileViewProvider;", "Lcom/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider;", "Lcom/intellij/psi/templateLanguages/TemplateLanguageFileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "physical", "", "language", "Lcom/intellij/lang/Language;", "templateLanguage", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;ZLcom/intellij/lang/Language;Lcom/intellij/lang/Language;)V", "_baseLanguage", "_languages", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "_templateDataLanguage", "cloneInner", "virtualFile", "createFile", "Lcom/intellij/psi/PsiFile;", "lang", "getBaseLanguage", "getLanguages", "", "getTemplateDataLanguage", "intellij.rider.plugins.razor"})
public final class AspFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    @NotNull
    private final Language _baseLanguage;
    @NotNull
    private final Language _templateDataLanguage;
    @NotNull
    private final HashSet<Language> _languages;

    public AspFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file, boolean physical, @NotNull Language language, @NotNull Language templateLanguage) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)templateLanguage, (String)"templateLanguage");
        super(manager, file, physical);
        this._baseLanguage = language;
        this._templateDataLanguage = templateLanguage;
        Object[] objectArray = new Language[]{this._baseLanguage, this._templateDataLanguage, CSharpLanguage.INSTANCE};
        this._languages = SetsKt.hashSetOf((Object[])objectArray);
    }

    @NotNull
    public Language getBaseLanguage() {
        return this._baseLanguage;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        return this._templateDataLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        return this._languages;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        if (lang == this.getTemplateDataLanguage()) {
            Object object = LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            Intrinsics.checkNotNull((Object)object);
            PsiFile psiFile2 = ((ParserDefinition)object).createFile((FileViewProvider)this);
            Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            PsiFileImpl file = (PsiFileImpl)psiFile2;
            file.setContentElementType((IElementType)AspFileElementTypes.TEMPLATE_DATA);
            return (PsiFile)file;
        }
        if (Intrinsics.areEqual((Object)lang, (Object)CSharpLanguage.INSTANCE)) {
            Object object = LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            Intrinsics.checkNotNull((Object)object);
            PsiFile psiFile3 = ((ParserDefinition)object).createFile((FileViewProvider)this);
            Intrinsics.checkNotNull((Object)psiFile3, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            PsiFileImpl file = (PsiFileImpl)psiFile3;
            file.setContentElementType((IElementType)AspFileElementTypes.ASP_CODE_DATA);
            return (PsiFile)file;
        }
        if (lang == this.getBaseLanguage()) {
            Object object = LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            Intrinsics.checkNotNull((Object)object);
            psiFile = ((ParserDefinition)object).createFile((FileViewProvider)this);
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"getManager(...)");
        return new AspFileViewProvider((PsiManager)psiManagerEx, virtualFile, false, this.getBaseLanguage(), this.getTemplateDataLanguage());
    }
}

