/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.angular2.inspections.quickfixes.Angular2FixesPsiUtil;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0005H\u0017J\b\u0010\r\u001a\u00020\u0005H\u0017J)\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0096\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/angular2/inspections/quickfixes/AddJSPropertyQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "objectLiteral", "Lcom/intellij/lang/javascript/psi/JSObjectLiteralExpression;", "myPropertyName", "", "myValue", "myCaretOffset", "", "myUseTemplateString", "", "(Lcom/intellij/lang/javascript/psi/JSObjectLiteralExpression;Ljava/lang/String;Ljava/lang/String;IZ)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "Companion", "intellij.angular"})
public final class AddJSPropertyQuickFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String myPropertyName;
    @NotNull
    private final String myValue;
    private final int myCaretOffset;
    private final boolean myUseTemplateString;
    @NonNls
    @NotNull
    private static final String CARET_MARKER = "___caret___";

    public AddJSPropertyQuickFix(@NotNull JSObjectLiteralExpression objectLiteral, @NotNull String myPropertyName, @NotNull String myValue, int myCaretOffset, boolean myUseTemplateString) {
        Intrinsics.checkNotNullParameter((Object)objectLiteral, (String)"objectLiteral");
        Intrinsics.checkNotNullParameter((Object)myPropertyName, (String)"myPropertyName");
        Intrinsics.checkNotNullParameter((Object)myValue, (String)"myValue");
        super((PsiElement)objectLiteral);
        this.myPropertyName = myPropertyName;
        this.myValue = myValue;
        this.myCaretOffset = myCaretOffset;
        this.myUseTemplateString = myUseTemplateString;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.myPropertyName};
        return Angular2Bundle.Companion.message("angular.quickfix.decorator.add-property.name", objectArray);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return Angular2Bundle.Companion.message("angular.quickfix.decorator.add-property.family", new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        JSObjectLiteralExpression jSObjectLiteralExpression = startElement instanceof JSObjectLiteralExpression ? (JSObjectLiteralExpression)startElement : null;
        if (jSObjectLiteralExpression == null) {
            return;
        }
        JSObjectLiteralExpression objectLiteral = jSObjectLiteralExpression;
        if (this.myUseTemplateString) {
            string2 = "`";
        } else {
            String string3 = JSCodeStyleSettings.getQuote((PsiElement)((PsiElement)objectLiteral));
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getQuote(...)");
        }
        String quote = string2;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)objectLiteral.getProject());
        Document document = documentManager.getDocument(objectLiteral.getContainingFile());
        if (document == null) {
            string = quote + this.myValue + quote;
        } else {
            String string4 = this.myValue.substring(0, this.myCaretOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String string5 = this.myValue.substring(this.myCaretOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string = quote + string4 + CARET_MARKER + string5 + quote;
        }
        String value = string;
        JSProperty added = Angular2FixesPsiUtil.insertJSObjectLiteralProperty$default(Angular2FixesPsiUtil.INSTANCE, objectLiteral, this.myPropertyName, value, false, false, 24, null);
        JSExpression jSExpression = added.getValue();
        Intrinsics.checkNotNull((Object)jSExpression);
        JSExpression valueExpression = jSExpression;
        if (document == null) {
            return;
        }
        int n = valueExpression.getTextOffset();
        String string6 = valueExpression.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
        int caretOffset = n + StringsKt.indexOf$default((CharSequence)string6, (String)CARET_MARKER, (int)0, (boolean)false, (int)6, null);
        VirtualFile targetFile = added.getContainingFile().getVirtualFile();
        document.replaceString(caretOffset, caretOffset + 11, (CharSequence)"");
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiNavigationSupport.getInstance().createNavigatable(project, targetFile, caretOffset).navigate(true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/angular2/inspections/quickfixes/AddJSPropertyQuickFix$Companion;", "", "()V", "CARET_MARKER", "", "intellij.angular"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

