/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderContent;
import org.intellij.plugins.markdown.lang.psi.util.AstUtilsKt;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0011\u0010\t\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeaderContent;", "Lcom/intellij/extapi/psi/ASTWrapperPsiElement;", "Lorg/intellij/plugins/markdown/lang/psi/MarkdownPsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "isAtxContent", "", "()Z", "isSetextContent", "nonWhitespaceRange", "Lcom/intellij/openapi/util/TextRange;", "getNonWhitespaceRange", "()Lcom/intellij/openapi/util/TextRange;", "relevantContent", "", "getRelevantContent", "()Ljava/lang/String;", "intellij.markdown"})
public final class MarkdownHeaderContent
extends ASTWrapperPsiElement
implements MarkdownPsiElement {
    public MarkdownHeaderContent(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    @NotNull
    public final TextRange getNonWhitespaceRange() {
        PsiElement child2 = (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNot(PsiUtilsKt.children((PsiElement)this), (Function1)nonWhitespaceRange.child.1.INSTANCE));
        return child2 == null ? new TextRange(0, this.getTextLength()) : new TextRange(child2.getStartOffsetInParent(), this.getTextLength());
    }

    public final boolean isSetextContent() {
        ASTNode aSTNode = this.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        IElementType iElementType = MarkdownTokenTypes.SETEXT_CONTENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"SETEXT_CONTENT");
        return AstUtilsKt.hasType(aSTNode, iElementType);
    }

    public final boolean isAtxContent() {
        ASTNode aSTNode = this.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        IElementType iElementType = MarkdownTokenTypes.ATX_CONTENT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"ATX_CONTENT");
        return AstUtilsKt.hasType(aSTNode, iElementType);
    }

    @NotNull
    public final String getRelevantContent() {
        String string = this.getNonWhitespaceRange().substring(this.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }
}

