/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessors;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.SkipOverwriteChoice;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ui.JBUI;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.MarkdownFileActionsBaseDialog;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b!\u0018\u0000 12\u00020\u0001:\u00011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0005H$J\b\u0010\u001c\u001a\u00020\u0016H\u0014J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H$J\b\u0010 \u001a\u00020\fH\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0002J\f\u0010*\u001a\u00020\u0016*\u00020+H\u0014J\f\u0010,\u001a\u00020\u0016*\u00020+H\u0014J\u0016\u0010-\u001a\u0004\u0018\u00010.*\u00020/2\u0006\u00100\u001a\u00020\fH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionsBaseDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "suggestedFilePath", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "fileNameField", "Lcom/intellij/ui/EditorTextField;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSuggestedFilePath", "()Ljava/lang/String;", "targetDirectoryField", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "createCenterPanel", "Ljavax/swing/JComponent;", "createDirIfNotExist", "", "dirPath", "createFileNameField", "createTargetDirField", "doAction", "selectedFileUrl", "doOKAction", "getFileNameIfExist", "dir", "fileNameWithoutExtension", "getPreferredFocusedComponent", "getPsiTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "pathname", "selectNameWithoutExtension", "dotIdx", "", "writeFile", "fileUrl", "targetDirPath", "createFileTypeField", "Lcom/intellij/ui/dsl/builder/Panel;", "createSettingsComponents", "validateFileName", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "field", "Companion", "intellij.markdown"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nMarkdownFileActionsBaseDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownFileActionsBaseDialog.kt\norg/intellij/plugins/markdown/fileActions/MarkdownFileActionsBaseDialog\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n11#2,2:209\n1#3:211\n*S KotlinDebug\n*F\n+ 1 MarkdownFileActionsBaseDialog.kt\norg/intellij/plugins/markdown/fileActions/MarkdownFileActionsBaseDialog\n*L\n113#1:209,2\n*E\n"})
public abstract class MarkdownFileActionsBaseDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String suggestedFilePath;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final EditorTextField fileNameField;
    @NotNull
    private final TextFieldWithHistoryWithBrowseButton targetDirectoryField;
    public static final int MAX_PATH_LENGTH = 70;
    @NotNull
    private static final String RECENT_KEYS = "ImportExportFile.TargetDir.RECENT_KEYS";

    public MarkdownFileActionsBaseDialog(@NotNull Project project, @NotNull String suggestedFilePath2, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suggestedFilePath2, (String)"suggestedFilePath");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(project, true);
        this.project = project;
        this.suggestedFilePath = suggestedFilePath2;
        this.file = file;
        this.fileNameField = new EditorTextField();
        this.targetDirectoryField = new TextFieldWithHistoryWithBrowseButton();
        super.init();
        this.createFileNameField();
        this.createTargetDirField();
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final String getSuggestedFilePath() {
        return this.suggestedFilePath;
    }

    @NotNull
    protected final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel $this$createCenterPanel_u24lambda_u240 = dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ MarkdownFileActionsBaseDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = MarkdownBundle.message("markdown.import.export.dialog.new.name.label", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ MarkdownFileActionsBaseDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)MarkdownFileActionsBaseDialog.access$getFileNameField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE).validationOnApply((Function2)new Function2<ValidationInfoBuilder, EditorTextField, ValidationInfo>(this.this$0){
                            final /* synthetic */ MarkdownFileActionsBaseDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(2);
                            }

                            @Nullable
                            public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull EditorTextField it) {
                                Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return MarkdownFileActionsBaseDialog.access$validateFileName(this.this$0, $this$validationOnApply, it);
                            }
                        }).focused();
                    }
                });
                this.this$0.createFileTypeField($this$panel);
                String string2 = MarkdownBundle.message("markdown.import.export.dialog.target.directory.label", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ MarkdownFileActionsBaseDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)MarkdownFileActionsBaseDialog.access$getTargetDirectoryField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE).validationOnApply((Function2)createCenterPanel.1.INSTANCE);
                    }
                });
                this.this$0.createSettingsComponents($this$panel);
            }
        }));
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.setBorder((Border)JBUI.Borders.emptyLeft((int)3));
        return (JComponent)dialogPanel;
    }

    @NotNull
    public EditorTextField getPreferredFocusedComponent() {
        return this.fileNameField;
    }

    protected void doOKAction() {
        Path path;
        String string = this.fileNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String fileName = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String targetDirPath = ((TextFieldWithHistory)this.targetDirectoryField.getChildComponent()).getText();
        String[] stringArray = new String[]{targetDirPath, fileName};
        String string2 = FileUtil.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
        String fileUrl = string2;
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(this.file);
        Intrinsics.checkNotNull((Object)psiFile);
        PsiDirectory srcDirectory = psiFile.getContainingDirectory();
        Intrinsics.checkNotNull((Object)targetDirPath);
        String existedFileName = this.getFileNameIfExist(targetDirPath, fileName);
        if (existedFileName != null) {
            PsiDirectory psiDirectory = this.getPsiTargetDirectory(targetDirPath);
            if (psiDirectory == null) {
                return;
            }
            PsiDirectory psiTargetDir = psiDirectory;
            SkipOverwriteChoice skipOverwriteChoice = SkipOverwriteChoice.askUser((PsiDirectory)psiTargetDir, (String)fileName, (String)this.getTitle(), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)skipOverwriteChoice, (String)"askUser(...)");
            SkipOverwriteChoice userChoice = skipOverwriteChoice;
            if (userChoice == SkipOverwriteChoice.OVERWRITE) {
                String[] stringArray2 = new String[]{targetDirPath, existedFileName};
                String string3 = FileUtil.join((String[])stringArray2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"join(...)");
                String pathname = string3;
                Path existedFilePath = new File(pathname).toPath();
                VirtualFile virtualFile = VfsUtil.findFile((Path)existedFilePath, (boolean)true);
                Intrinsics.checkNotNull((Object)virtualFile);
                VirtualFile virtualFile2 = virtualFile;
                ApplicationManager.getApplication().runWriteAction(() -> MarkdownFileActionsBaseDialog.doOKAction$lambda$1(this, virtualFile2));
                this.writeFile(fileUrl, targetDirPath);
            }
        } else {
            this.writeFile(fileUrl, targetDirPath);
        }
        if ((path = srcDirectory.getVirtualFile().getFileSystem().getNioPath(srcDirectory.getVirtualFile())) != null) {
            FileChooserUtil.setLastOpenedFile((Project)this.project, (Path)path);
        }
        RecentsManager.getInstance((Project)this.project).registerRecentEntry(RECENT_KEYS, targetDirPath);
        super.doOKAction();
    }

    protected abstract void doAction(@NotNull String var1);

    @Nullable
    protected abstract String getFileNameIfExist(@NotNull String var1, @NotNull String var2);

    /*
     * WARNING - void declaration
     */
    private final void createDirIfNotExist(String dirPath) {
        void name$iv;
        void project$iv;
        Ref.ObjectRef targetDirectory = new Ref.ObjectRef();
        Project project = this.project;
        String string = MarkdownBundle.message("markdown.import.export.dialog.create.directory", new Object[0]);
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand((Project)project$iv, new Runnable(dirPath, targetDirectory, this){
            final /* synthetic */ String $dirPath$inlined;
            final /* synthetic */ Ref.ObjectRef $targetDirectory$inlined;
            final /* synthetic */ MarkdownFileActionsBaseDialog this$0;
            {
                this.$dirPath$inlined = string;
                this.$targetDirectory$inlined = objectRef;
                this.this$0 = markdownFileActionsBaseDialog;
            }

            public final void run() {
                boolean bl = false;
                ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.$dirPath$inlined, (Ref.ObjectRef<PsiDirectory>)this.$targetDirectory$inlined, this.this$0){
                    final /* synthetic */ String $dirPath;
                    final /* synthetic */ Ref.ObjectRef<PsiDirectory> $targetDirectory;
                    final /* synthetic */ MarkdownFileActionsBaseDialog this$0;
                    {
                        this.$dirPath = $dirPath;
                        this.$targetDirectory = $targetDirectory;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        try {
                            String string = FileUtil.toSystemIndependentName((String)this.$dirPath);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
                            String path = string;
                            this.$targetDirectory.element = DirectoryUtil.mkdirs((PsiManager)PsiManager.getInstance((Project)this.this$0.getProject()), (String)path);
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            // empty catch block
                        }
                    }
                }));
            }
        }, (String)name$iv, groupId$iv);
        if (targetDirectory.element == null) {
            Messages.showErrorDialog((Project)this.project, (String)RefactoringBundle.message((String)"cannot.create.directory"), (String)RefactoringBundle.message((String)"error.title"));
        }
    }

    private final void createTargetDirField() {
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton;
        TextFieldWithHistoryWithBrowseButton $this$createTargetDirField_u24lambda_u243 = textFieldWithHistoryWithBrowseButton = this.targetDirectoryField;
        boolean bl = false;
        $this$createTargetDirField_u24lambda_u243.setTextFieldPreferredWidth(70);
        List resDirRecent = RecentsManager.getInstance((Project)this.project).getRecentEntries(RECENT_KEYS);
        if (resDirRecent != null) {
            ((TextFieldWithHistory)$this$createTargetDirField_u24lambda_u243.getChildComponent()).setHistory(resDirRecent);
        }
        String string = this.file.getParent().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String suggestedDir = string;
        if (resDirRecent == null && ((TextFieldWithHistory)$this$createTargetDirField_u24lambda_u243.getChildComponent()).getHistory().isEmpty()) {
            ((TextFieldWithHistory)$this$createTargetDirField_u24lambda_u243.getChildComponent()).setHistory(CollectionsKt.listOf((Object)suggestedDir));
        }
        ((TextFieldWithHistory)$this$createTargetDirField_u24lambda_u243.getChildComponent()).setText(suggestedDir);
        $this$createTargetDirField_u24lambda_u243.addBrowseFolderListener(MarkdownBundle.message("markdown.import.export.dialog.target.directory", new Object[0]), MarkdownBundle.message("markdown.import.export.dialog.target.directory.description", new Object[0]), this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
    }

    private final void createFileNameField() {
        File file = new File(this.suggestedFilePath);
        this.fileNameField.setText(FilesKt.getNameWithoutExtension((File)file));
        int endOfNameIdx = FilesKt.getNameWithoutExtension((File)file).length();
        if (endOfNameIdx > 0) {
            this.selectNameWithoutExtension(endOfNameIdx);
        }
    }

    protected void createFileTypeField(@NotNull Panel $this$createFileTypeField) {
        Intrinsics.checkNotNullParameter((Object)$this$createFileTypeField, (String)"<this>");
    }

    protected void createSettingsComponents(@NotNull Panel $this$createSettingsComponents) {
        Intrinsics.checkNotNullParameter((Object)$this$createSettingsComponents, (String)"<this>");
    }

    private final void selectNameWithoutExtension(int dotIdx) {
        ApplicationManager.getApplication().invokeLater(() -> MarkdownFileActionsBaseDialog.selectNameWithoutExtension$lambda$4(this, dotIdx));
    }

    private final ValidationInfo validateFileName(ValidationInfoBuilder $this$validateFileName, EditorTextField field) {
        ValidationInfo validationInfo;
        String string = field.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String fileName = string;
        if (field.isNull() || ((CharSequence)fileName).length() == 0) {
            String string2 = RefactoringBundle.message((String)"no.new.name.specified");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            validationInfo = $this$validateFileName.error(string2);
        } else if (!PathUtilRt.isValidFileName((String)fileName, (boolean)false)) {
            String string3 = RefactoringBundle.message((String)"name.is.not.a.valid.file.name");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            validationInfo = $this$validateFileName.error(string3);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private final PsiDirectory getPsiTargetDirectory(String pathname) {
        PsiDirectory psiDirectory;
        VirtualFile vfDirectory;
        Path dirPath = new File(pathname).toPath();
        VirtualFile virtualFile = vfDirectory = VfsUtil.findFile((Path)dirPath, (boolean)true);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            psiDirectory = PsiManager.getInstance((Project)this.project).findDirectory(it);
        } else {
            psiDirectory = null;
        }
        return psiDirectory;
    }

    private final void writeFile(String fileUrl, String targetDirPath) {
        this.createDirIfNotExist(targetDirPath);
        this.doAction(fileUrl);
    }

    private static final void doOKAction$lambda$1(MarkdownFileActionsBaseDialog this$0, VirtualFile $virtualFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$virtualFile, (String)"$virtualFile");
        PsiFile psiFile = PsiManager.getInstance((Project)this$0.project).findFile($virtualFile);
        Intrinsics.checkNotNull((Object)psiFile);
        psiFile.delete();
    }

    private static final void selectNameWithoutExtension$lambda$4(MarkdownFileActionsBaseDialog this$0, int $dotIdx) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Editor editor2 = this$0.fileNameField.getEditor();
        if (editor2 != null) {
            editor2.getSelectionModel().setSelection(0, $dotIdx);
            editor2.getCaretModel().moveToOffset($dotIdx);
        } else {
            this$0.fileNameField.selectAll();
        }
    }

    public static final /* synthetic */ EditorTextField access$getFileNameField$p(MarkdownFileActionsBaseDialog $this) {
        return $this.fileNameField;
    }

    public static final /* synthetic */ ValidationInfo access$validateFileName(MarkdownFileActionsBaseDialog $this, ValidationInfoBuilder $receiver, EditorTextField field) {
        return $this.validateFileName($receiver, field);
    }

    public static final /* synthetic */ TextFieldWithHistoryWithBrowseButton access$getTargetDirectoryField$p(MarkdownFileActionsBaseDialog $this) {
        return $this.targetDirectoryField;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionsBaseDialog$Companion;", "", "()V", "MAX_PATH_LENGTH", "", "RECENT_KEYS", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

