/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common.highlighter;

import com.intellij.icons.AllIcons;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionsUtil;
import org.intellij.plugins.markdown.ui.preview.BrowserPipe;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.intellij.plugins.markdown.ui.preview.html.PreviewEncodingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\rH\u0016R\u0014\u0010\b\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/CodeFenceCopyButtonBrowserExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "browserPipe", "Lorg/intellij/plugins/markdown/ui/preview/BrowserPipe;", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;Lorg/intellij/plugins/markdown/ui/preview/BrowserPipe;)V", "resourceProvider", "getResourceProvider", "()Lorg/intellij/plugins/markdown/extensions/common/highlighter/CodeFenceCopyButtonBrowserExtension;", "scripts", "", "", "getScripts", "()Ljava/util/List;", "styles", "getStyles", "canProvide", "", "resourceName", "dispose", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "Companion", "Provider", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nCodeFenceCopyButtonBrowserExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFenceCopyButtonBrowserExtension.kt\norg/intellij/plugins/markdown/extensions/common/highlighter/CodeFenceCopyButtonBrowserExtension\n+ 2 ResourceProvider.kt\norg/intellij/plugins/markdown/ui/preview/ResourceProvider$Companion\n*L\n1#1,84:1\n106#2,2:85\n106#2,2:87\n*S KotlinDebug\n*F\n+ 1 CodeFenceCopyButtonBrowserExtension.kt\norg/intellij/plugins/markdown/extensions/common/highlighter/CodeFenceCopyButtonBrowserExtension\n*L\n50#1:85,2\n51#1:87,2\n*E\n"})
public final class CodeFenceCopyButtonBrowserExtension
implements MarkdownBrowserPreviewExtension,
ResourceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeFenceCopyButtonBrowserExtension resourceProvider;
    @NotNull
    private final List<String> styles;
    @NotNull
    private final List<String> scripts;
    @NotNull
    private static final String STYLE_NAME = "copy-button.css";
    @NotNull
    private static final String SCRIPT_NAME = "copy-button.js";
    @NotNull
    private static final String COPY_ICON_NAME = "copy-button-copy-icon.png";
    @NotNull
    private static final String COPY_ICON_HOVERED_NAME = "copy-button-copy-icon-hovered.png";
    @NotNull
    private static final List<String> resources;

    public CodeFenceCopyButtonBrowserExtension(final @NotNull MarkdownHtmlPanel panel2, @NotNull BrowserPipe browserPipe) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)browserPipe, (String)"browserPipe");
        browserPipe.subscribe("copy-button/copy", new BrowserPipe.Handler(){

            @Override
            public boolean processMessageReceived(@NotNull String data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                String content2 = PreviewEncodingUtil.INSTANCE.decodeContent(data);
                Project project = panel2.getProject();
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(content2, project){
                    final /* synthetic */ String $content;
                    final /* synthetic */ Project $project;
                    {
                        this.$content = $content;
                        this.$project = $project;
                        super(0);
                    }

                    public final void invoke() {
                        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.$content));
                        if (this.$project != null) {
                            StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.$project);
                            String string = StringUtil.shortenTextWithEllipsis((String)this.$content, (int)32, (int)0);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
                            String text2 = string;
                            StatusBar statusBar2 = statusBar;
                            if (statusBar2 != null) {
                                Object[] objectArray = new Object[]{"'" + text2 + "'"};
                                statusBar2.setInfo(LangBundle.message((String)"status.bar.text.reference.has.been.copied", (Object[])objectArray));
                            }
                        }
                    }
                }), (int)1, null);
                return project == null;
            }
        });
        this.resourceProvider = this;
        this.styles = CollectionsKt.listOf((Object)STYLE_NAME);
        this.scripts = CollectionsKt.listOf((Object)SCRIPT_NAME);
    }

    @Override
    @NotNull
    public CodeFenceCopyButtonBrowserExtension getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    @NotNull
    public List<String> getStyles() {
        return this.styles;
    }

    @Override
    @NotNull
    public List<String> getScripts() {
        return this.scripts;
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return resources.contains(resourceName);
    }

    @Override
    @Nullable
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return switch (resourceName) {
            case STYLE_NAME -> {
                void $this$iv;
                ResourceProvider.Companion var3_3 = ResourceProvider.Companion;
                String path$iv = STYLE_NAME;
                String contentType$iv = null;
                boolean $i$f$loadInternalResource = false;
                yield $this$iv.loadInternalResource(CodeFenceCopyButtonBrowserExtension.class, path$iv, contentType$iv);
            }
            case SCRIPT_NAME -> {
                ResourceProvider.Companion $this$iv = ResourceProvider.Companion;
                String path$iv = SCRIPT_NAME;
                String contentType$iv = null;
                boolean $i$f$loadInternalResource = false;
                yield $this$iv.loadInternalResource(CodeFenceCopyButtonBrowserExtension.class, path$iv, contentType$iv);
            }
            case COPY_ICON_NAME -> {
                Icon v1 = AllIcons.General.InlineCopy;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"InlineCopy");
                yield CodeFenceCopyButtonBrowserExtension.Companion.loadIconAsResource(v1);
            }
            case COPY_ICON_HOVERED_NAME -> {
                Icon v2 = AllIcons.General.InlineCopyHover;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"InlineCopyHover");
                yield CodeFenceCopyButtonBrowserExtension.Companion.loadIconAsResource(v2);
            }
            default -> null;
        };
    }

    public void dispose() {
    }

    static {
        Object[] objectArray = new String[]{STYLE_NAME, SCRIPT_NAME, COPY_ICON_NAME, COPY_ICON_HOVERED_NAME};
        resources = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/CodeFenceCopyButtonBrowserExtension$Companion;", "", "()V", "COPY_ICON_HOVERED_NAME", "", "COPY_ICON_NAME", "SCRIPT_NAME", "STYLE_NAME", "resources", "", "loadIconAsResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "icon", "Ljavax/swing/Icon;", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        private final ResourceProvider.Resource loadIconAsResource(Icon icon) {
            return new ResourceProvider.Resource(MarkdownExtensionsUtil.INSTANCE.loadIcon(icon, "png"), null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/CodeFenceCopyButtonBrowserExtension$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "()V", "createBrowserExtension", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nCodeFenceCopyButtonBrowserExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFenceCopyButtonBrowserExtension.kt\norg/intellij/plugins/markdown/extensions/common/highlighter/CodeFenceCopyButtonBrowserExtension$Provider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
    public static final class Provider
    implements MarkdownBrowserPreviewExtension.Provider {
        @Override
        @Nullable
        public MarkdownBrowserPreviewExtension createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
            CodeFenceCopyButtonBrowserExtension codeFenceCopyButtonBrowserExtension;
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            BrowserPipe browserPipe = panel2.getBrowserPipe();
            if (browserPipe != null) {
                BrowserPipe it = browserPipe;
                boolean bl = false;
                codeFenceCopyButtonBrowserExtension = new CodeFenceCopyButtonBrowserExtension(panel2, it);
            } else {
                codeFenceCopyButtonBrowserExtension = null;
            }
            return codeFenceCopyButtonBrowserExtension;
        }
    }
}

