/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.inspections.IncorrectListNumberingInspection;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/inspections/IncorrectListNumberingInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ListNumberingFix", "intellij.markdown"})
@ApiStatus.Internal
public final class IncorrectListNumberingInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MarkdownElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitList(@NotNull MarkdownList list2) {
                Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
                super.visitList(list2);
                PsiElement psiElement = (PsiElement)list2;
                IElementType iElementType = MarkdownElementTypes.ORDERED_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"ORDERED_LIST");
                if (!PsiUtilsKt.hasType(psiElement, iElementType)) {
                    return;
                }
                Lazy quickFix$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ListNumberingFix>(list2){
                    final /* synthetic */ MarkdownList $list;
                    {
                        this.$list = $list;
                        super(0);
                    }

                    @NotNull
                    public final ListNumberingFix invoke() {
                        return new ListNumberingFix(this.$list);
                    }
                }));
                Iterator<MarkdownListItem> iterator = ListUtils.INSTANCE.getItems(list2).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    PsiElement markerElement;
                    int index = n++;
                    MarkdownListItem item = iterator.next();
                    Integer n2 = ListRenumberUtils.INSTANCE.obtainMarkerNumber(item);
                    if (n2 == null) {
                        continue;
                    }
                    int expectedNumber = index + 1;
                    int actualNumber = n2;
                    if (expectedNumber == actualNumber) continue;
                    Intrinsics.checkNotNull((Object)item.getMarkerElement());
                    Object[] objectArray = new Object[]{expectedNumber, actualNumber};
                    String string = MarkdownBundle.message("markdown.incorrectly.numbered.list.item.inspection.text", objectArray);
                    objectArray = new LocalQuickFix[]{buildVisitor.1.visitList$lambda$0((Lazy<ListNumberingFix>)quickFix$delegate)};
                    this.$holder.registerProblem(markerElement, string, ProblemHighlightType.WEAK_WARNING, (LocalQuickFix[])objectArray);
                }
            }

            private static final ListNumberingFix visitList$lambda$0(Lazy<ListNumberingFix> $quickFix$delegate) {
                Lazy<ListNumberingFix> lazy = $quickFix$delegate;
                return (ListNumberingFix)((Object)lazy.getValue());
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0096\u0002\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/inspections/IncorrectListNumberingInspection$ListNumberingFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "list", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nIncorrectListNumberingInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncorrectListNumberingInspection.kt\norg/intellij/plugins/markdown/editor/lists/inspections/IncorrectListNumberingInspection$ListNumberingFix\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,72:1\n23#2:73\n*S KotlinDebug\n*F\n+ 1 IncorrectListNumberingInspection.kt\norg/intellij/plugins/markdown/editor/lists/inspections/IncorrectListNumberingInspection$ListNumberingFix\n*L\n65#1:73\n*E\n"})
    private static final class ListNumberingFix
    extends LocalQuickFixOnPsiElement {
        public ListNumberingFix(@NotNull MarkdownList list2) {
            Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
            super((PsiElement)list2);
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @NotNull
        public String getText() {
            String string = MarkdownBundle.message("markdown.fix.list.items.numbering,quick.fix.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            if (!(startElement instanceof MarkdownList)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Document document = file.getViewProvider().getDocument();
            if (document == null) {
                ListNumberingFix $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ListNumberingFix.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Failed to find document for the quick fix");
                return;
            }
            ListRenumberUtils.INSTANCE.renumberInBulk((MarkdownList)startElement, document, false, true, false);
        }
    }
}

