/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.state;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.jetbrains.rider.plugins.efcore.state.CommonOptionsState;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@State(name="EfCoreCommonOptions", storages={@Storage(value="efCoreCommonOptions.xml")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u000bJ\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\bJ\b\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bJ\u0016\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/plugins/efcore/state/CommonOptionsStateService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/jetbrains/rider/plugins/efcore/state/CommonOptionsState;", "()V", "myState", "clearPreferredProjectsPair", "", "prevMigrationsProjectId", "Ljava/util/UUID;", "prevStartupProjectId", "getGlobalProjectIdsPair", "Lkotlin/Pair;", "getPreferredProjectIdsPair", "projectId", "getState", "loadState", "state", "setGlobalProjectIdsPair", "migrationsProjectId", "startupProjectId", "setPreferredProjectsPair", "Companion", "intellij.rider.plugins.efCore"})
public final class CommonOptionsStateService
implements PersistentStateComponent<CommonOptionsState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private CommonOptionsState myState = new CommonOptionsState();
    @NotNull
    private static final String MIGRATIONS_PROJECT_KEY = "migrationsProject";
    @NotNull
    private static final String STARTUP_PROJECT_KEY = "startupProject";

    @NotNull
    public CommonOptionsState getState() {
        return this.myState;
    }

    public void loadState(@NotNull CommonOptionsState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.myState = state;
    }

    public final void clearPreferredProjectsPair(@NotNull UUID prevMigrationsProjectId, @NotNull UUID prevStartupProjectId) {
        Intrinsics.checkNotNullParameter((Object)prevMigrationsProjectId, (String)"prevMigrationsProjectId");
        Intrinsics.checkNotNullParameter((Object)prevStartupProjectId, (String)"prevStartupProjectId");
        this.myState.getMigrationsToStartupProjects().remove(prevMigrationsProjectId.toString());
        this.myState.getStartupToMigrationsProjects().remove(prevStartupProjectId.toString());
    }

    public final void setPreferredProjectsPair(@NotNull UUID migrationsProjectId, @NotNull UUID startupProjectId) {
        Intrinsics.checkNotNullParameter((Object)migrationsProjectId, (String)"migrationsProjectId");
        Intrinsics.checkNotNullParameter((Object)startupProjectId, (String)"startupProjectId");
        String string = migrationsProjectId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String migrationsProjectString = string;
        String string2 = startupProjectId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String startupProjectString = string2;
        this.myState.getMigrationsToStartupProjects().put(migrationsProjectString, startupProjectString);
        this.myState.getStartupToMigrationsProjects().put(startupProjectString, migrationsProjectString);
    }

    @Nullable
    public final Pair<UUID, UUID> getPreferredProjectIdsPair(@NotNull UUID projectId) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        String string = projectId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String projectIdString = string;
        if (this.myState.getMigrationsToStartupProjects().containsKey(projectIdString)) {
            String string2 = this.myState.getMigrationsToStartupProjects().get(projectIdString);
            Intrinsics.checkNotNull((Object)string2);
            String startupProject2 = string2;
            pair = new Pair((Object)UUID.fromString(projectIdString), (Object)UUID.fromString(startupProject2));
        } else if (this.myState.getStartupToMigrationsProjects().containsKey(projectIdString)) {
            String string3 = this.myState.getStartupToMigrationsProjects().get(projectIdString);
            Intrinsics.checkNotNull((Object)string3);
            String migrationsProject2 = string3;
            pair = new Pair((Object)UUID.fromString(migrationsProject2), (Object)UUID.fromString(projectIdString));
        } else {
            pair = null;
        }
        return pair;
    }

    @Nullable
    public final Pair<UUID, UUID> getGlobalProjectIdsPair() {
        String string = this.myState.getSolutionLevelOptions().get(MIGRATIONS_PROJECT_KEY);
        if (string == null) {
            return null;
        }
        String migrationsProject2 = string;
        String string2 = this.myState.getSolutionLevelOptions().get(STARTUP_PROJECT_KEY);
        if (string2 == null) {
            return null;
        }
        String startupProject2 = string2;
        return TuplesKt.to((Object)UUID.fromString(migrationsProject2), (Object)UUID.fromString(startupProject2));
    }

    public final void setGlobalProjectIdsPair(@NotNull UUID migrationsProjectId, @NotNull UUID startupProjectId) {
        Intrinsics.checkNotNullParameter((Object)migrationsProjectId, (String)"migrationsProjectId");
        Intrinsics.checkNotNullParameter((Object)startupProjectId, (String)"startupProjectId");
        Map<String, String> map = this.myState.getSolutionLevelOptions();
        String string = MIGRATIONS_PROJECT_KEY;
        String string2 = migrationsProjectId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = string2;
        map.put(string, string3);
        map = this.myState.getSolutionLevelOptions();
        string = STARTUP_PROJECT_KEY;
        String string4 = startupProjectId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        string3 = string4;
        map.put(string, string3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/efcore/state/CommonOptionsStateService$Companion;", "", "()V", "MIGRATIONS_PROJECT_KEY", "", "STARTUP_PROJECT_KEY", "getInstance", "Lcom/jetbrains/rider/plugins/efcore/state/CommonOptionsStateService;", "intellij.rider.plugins.efCore"})
    @SourceDebugExtension(value={"SMAP\nCommonOptionsStateService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonOptionsStateService.kt\ncom/jetbrains/rider/plugins/efcore/state/CommonOptionsStateService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,62:1\n40#2,3:63\n*S KotlinDebug\n*F\n+ 1 CommonOptionsStateService.kt\ncom/jetbrains/rider/plugins/efcore/state/CommonOptionsStateService$Companion\n*L\n15#1:63,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CommonOptionsStateService getInstance() {
            boolean $i$f$service = false;
            Class<CommonOptionsStateService> serviceClass$iv = CommonOptionsStateService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (CommonOptionsStateService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

