/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.features.terminal.smartExecute;

import com.intellij.execution.Executor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.terminal.TerminalShellCommandHandler;
import com.jetbrains.rider.plugins.efcore.EfCoreUiBundle;
import com.jetbrains.rider.plugins.efcore.cli.api.models.DotnetEfVersion;
import com.jetbrains.rider.plugins.efcore.cli.execution.KnownEfCommands;
import com.jetbrains.rider.plugins.efcore.features.database.drop.DropDatabaseAction;
import com.jetbrains.rider.plugins.efcore.features.database.update.UpdateDatabaseAction;
import com.jetbrains.rider.plugins.efcore.features.dbcontext.scaffold.ScaffoldDbContextAction;
import com.jetbrains.rider.plugins.efcore.features.migrations.add.AddMigrationAction;
import com.jetbrains.rider.plugins.efcore.features.migrations.remove.RemoveLastMigrationAction;
import com.jetbrains.rider.plugins.efcore.features.migrations.script.GenerateScriptAction;
import com.jetbrains.rider.plugins.efcore.features.shared.BaseCommandAction;
import com.jetbrains.rider.plugins.efcore.features.shared.QuickActionsGroup;
import com.jetbrains.rider.plugins.efcore.rd.CliToolDefinition;
import com.jetbrains.rider.plugins.efcore.rd.RiderEfCoreModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bH\u0016J\u001e\u0010\u000e\u001a\u00020\u0004*\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/terminal/smartExecute/EFCoreShellCommandHandler;", "Lcom/intellij/terminal/TerminalShellCommandHandler;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "", "localSession", "command", "executor", "Lcom/intellij/execution/Executor;", "matches", "launch", "Lcom/jetbrains/rider/plugins/efcore/features/shared/BaseCommandAction;", "dotnetProjectId", "Ljava/util/UUID;", "Companion", "intellij.rider.plugins.efCore"})
public final class EFCoreShellCommandHandler
implements TerminalShellCommandHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DOTNET_EF = "dotnet ef";
    @NotNull
    private static final Set<String> knownEfCommands;

    public boolean matches(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String parsedCommand = ((Object)StringsKt.trim((CharSequence)command)).toString();
        return !StringsKt.startsWith$default((String)parsedCommand, (String)DOTNET_EF, (boolean)false, (int)2, null) ? false : (Intrinsics.areEqual((Object)parsedCommand, (Object)DOTNET_EF) ? true : knownEfCommands.contains(((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)parsedCommand, (CharSequence)DOTNET_EF))).toString()));
    }

    public boolean execute(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)command)).toString(), (Object)DOTNET_EF)) {
            DataContext dataContext = SimpleDataContext.getProjectContext((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getProjectContext(...)");
            DataContext dataContext2 = dataContext;
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(EfCoreUiBundle.INSTANCE.message("popup.title.ef.core.quick.actions", new Object[0]), (ActionGroup)new QuickActionsGroup(), dataContext2, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, false);
            Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
            ListPopup popup = listPopup;
            popup.showCenteredInCurrentWindow(project);
            return true;
        }
        UUID dotnetProjectId = null;
        String $this$execute_u24lambda_u240 = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)command)).toString(), (CharSequence)DOTNET_EF))).toString();
        boolean bl = false;
        return StringsKt.startsWith$default((String)$this$execute_u24lambda_u240, (String)KnownEfCommands.Migrations.INSTANCE.getAdd(), (boolean)false, (int)2, null) ? this.launch(new AddMigrationAction(), project, dotnetProjectId) : (StringsKt.startsWith$default((String)$this$execute_u24lambda_u240, (String)KnownEfCommands.Database.INSTANCE.getDrop(), (boolean)false, (int)2, null) ? this.launch(new DropDatabaseAction(), project, dotnetProjectId) : (StringsKt.startsWith$default((String)$this$execute_u24lambda_u240, (String)KnownEfCommands.Database.INSTANCE.getUpdate(), (boolean)false, (int)2, null) ? this.launch(new UpdateDatabaseAction(), project, dotnetProjectId) : (StringsKt.startsWith$default((String)$this$execute_u24lambda_u240, (String)KnownEfCommands.DbContext.INSTANCE.getScaffold(), (boolean)false, (int)2, null) ? this.launch(new ScaffoldDbContextAction(), project, dotnetProjectId) : (StringsKt.startsWith$default((String)$this$execute_u24lambda_u240, (String)KnownEfCommands.Migrations.INSTANCE.getRemove(), (boolean)false, (int)2, null) ? this.launch(new RemoveLastMigrationAction(), project, dotnetProjectId) : (StringsKt.startsWith$default((String)$this$execute_u24lambda_u240, (String)KnownEfCommands.DbContext.INSTANCE.getScript(), (boolean)false, (int)2, null) ? this.launch(new GenerateScriptAction(), project, dotnetProjectId) : false)))));
    }

    private final boolean launch(BaseCommandAction $this$launch, Project project, UUID dotnetProjectId) {
        CliToolDefinition cliToolDefinition = (CliToolDefinition)RiderEfCoreModel_PregeneratedKt.getRiderEfCoreModel(SolutionHostExtensionsKt.getSolution((Project)project)).getCliToolsDefinition().getValueOrNull();
        if (cliToolDefinition == null) {
            return false;
        }
        CliToolDefinition efCoreDefinition = cliToolDefinition;
        DotnetEfVersion dotnetEfVersion = DotnetEfVersion.Companion.parse(efCoreDefinition.getVersion());
        if (dotnetEfVersion == null) {
            return false;
        }
        DotnetEfVersion toolsVersion = dotnetEfVersion;
        return $this$launch.createDialog(project, toolsVersion, RiderEfCoreModel_PregeneratedKt.getRiderEfCoreModel(SolutionHostExtensionsKt.getSolution((Project)project)), dotnetProjectId).showAndGet();
    }

    static {
        Object[] objectArray = new String[]{KnownEfCommands.Migrations.INSTANCE.getAdd(), KnownEfCommands.Database.INSTANCE.getDrop(), KnownEfCommands.Database.INSTANCE.getUpdate(), KnownEfCommands.DbContext.INSTANCE.getScaffold(), KnownEfCommands.Migrations.INSTANCE.getRemove(), KnownEfCommands.DbContext.INSTANCE.getScript()};
        knownEfCommands = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/terminal/smartExecute/EFCoreShellCommandHandler$Companion;", "", "()V", "DOTNET_EF", "", "knownEfCommands", "", "intellij.rider.plugins.efCore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

