/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.features.shared.services;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.efcore.features.connections.impl.AppSettingsConnectionProvider;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "deserializeNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "jsonFile", "Ljava/io/File;", "jsonString", "", "Companion", "intellij.rider.plugins.efCore"})
@SourceDebugExtension(value={"SMAP\nJsonSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSerializer.kt\ncom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,49:1\n13#2:50\n*S KotlinDebug\n*F\n+ 1 JsonSerializer.kt\ncom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer\n*L\n26#1:50\n*E\n"})
public final class JsonSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    private static final ObjectMapper json;

    public JsonSerializer() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JsonSerializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Nullable
    public final JsonNode deserializeNode(@NotNull String jsonString) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        try {
            jsonNode = json.readTree(jsonString);
        }
        catch (JacksonException e) {
            String message = "Input JSON is invalid";
            this.logger.error(message, (Throwable)e);
            jsonNode = null;
        }
        return jsonNode;
    }

    @Nullable
    public final JsonNode deserializeNode(@NotNull File jsonFile) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
        try {
            jsonNode = json.readTree(jsonFile);
        }
        catch (JacksonException e) {
            String message = "Input JSON file '" + jsonFile.getAbsolutePath() + "' is invalid";
            this.logger.error(message, (Throwable)e);
            jsonNode = null;
        }
        return jsonNode;
    }

    static {
        JsonParser.Feature[] featureArray = new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS};
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).enable(featureArray);
        featureArray = new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES};
        json = objectMapper.enable(featureArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer$Companion;", "", "()V", "json", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getInstance", "Lcom/jetbrains/rider/plugins/efcore/features/connections/impl/AppSettingsConnectionProvider;", "intellijProject", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.efCore"})
    @SourceDebugExtension(value={"SMAP\nJsonSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSerializer.kt\ncom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,49:1\n31#2,2:50\n*S KotlinDebug\n*F\n+ 1 JsonSerializer.kt\ncom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer$Companion\n*L\n23#1:50,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AppSettingsConnectionProvider getInstance(@NotNull Project intellijProject) {
            Intrinsics.checkNotNullParameter((Object)intellijProject, (String)"intellijProject");
            ComponentManager $this$service$iv = (ComponentManager)intellijProject;
            boolean $i$f$service = false;
            Class<AppSettingsConnectionProvider> serviceClass$iv = AppSettingsConnectionProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AppSettingsConnectionProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

