/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.features.connections.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.plugins.efcore.EfCoreUiBundle;
import com.jetbrains.rider.plugins.efcore.features.connections.DbConnectionInfo;
import com.jetbrains.rider.plugins.efcore.features.connections.DbConnectionProvider;
import com.jetbrains.rider.plugins.efcore.features.connections.impl.JsonConnectionStringsManager;
import com.jetbrains.rider.plugins.efcore.features.shared.services.JsonSerializer;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/connections/impl/UserSecretsConnectionProvider;", "Lcom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionProvider;", "intellijProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "serializer", "Lcom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer;", "getAvailableConnections", "", "Lcom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionInfo;", "project", "Lcom/jetbrains/rider/model/RdProjectDescriptor;", "Companion", "intellij.rider.plugins.efCore"})
@SourceDebugExtension(value={"SMAP\nUserSecretsConnectionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserSecretsConnectionProvider.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/impl/UserSecretsConnectionProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,37:1\n31#2,2:38\n*S KotlinDebug\n*F\n+ 1 UserSecretsConnectionProvider.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/impl/UserSecretsConnectionProvider\n*L\n26#1:38,2\n*E\n"})
public final class UserSecretsConnectionProvider
implements DbConnectionProvider {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project intellijProject;
    @NotNull
    private final JsonSerializer serializer;
    @NonNls
    @NotNull
    private static final Path userSecretsFolder;

    public UserSecretsConnectionProvider(@NotNull Project intellijProject) {
        Intrinsics.checkNotNullParameter((Object)intellijProject, (String)"intellijProject");
        this.intellijProject = intellijProject;
        ComponentManager $this$service$iv = (ComponentManager)this.intellijProject;
        boolean $i$f$service = false;
        Class<JsonSerializer> serviceClass$iv = JsonSerializer.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.serializer = (JsonSerializer)object;
    }

    @Override
    @NotNull
    public List<DbConnectionInfo> getAvailableConnections(@NotNull RdProjectDescriptor project) {
        String userSecretsId;
        File userSecretsFile;
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List $this$getAvailableConnections_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        String string = ProjectModelNodeExtensionKt.getUserData((RdProjectModelItemDescriptor)((RdProjectModelItemDescriptor)project), (String)"UserSecretsId");
        if (string != null && (userSecretsFile = userSecretsFolder.resolve(userSecretsId = string).resolve("secrets.json").toFile()).exists() && userSecretsFile.isFile()) {
            Intrinsics.checkNotNull((Object)userSecretsFile);
            JsonNode jsonNode = this.serializer.deserializeNode(userSecretsFile);
            if (jsonNode != null) {
                JsonNode userSecretsJson = jsonNode;
                $this$getAvailableConnections_u24lambda_u240.addAll((Collection)JsonConnectionStringsManager.Companion.getInstance(this.intellijProject).collectConnectionStrings(EfCoreUiBundle.INSTANCE.message("source.user.secrets", new Object[0]), userSecretsJson));
            }
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.build((List)list));
    }

    static {
        Path path;
        Companion = new Companion(null);
        if (SystemInfo.isWindows) {
            String string = System.getenv("APPDATA");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
            String string2 = string;
            String[] stringArray = new String[]{"Microsoft", "UserSecrets"};
            Path path2 = Paths.get(string2, Arrays.copyOf(stringArray, stringArray.length));
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        } else {
            String string = System.getenv("HOME");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
            String string3 = string;
            String[] stringArray = new String[]{".microsoft", "usersecrets"};
            Path path3 = Paths.get(string3, Arrays.copyOf(stringArray, stringArray.length));
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        }
        userSecretsFolder = path;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/connections/impl/UserSecretsConnectionProvider$Companion;", "", "()V", "userSecretsFolder", "Ljava/nio/file/Path;", "getInstance", "Lcom/jetbrains/rider/plugins/efcore/features/connections/impl/UserSecretsConnectionProvider;", "intellijProject", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.efCore"})
    @SourceDebugExtension(value={"SMAP\nUserSecretsConnectionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserSecretsConnectionProvider.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/impl/UserSecretsConnectionProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,37:1\n31#2,2:38\n*S KotlinDebug\n*F\n+ 1 UserSecretsConnectionProvider.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/impl/UserSecretsConnectionProvider$Companion\n*L\n23#1:38,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UserSecretsConnectionProvider getInstance(@NotNull Project intellijProject) {
            Intrinsics.checkNotNullParameter((Object)intellijProject, (String)"intellijProject");
            ComponentManager $this$service$iv = (ComponentManager)intellijProject;
            boolean $i$f$service = false;
            Class<UserSecretsConnectionProvider> serviceClass$iv = UserSecretsConnectionProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (UserSecretsConnectionProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

