/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.features.connections.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.efcore.features.connections.DbConnectionInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/connections/impl/JsonConnectionStringsManager;", "", "intellijProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "collectConnectionStrings", "", "Lcom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionInfo;", "fileName", "", "fileData", "Lcom/fasterxml/jackson/databind/JsonNode;", "getConnectionsFromInlineItems", "jsonFile", "getConnectionsFromObject", "Companion", "intellij.rider.plugins.efCore"})
@SourceDebugExtension(value={"SMAP\nJsonConnectionStringsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonConnectionStringsManager.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/impl/JsonConnectionStringsManager\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,62:1\n32#2,2:63\n32#2,2:65\n*S KotlinDebug\n*F\n+ 1 JsonConnectionStringsManager.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/impl/JsonConnectionStringsManager\n*L\n36#1:63,2\n51#1:65,2\n*E\n"})
public final class JsonConnectionStringsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NonNls
    @NotNull
    private static final Regex inlineConnectionRegex = new Regex("^ConnectionStrings(:|__)(?<name>.+)$");

    public JsonConnectionStringsManager(@NotNull Project intellijProject) {
        Intrinsics.checkNotNullParameter((Object)intellijProject, (String)"intellijProject");
    }

    @NotNull
    public final List<DbConnectionInfo> collectConnectionStrings(@NotNull String fileName, @NotNull JsonNode fileData) {
        List list;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        List $this$collectConnectionStrings_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$collectConnectionStrings_u24lambda_u240.addAll((Collection)this.getConnectionsFromObject(fileName, fileData));
        $this$collectConnectionStrings_u24lambda_u240.addAll((Collection)this.getConnectionsFromInlineItems(fileName, fileData));
        return CollectionsKt.build((List)list);
    }

    private final List<DbConnectionInfo> getConnectionsFromObject(String fileName, JsonNode jsonFile) {
        List list;
        List $this$getConnectionsFromObject_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ObjectNode objectNode = (ObjectNode)jsonFile.get("ConnectionStrings");
        if (objectNode == null) {
            return CollectionsKt.emptyList();
        }
        ObjectNode obj = objectNode;
        Iterator iterator = obj.fieldNames();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fieldNames(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            String connName = (String)element$iv;
            boolean bl2 = false;
            TextNode textNode = (TextNode)obj.get(connName);
            String connString = textNode != null ? textNode.textValue() : null;
            if (connString == null) continue;
            Intrinsics.checkNotNull((Object)connName);
            $this$getConnectionsFromObject_u24lambda_u242.add(new DbConnectionInfo(connName, connString, fileName, null));
        }
        return CollectionsKt.build((List)list);
    }

    private final List<DbConnectionInfo> getConnectionsFromInlineItems(String fileName, JsonNode jsonFile) {
        List list;
        List $this$getConnectionsFromInlineItems_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterator iterator = jsonFile.fieldNames();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fieldNames(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            String string;
            Object object;
            Object element$iv = iterator2.next();
            String settingsField = (String)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)settingsField);
            MatchResult match = inlineConnectionRegex.matchEntire((CharSequence)settingsField);
            if (match == null || (object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"name")) == null || (object = object.getValue()) == null) continue;
            Object name = object;
            TextNode textNode = (TextNode)jsonFile.get(settingsField);
            String string2 = string = textNode != null ? textNode.textValue() : null;
            if (string2 == null) continue;
            Intrinsics.checkNotNull((Object)string2);
            String connection = string;
            $this$getConnectionsFromInlineItems_u24lambda_u244.add(new DbConnectionInfo((String)name, connection, fileName, null));
        }
        return CollectionsKt.build((List)list);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/connections/impl/JsonConnectionStringsManager$Companion;", "", "()V", "inlineConnectionRegex", "Lkotlin/text/Regex;", "getInstance", "Lcom/jetbrains/rider/plugins/efcore/features/connections/impl/JsonConnectionStringsManager;", "intellijProject", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.efCore"})
    @SourceDebugExtension(value={"SMAP\nJsonConnectionStringsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonConnectionStringsManager.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/impl/JsonConnectionStringsManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,62:1\n31#2,2:63\n*S KotlinDebug\n*F\n+ 1 JsonConnectionStringsManager.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/impl/JsonConnectionStringsManager$Companion\n*L\n15#1:63,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JsonConnectionStringsManager getInstance(@NotNull Project intellijProject) {
            Intrinsics.checkNotNullParameter((Object)intellijProject, (String)"intellijProject");
            ComponentManager $this$service$iv = (ComponentManager)intellijProject;
            boolean $i$f$service = false;
            Class<JsonConnectionStringsManager> serviceClass$iv = JsonConnectionStringsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JsonConnectionStringsManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

