/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.features.connections.impl;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.plugins.efcore.EfCoreUiBundle;
import com.jetbrains.rider.plugins.efcore.features.connections.DbConnectionInfo;
import com.jetbrains.rider.plugins.efcore.features.connections.DbConnectionProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/connections/impl/DataGripConnectionProvider;", "Lcom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionProvider;", "intellijProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "generateConnectionString", "", "source", "Lcom/intellij/database/dataSource/LocalDataSource;", "getAvailableConnections", "", "Lcom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionInfo;", "project", "Lcom/jetbrains/rider/model/RdProjectDescriptor;", "Companion", "intellij.rider.plugins.efCore"})
@SourceDebugExtension(value={"SMAP\nDataGripConnectionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataGripConnectionProvider.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/impl/DataGripConnectionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1855#2,2:35\n*S KotlinDebug\n*F\n+ 1 DataGripConnectionProvider.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/impl/DataGripConnectionProvider\n*L\n21#1:35,2\n*E\n"})
public final class DataGripConnectionProvider
implements DbConnectionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project intellijProject;

    public DataGripConnectionProvider(@NotNull Project intellijProject) {
        Intrinsics.checkNotNullParameter((Object)intellijProject, (String)"intellijProject");
        this.intellijProject = intellijProject;
    }

    @Override
    @NotNull
    public List<DbConnectionInfo> getAvailableConnections(@NotNull RdProjectDescriptor project) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List $this$getAvailableConnections_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        List list2 = LocalDataSourceManager.getInstance((Project)this.intellijProject).getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDataSources(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalDataSource it = (LocalDataSource)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            String connString = this.generateConnectionString(it);
            if (connString == null) continue;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            $this$getAvailableConnections_u24lambda_u241.add(new DbConnectionInfo(string, connString, EfCoreUiBundle.INSTANCE.message("source.data.sources", new Object[0]), it.getDbms()));
        }
        return CollectionsKt.build((List)list);
    }

    @NonNls
    private final String generateConnectionString(LocalDataSource source) {
        String string;
        if (Intrinsics.areEqual((Object)source.getDbms(), (Object)Dbms.SQLITE)) {
            String string2 = source.getUrl();
            string = "Data Source=" + (string2 != null ? StringsKt.removePrefix((String)string2, (CharSequence)"jdbc:sqlite:") : null);
        } else {
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/connections/impl/DataGripConnectionProvider$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/efcore/features/connections/impl/DataGripConnectionProvider;", "intellijProject", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.efCore"})
    @SourceDebugExtension(value={"SMAP\nDataGripConnectionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataGripConnectionProvider.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/impl/DataGripConnectionProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,34:1\n31#2,2:35\n*S KotlinDebug\n*F\n+ 1 DataGripConnectionProvider.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/impl/DataGripConnectionProvider$Companion\n*L\n18#1:35,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataGripConnectionProvider getInstance(@NotNull Project intellijProject) {
            Intrinsics.checkNotNullParameter((Object)intellijProject, (String)"intellijProject");
            ComponentManager $this$service$iv = (ComponentManager)intellijProject;
            boolean $i$f$service = false;
            Class<DataGripConnectionProvider> serviceClass$iv = DataGripConnectionProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DataGripConnectionProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

