/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.features.connections;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.plugins.efcore.features.connections.DbConnectionInfo;
import com.jetbrains.rider.plugins.efcore.features.connections.DbConnectionProvider;
import com.jetbrains.rider.plugins.efcore.features.connections.impl.AppSettingsConnectionProvider;
import com.jetbrains.rider.plugins.efcore.features.connections.impl.DataGripConnectionProvider;
import com.jetbrains.rider.plugins.efcore.features.connections.impl.UserSecretsConnectionProvider;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionsCollector;", "", "intellijProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "providers", "", "Lcom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionProvider;", "collect", "Lcom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionInfo;", "projectId", "Ljava/util/UUID;", "Companion", "intellij.rider.plugins.efCore"})
@SourceDebugExtension(value={"SMAP\nDbConnectionsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbConnectionsCollector.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionsCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n766#2:38\n857#2,2:39\n1549#2:41\n1620#2,3:42\n288#2,2:45\n1360#2:47\n1446#2,5:48\n*S KotlinDebug\n*F\n+ 1 DbConnectionsCollector.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionsCollector\n*L\n30#1:38\n30#1:39,2\n31#1:41\n31#1:42,3\n32#1:45,2\n35#1:47\n35#1:48,5\n*E\n"})
public final class DbConnectionsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project intellijProject;
    @NotNull
    private final List<DbConnectionProvider> providers;

    public DbConnectionsCollector(@NotNull Project intellijProject) {
        Intrinsics.checkNotNullParameter((Object)intellijProject, (String)"intellijProject");
        this.intellijProject = intellijProject;
        Object[] objectArray = new DbConnectionProvider[]{AppSettingsConnectionProvider.Companion.getInstance(this.intellijProject), UserSecretsConnectionProvider.Companion.getInstance(this.intellijProject), DataGripConnectionProvider.Companion.getInstance(this.intellijProject)};
        this.providers = CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DbConnectionInfo> collect(@NotNull UUID projectId) {
        void $this$flatMapTo$iv$iv;
        Object v1;
        block5: {
            void $this$firstOrNull$iv;
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            ProjectModelEntity it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            Iterable iterable = WorkspaceModelExtensionsKt.findProjects((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.intellijProject));
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ProjectModelEntity)element$iv$iv;
                boolean bl = false;
                if (!(it.getDescriptor() instanceof RdProjectDescriptor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv = iterator.next();
                it = (ProjectModelEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                RdProjectModelItemDescriptor rdProjectModelItemDescriptor = it.getDescriptor();
                Intrinsics.checkNotNull((Object)rdProjectModelItemDescriptor, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.RdProjectDescriptor");
                collection.add((RdProjectDescriptor)rdProjectModelItemDescriptor);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RdProjectDescriptor it2 = (RdProjectDescriptor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getOriginalGuid(), (Object)projectId)) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        RdProjectDescriptor rdProjectDescriptor = v1;
        if (rdProjectDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        RdProjectDescriptor project = rdProjectDescriptor;
        Iterable $this$flatMap$iv = this.providers;
        boolean $i$f$flatMap = false;
        Iterable $i$f$firstOrNull = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DbConnectionProvider it = (DbConnectionProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getAvailableConnections(project);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionsCollector$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionsCollector;", "intellijProject", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.efCore"})
    @SourceDebugExtension(value={"SMAP\nDbConnectionsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbConnectionsCollector.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionsCollector$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,37:1\n31#2,2:38\n*S KotlinDebug\n*F\n+ 1 DbConnectionsCollector.kt\ncom/jetbrains/rider/plugins/efcore/features/connections/DbConnectionsCollector$Companion\n*L\n18#1:38,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DbConnectionsCollector getInstance(@NotNull Project intellijProject) {
            Intrinsics.checkNotNullParameter((Object)intellijProject, (String)"intellijProject");
            ComponentManager $this$service$iv = (ComponentManager)intellijProject;
            boolean $i$f$service = false;
            Class<DbConnectionsCollector> serviceClass$iv = DbConnectionsCollector.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DbConnectionsCollector)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

