/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.cli.api.models;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/plugins/efcore/cli/api/models/DotnetEfVersion;", "", "major", "", "minor", "patch", "(III)V", "getMajor", "()I", "getMinor", "getPatch", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "intellij.rider.plugins.efCore"})
public final class DotnetEfVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    @NonNls
    @NotNull
    private static final Regex SEMVER_REGEX = new Regex("(\\d+)\\.(\\d+)\\.(\\d+)(?:-([\\dA-Za-z-]+(?:\\.[\\dA-Za-z-]+)*))?(?:\\+[\\dA-Za-z-]+)?");

    public DotnetEfVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @NotNull
    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @NotNull
    public final DotnetEfVersion copy(int major, int minor, int patch) {
        return new DotnetEfVersion(major, minor, patch);
    }

    public static /* synthetic */ DotnetEfVersion copy$default(DotnetEfVersion dotnetEfVersion, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = dotnetEfVersion.major;
        }
        if ((n4 & 2) != 0) {
            n2 = dotnetEfVersion.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = dotnetEfVersion.patch;
        }
        return dotnetEfVersion.copy(n, n2, n3);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = result * 31 + Integer.hashCode(this.minor);
        result = result * 31 + Integer.hashCode(this.patch);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DotnetEfVersion)) {
            return false;
        }
        DotnetEfVersion dotnetEfVersion = (DotnetEfVersion)other;
        if (this.major != dotnetEfVersion.major) {
            return false;
        }
        if (this.minor != dotnetEfVersion.minor) {
            return false;
        }
        return this.patch == dotnetEfVersion.patch;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\nR\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/efcore/cli/api/models/DotnetEfVersion$Companion;", "", "()V", "SEMVER_REGEX", "Lkotlin/text/Regex;", "getSEMVER_REGEX", "()Lkotlin/text/Regex;", "fromStrings", "Lcom/jetbrains/rider/plugins/efcore/cli/api/models/DotnetEfVersion;", "major", "", "minor", "patch", "parse", "version", "intellij.rider.plugins.efCore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getSEMVER_REGEX() {
            return SEMVER_REGEX;
        }

        @Nullable
        public final DotnetEfVersion parse(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            MatchResult matchResult = Regex.find$default((Regex)this.getSEMVER_REGEX(), (CharSequence)version, (int)0, (int)2, null);
            if (matchResult == null) {
                return null;
            }
            MatchResult match = matchResult;
            if (match.getGroups().size() < 3) {
                return null;
            }
            MatchGroup matchGroup = match.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            String string = matchGroup.getValue();
            MatchGroup matchGroup2 = match.getGroups().get(2);
            Intrinsics.checkNotNull((Object)matchGroup2);
            String string2 = matchGroup2.getValue();
            MatchGroup matchGroup3 = match.getGroups().get(3);
            Intrinsics.checkNotNull((Object)matchGroup3);
            return this.fromStrings(string, string2, matchGroup3.getValue());
        }

        private final DotnetEfVersion fromStrings(String major, String minor, String patch) {
            return new DotnetEfVersion(Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(patch));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

