/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.commits;

import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.vcs.log.paint.PaintParameters;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0014J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001cH\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/collaboration/ui/codereview/commits/CommitNodeComponent;", "Ljavax/swing/JComponent;", "()V", "type", "Lcom/intellij/collaboration/ui/codereview/commits/CommitNodeComponent$Type;", "getType", "()Lcom/intellij/collaboration/ui/codereview/commits/CommitNodeComponent$Type;", "setType", "(Lcom/intellij/collaboration/ui/codereview/commits/CommitNodeComponent$Type;)V", "calcLineThickness", "", "rect", "Ljava/awt/Rectangle;", "calcRadius", "", "drawEdge", "", "g", "Ljava/awt/Graphics2D;", "y1", "", "y2", "drawEdgeDown", "drawEdgeUp", "drawNode", "getPreferredSize", "Lcom/intellij/util/ui/JBDimension;", "paintComponent", "Ljava/awt/Graphics;", "Companion", "Type", "intellij.platform.collaborationTools"})
@ApiStatus.Internal
public class CommitNodeComponent
extends JComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Type type = Type.SINGLE;

    public CommitNodeComponent() {
        this.setOpaque(false);
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final void setType(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"<set-?>");
        this.type = type;
    }

    @NotNull
    public JBDimension getPreferredSize() {
        return new JBDimension((int)PaintParameters.getElementWidth((int)22), 22);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle rect = new Rectangle(this.getSize());
        JBInsets.removeFrom((Rectangle)rect, (Insets)this.getInsets());
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fill(new Rectangle2D.Float(rect.x, rect.y, rect.width, rect.height));
        }
        g2.setColor(this.getForeground());
        this.drawNode(g2, rect);
        if (this.type == Type.LAST || this.type == Type.MIDDLE) {
            this.drawEdgeUp(g2, rect);
        }
        if (this.type == Type.FIRST || this.type == Type.MIDDLE) {
            this.drawEdgeDown(g2, rect);
        }
    }

    private final void drawNode(Graphics2D g, Rectangle rect) {
        int radius = this.calcRadius(rect);
        Ellipse2D.Double circle = new Ellipse2D.Double(rect.getCenterX() - (double)radius, rect.getCenterY() - (double)radius, (double)radius * 2.0, (double)radius * 2.0);
        g.fill(circle);
    }

    protected int calcRadius(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return (int)PaintParameters.getCircleRadius((int)rect.height);
    }

    private final void drawEdgeUp(Graphics2D g, Rectangle rect) {
        double y1 = 0.0;
        double y2 = rect.getCenterY();
        this.drawEdge(g, rect, y1, y2);
    }

    private final void drawEdgeDown(Graphics2D g, Rectangle rect) {
        double y1 = rect.getCenterY();
        double y2 = rect.getMaxY();
        this.drawEdge(g, rect, y1, y2);
    }

    private final void drawEdge(Graphics2D g, Rectangle rect, double y1, double y2) {
        double x = rect.getCenterX();
        float width = this.calcLineThickness(rect);
        Rectangle2D.Double line = new Rectangle2D.Double(x - (double)(width / (float)2), y1 - 0.5, width, y1 + y2 + 0.5);
        g.fill(line);
    }

    protected float calcLineThickness(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return (float)PaintParameters.getLineThickness((int)rect.height);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/collaboration/ui/codereview/commits/CommitNodeComponent$Companion;", "", "()V", "typeForListItem", "Lcom/intellij/collaboration/ui/codereview/commits/CommitNodeComponent$Type;", "itemIndex", "", "listSize", "intellij.platform.collaborationTools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Type typeForListItem(int itemIndex, int listSize) {
            return listSize <= 1 ? Type.SINGLE : (itemIndex == 0 ? Type.FIRST : (itemIndex == listSize - 1 ? Type.LAST : Type.MIDDLE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/collaboration/ui/codereview/commits/CommitNodeComponent$Type;", "", "(Ljava/lang/String;I)V", "SINGLE", "FIRST", "MIDDLE", "LAST", "intellij.platform.collaborationTools"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type SINGLE = new Type();
        public static final /* enum */ Type FIRST = new Type();
        public static final /* enum */ Type MIDDLE = new Type();
        public static final /* enum */ Type LAST = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value2) {
            return Enum.valueOf(Type.class, value2);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.SINGLE, Type.FIRST, Type.MIDDLE, Type.LAST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

