/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.terminal;

import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.pty.PtyProcessTtyConnector;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jediterm.terminal.TtyConnector;
import com.jetbrains.rd.platform.util.ReenterabilityKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdserver.CodeWithMePluginBundle;
import com.jetbrains.rdserver.terminal.BackendTerminalHost;
import com.jetbrains.rdserver.terminal.BackendTerminalManager;
import com.jetbrains.rdserver.terminal.BackendTerminalRunner;
import com.jetbrains.rdserver.terminal.BackendTerminalRunnerKt;
import com.jetbrains.rdserver.terminal.BackendTtyConnector;
import com.jetbrains.rdserver.terminal.ExtensionsKt;
import com.pty4j.PtyProcess;
import com.pty4j.unix.UnixPtyProcess;
import java.awt.Dimension;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalBlockTerminalRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdserver/terminal/BackendTerminalRunner;", "Lorg/jetbrains/plugins/terminal/LocalBlockTerminalRunner;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createShellTerminalWidget", "Lcom/intellij/terminal/ui/TerminalWidget;", "parent", "Lcom/intellij/openapi/Disposable;", "startupOptions", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "createTtyConnector", "Lcom/jediterm/terminal/TtyConnector;", "process", "Lcom/pty4j/PtyProcess;", "isBlockTerminalEnabled", "", "shareTerminalIfNeeded", "", "terminalWidget", "shouldShowPromotion", "intellij.terminal.backend.split"})
public class BackendTerminalRunner
extends LocalBlockTerminalRunner {
    public BackendTerminalRunner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    protected TerminalWidget createShellTerminalWidget(@NotNull Disposable parent, @NotNull ShellStartupOptions startupOptions) {
        TerminalWidget terminalWidget;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)startupOptions, (String)"startupOptions");
        TerminalWidget terminalWidget2 = terminalWidget = super.createShellTerminalWidget(parent, startupOptions);
        boolean bl = false;
        this.shareTerminalIfNeeded(terminalWidget2);
        return terminalWidget;
    }

    private final void shareTerminalIfNeeded(TerminalWidget terminalWidget) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BackendTerminalManager backendTerminalManager = BackendTerminalManager.Companion.getInstance(project);
        ReenterabilityKt.noReenter((Object)backendTerminalManager.getTerminalCreationInProcess(), (Function0)((Function0)new Function0<Unit>(backendTerminalManager, terminalWidget){
            final /* synthetic */ BackendTerminalManager $backendTerminalManager;
            final /* synthetic */ TerminalWidget $terminalWidget;
            {
                this.$backendTerminalManager = $backendTerminalManager;
                this.$terminalWidget = $terminalWidget;
                super(0);
            }

            public final void invoke() {
                long l = 60146435454410L;
                if (ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication()).isController()) {
                    String string = BackendTerminalManager.Companion.createSessionId();
                    this.$backendTerminalManager.shareTerminal(this.$terminalWidget, string);
                }
            }
        }));
    }

    @NotNull
    public TtyConnector createTtyConnector(@NotNull PtyProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Charset charset = this.myDefaultCharset;
        objectRef.element = new BackendTtyConnector(project, (TtyConnector)new PtyProcessTtyConnector(process, this, (Ref.ObjectRef<BackendTtyConnector>)objectRef, charset){
            final /* synthetic */ PtyProcess $process;
            final /* synthetic */ BackendTerminalRunner this$0;
            final /* synthetic */ Ref.ObjectRef<BackendTtyConnector> $backendConnector;
            {
                this.$process = $process;
                this.this$0 = $receiver;
                this.$backendConnector = $backendConnector;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($process, $super_call_param$1, null, 4, null);
            }

            @NotNull
            public String getName() {
                String string;
                block18: {
                    boolean bl;
                    block21: {
                        block19: {
                            block22: {
                                Object object;
                                String string2;
                                block20: {
                                    Object object2;
                                    block16: {
                                        block17: {
                                            long l = 25528908193359L;
                                            string2 = BackendTerminalHost.j();
                                            try {
                                                try {
                                                    Project project = BackendTerminalRunner.access$getProject(this.this$0);
                                                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"access$getProject(...)");
                                                    object2 = (Boolean)UserManager.Companion.getInstance(project).getHasGuests().getValue();
                                                    if (string2 == null) break block16;
                                                    if (((Boolean)object2).booleanValue()) break block17;
                                                }
                                                catch (IllegalStateException illegalStateException) {
                                                    throw createTtyConnector.1.a(illegalStateException);
                                                }
                                                string = CodeWithMePluginBundle.INSTANCE.getMessage("terminal.tabName.local", new Object[0]);
                                                break block18;
                                            }
                                            catch (IllegalStateException illegalStateException) {
                                                throw createTtyConnector.1.a(illegalStateException);
                                            }
                                        }
                                        object2 = this.$backendConnector.element;
                                    }
                                    try {
                                        Property<Boolean> property;
                                        try {
                                            try {
                                                property = (Property<Boolean>)object2;
                                                if (property == null) break block19;
                                                object = property.getShared();
                                                if (string2 == null) break block20;
                                            }
                                            catch (IllegalStateException illegalStateException) {
                                                throw createTtyConnector.1.a(illegalStateException);
                                            }
                                            property = object;
                                            if (object == null) break block19;
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            throw createTtyConnector.1.a(illegalStateException);
                                        }
                                        object = property.getValue();
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        throw createTtyConnector.1.a(illegalStateException);
                                    }
                                }
                                try {
                                    try {
                                        bl = (Boolean)object;
                                        if (string2 == null) break block21;
                                        if (!bl) break block22;
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        throw createTtyConnector.1.a(illegalStateException);
                                    }
                                    bl = true;
                                    break block21;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw createTtyConnector.1.a(illegalStateException);
                                }
                            }
                            bl = false;
                            break block21;
                        }
                        bl = false;
                    }
                    try {
                        string = bl ? CodeWithMePluginBundle.INSTANCE.getMessage("terminal.tabName.local.shared", new Object[0]) : CodeWithMePluginBundle.INSTANCE.getMessage("terminal.tabName.local.private", new Object[0]);
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw createTtyConnector.1.a(illegalStateException);
                    }
                }
                return string;
            }

            public void close() {
                block8: {
                    PtyProcess ptyProcess;
                    block6: {
                        long l = 59983889233215L;
                        String string = BackendTerminalHost.j();
                        try {
                            block7: {
                                try {
                                    try {
                                        ptyProcess = this.$process;
                                        if (string == null) break block6;
                                        if (!(ptyProcess instanceof UnixPtyProcess)) break block7;
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        throw createTtyConnector.1.a(illegalStateException);
                                    }
                                    ((UnixPtyProcess)this.$process).hangup();
                                    AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> createTtyConnector.1.close$lambda$0(this.$process), 1000L, TimeUnit.MILLISECONDS);
                                    if (string != null) break block8;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw createTtyConnector.1.a(illegalStateException);
                                }
                            }
                            ptyProcess = this.$process;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw createTtyConnector.1.a(illegalStateException);
                        }
                    }
                    ptyProcess.destroy();
                }
            }

            public void resize(@NotNull Dimension termWinSize) {
                block4: {
                    block5: {
                        long l = 134710643116244L;
                        String string = BackendTerminalHost.j();
                        Intrinsics.checkNotNullParameter((Object)termWinSize, (String)"termWinSize");
                        String string2 = string;
                        try {
                            try {
                                if (string2 == null) break block4;
                                if (!BackendTerminalRunnerKt.getLOG().isDebugEnabled()) break block5;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw createTtyConnector.1.a(illegalStateException);
                            }
                            BackendTerminalRunnerKt.getLOG().debug("resize to " + termWinSize);
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw createTtyConnector.1.a(illegalStateException);
                        }
                    }
                    super.resize(termWinSize);
                }
            }

            private static final void close$lambda$0(PtyProcess $process) {
                block5: {
                    PtyProcess ptyProcess;
                    block4: {
                        long l = 60428454811465L;
                        String string = BackendTerminalHost.j();
                        Intrinsics.checkNotNullParameter((Object)$process, (String)"$process");
                        String string2 = string;
                        try {
                            try {
                                ptyProcess = $process;
                                if (string2 == null) break block4;
                                if (!ptyProcess.isAlive()) break block5;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw createTtyConnector.1.a(illegalStateException);
                            }
                            BackendTerminalRunnerKt.getLOG().info("Terminal hasn't been terminated by SIGHUP, performing default termination");
                            ptyProcess = $process;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw createTtyConnector.1.a(illegalStateException);
                        }
                    }
                    ptyProcess.destroy();
                }
            }

            private static IllegalStateException a(IllegalStateException illegalStateException) {
                return illegalStateException;
            }
        });
        return (TtyConnector)objectRef.element;
    }

    protected boolean isBlockTerminalEnabled() {
        boolean bl;
        block8: {
            block7: {
                String string;
                block6: {
                    long l = 14788315023364L;
                    string = BackendTerminalHost.j();
                    try {
                        try {
                            bl = super.isBlockTerminalEnabled();
                            if (string == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw BackendTerminalRunner.a(illegalStateException);
                        }
                        Project project = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        bl = ExtensionsKt.isSharingTerminalActionsAvailable(project);
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw BackendTerminalRunner.a(illegalStateException);
                    }
                }
                try {
                    if (string == null) break block8;
                    if (bl) break block7;
                }
                catch (IllegalStateException illegalStateException) {
                    throw BackendTerminalRunner.a(illegalStateException);
                }
                bl = true;
                break block8;
            }
            bl = false;
        }
        return bl;
    }

    public boolean shouldShowPromotion() {
        boolean bl;
        block8: {
            block7: {
                String string;
                block6: {
                    long l = 107405786821891L;
                    string = BackendTerminalHost.j();
                    try {
                        try {
                            bl = super.shouldShowPromotion();
                            if (string == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw BackendTerminalRunner.a(illegalStateException);
                        }
                        Project project = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        bl = ExtensionsKt.isSharingTerminalActionsAvailable(project);
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw BackendTerminalRunner.a(illegalStateException);
                    }
                }
                try {
                    if (string == null) break block8;
                    if (bl) break block7;
                }
                catch (IllegalStateException illegalStateException) {
                    throw BackendTerminalRunner.a(illegalStateException);
                }
                bl = true;
                break block8;
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ Project access$getProject(BackendTerminalRunner $this) {
        return $this.getProject();
    }

    private static IllegalStateException a(IllegalStateException illegalStateException) {
        return illegalStateException;
    }
}

