/*
 * Decompiled with CFR 0.152.
 */
package me.rafaelldi.aspire.sessionHost;

import com.intellij.database.util.common.MapFun;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.build.BuildParameters;
import com.jetbrains.rider.build.tasks.BuildTaskThrottler;
import com.jetbrains.rider.model.BuildTarget;
import com.jetbrains.rider.model.BuildTargetBase;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import me.rafaelldi.aspire.generated.SessionEnvironmentVariable;
import me.rafaelldi.aspire.generated.SessionModel;
import me.rafaelldi.aspire.run.AspireHostConfig;
import me.rafaelldi.aspire.sessionHost.SessionEvent;
import me.rafaelldi.aspire.sessionHost.SessionLauncher;
import me.rafaelldi.aspire.sessionHost.SessionManager;
import me.rafaelldi.aspire.sessionHost.SessionTerminated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u0000 +2\u00020\u0001:\u0005+,-./B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0017H\u0082@\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0017H\u0002J\u0016\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u001bH\u0082@\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nJ\u001e\u0010!\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u001fH\u0086@\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010%J \u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lme/rafaelldi/aspire/sessionHost/SessionManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "sessions", "", "", "Lme/rafaelldi/aspire/sessionHost/SessionManager$Session;", "resourceToSessionMap", "sessionsUnderRestart", "Ljava/util/concurrent/ConcurrentHashMap;", "", "commands", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lme/rafaelldi/aspire/sessionHost/SessionManager$LaunchSessionCommand;", "handleCommand", "command", "(Lme/rafaelldi/aspire/sessionHost/SessionManager$LaunchSessionCommand;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleCreateCommand", "Lme/rafaelldi/aspire/sessionHost/SessionManager$CreateSessionCommand;", "(Lme/rafaelldi/aspire/sessionHost/SessionManager$CreateSessionCommand;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveConnectionToResource", "handleDeleteCommand", "Lme/rafaelldi/aspire/sessionHost/SessionManager$DeleteSessionCommand;", "(Lme/rafaelldi/aspire/sessionHost/SessionManager$DeleteSessionCommand;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "submitCommand", "isResourceRunning", "", "resourceId", "restartResource", "withDebugger", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopResource", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sessionProcessWasTerminated", "sessionId", "exitCode", "", "text", "Companion", "Session", "LaunchSessionCommand", "CreateSessionCommand", "DeleteSessionCommand", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionManager.kt\nme/rafaelldi/aspire/sessionHost/SessionManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,205:1\n1282#2,2:206\n288#3,2:208\n13#4:210\n*S KotlinDebug\n*F\n+ 1 SessionManager.kt\nme/rafaelldi/aspire/sessionHost/SessionManager\n*L\n84#1:206,2\n86#1:208,2\n31#1:210\n*E\n"})
public final class SessionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, Session> sessions;
    @NotNull
    private final Map<String, String> resourceToSessionMap;
    @NotNull
    private final ConcurrentHashMap<String, Unit> sessionsUnderRestart;
    @NotNull
    private final MutableSharedFlow<LaunchSessionCommand> commands;
    @NotNull
    private static final Logger LOG;

    public SessionManager(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.sessions = new LinkedHashMap();
        this.resourceToSessionMap = new LinkedHashMap();
        this.sessionsUnderRestart = new ConcurrentHashMap();
        BufferOverflow bufferOverflow = BufferOverflow.SUSPEND;
        this.commands = SharedFlowKt.MutableSharedFlow((int)20, (int)100, (BufferOverflow)bufferOverflow);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SessionManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.commands.collect(new FlowCollector(){

                            public final Object emit(LaunchSessionCommand it, Continuation<? super Unit> $completion) {
                                Object object = this$0.handleCommand(it, (Continuation<? super Unit>)$completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object handleCommand(LaunchSessionCommand command, Continuation<? super Unit> $completion) {
        LaunchSessionCommand launchSessionCommand = command;
        if (launchSessionCommand instanceof CreateSessionCommand) {
            Object object = this.handleCreateCommand((CreateSessionCommand)command, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (launchSessionCommand instanceof DeleteSessionCommand) {
            Object object = this.handleDeleteCommand((DeleteSessionCommand)command, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final Object handleCreateCommand(CreateSessionCommand command, Continuation<? super Unit> $completion) {
        LOG.trace("Creating session " + command.getSessionId() + ", " + command.getSessionModel());
        Session session = new Session(command.getSessionId(), command.getSessionModel(), command.getSessionLifetimeDefinition(), new SequentialLifetimes((Lifetime)command.getSessionLifetimeDefinition()), command.getSessionEvents());
        this.sessions.put(command.getSessionId(), session);
        this.saveConnectionToResource(command);
        SessionLauncher launcher = SessionLauncher.Companion.getInstance(this.project);
        LifetimeDefinition processLifetime2 = session.getProcessLifetimes().next();
        Object object = launcher.launchSession(session.getId(), session.getModel(), (Lifetime)processLifetime2, session.getEvents(), command.getAspireHostConfig().getDebuggingMode(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void saveConnectionToResource(CreateSessionCommand command) {
        Object v2;
        block8: {
            boolean $i$f$firstOrNull;
            Object $this$firstOrNull$iv;
            Object object;
            block10: {
                block9: {
                    Object object2;
                    block7: {
                        object = command.getSessionModel().getEnvs();
                        if (object == null) break block9;
                        $this$firstOrNull$iv = object;
                        $i$f$firstOrNull = false;
                        int n = ((SessionEnvironmentVariable[])$this$firstOrNull$iv).length;
                        for (int i = 0; i < n; ++i) {
                            Object element$iv;
                            Object it = element$iv = $this$firstOrNull$iv[i];
                            boolean bl = false;
                            if (!StringsKt.equals((String)it.getKey(), (String)"OTEL_RESOURCE_ATTRIBUTES", (boolean)true)) continue;
                            object2 = element$iv;
                            break block7;
                        }
                        object2 = object = null;
                    }
                    if (object2 != null && (object = object.getValue()) != null) break block10;
                }
                return;
            }
            Object resourceAttributes = object;
            $this$firstOrNull$iv = new String[]{","};
            $this$firstOrNull$iv = StringsKt.split$default((CharSequence)((CharSequence)resourceAttributes), (String[])$this$firstOrNull$iv, (boolean)false, (int)0, (int)6, null);
            $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"service.instance.id", (boolean)false, (int)2, null)) continue;
                v2 = element$iv;
                break block8;
            }
            v2 = null;
        }
        String string = v2;
        if (string == null) {
            return;
        }
        String serviceInstanceId = string;
        String idValue = StringsKt.removePrefix((String)serviceInstanceId, (CharSequence)"service.instance.id=");
        if (((CharSequence)idValue).length() == 0) {
            return;
        }
        LOG.trace("Connection between resource " + idValue + " and session " + command.getSessionId());
        this.resourceToSessionMap.put(idValue, command.getSessionId());
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleDeleteCommand(DeleteSessionCommand var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof handleDeleteCommand.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SessionManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SessionManager.access$handleDeleteCommand(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                SessionManager.LOG.trace("Deleting session " + command.getSessionId());
                MapFun.removeIf(this.resourceToSessionMap, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handleDeleteCommand$lambda$2(me.rafaelldi.aspire.sessionHost.SessionManager$DeleteSessionCommand java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/Boolean;)((DeleteSessionCommand)command));
                this.sessionsUnderRestart.remove(command.getSessionId());
                v0 = this.sessions.remove(command.getSessionId());
                if (v0 == null) {
                    return Unit.INSTANCE;
                }
                session = v0;
                $continuation.L$0 = command;
                $continuation.L$1 = session;
                $continuation.label = 1;
                v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(session, null){
                    int label;
                    final /* synthetic */ Session $session;
                    {
                        this.$session = $session;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return Boxing.boxBoolean((boolean)LifetimeDefinition.terminate$default((LifetimeDefinition)this.$session.getLifetimeDefinition(), (boolean)false, (int)1, null));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl32
            }
            case 1: {
                session = (Session)$continuation.L$1;
                command = (DeleteSessionCommand)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                session.getEvents().tryEmit((Object)new SessionTerminated(command.getSessionId(), 0));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object submitCommand(@NotNull LaunchSessionCommand command, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.commands.emit((Object)command, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final boolean isResourceRunning(@NotNull String resourceId) {
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        String string = this.resourceToSessionMap.get(resourceId);
        if (string == null) {
            return false;
        }
        String sessionId = string;
        Session session = this.sessions.get(sessionId);
        if (session == null) {
            return false;
        }
        Session session2 = session;
        return !RLifetimeKt.isNotAlive((Lifetime)((Lifetime)session2.getLifetimeDefinition()));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object restartResource(@NotNull String var1_1, boolean var2_2, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof restartResource.1)) ** GOTO lbl-1000
        var11_4 = $completion;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ SessionManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.restartResource(null, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                SessionManager.LOG.trace("Restarting resource " + (String)resourceId);
                v0 = this.resourceToSessionMap.get(resourceId);
                if (v0 == null) {
                    return Unit.INSTANCE;
                }
                sessionId = v0;
                v1 = this.sessions.get(sessionId);
                if (v1 == null) {
                    return Unit.INSTANCE;
                }
                session = v1;
                if (RLifetimeKt.isNotAlive((Lifetime)((Lifetime)session.getLifetimeDefinition()))) {
                    return Unit.INSTANCE;
                }
                sessionUnderRestart = this.sessionsUnderRestart.putIfAbsent(sessionId, Unit.INSTANCE);
                if (sessionUnderRestart != null) {
                    return Unit.INSTANCE;
                }
                launcher = SessionLauncher.Companion.getInstance(this.project);
                $continuation.L$0 = this;
                $continuation.L$1 = session;
                $continuation.L$2 = launcher;
                $continuation.Z$0 = withDebugger;
                $continuation.label = 1;
                v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LifetimeDefinition>, Object>(session, null){
                    int label;
                    final /* synthetic */ Session $session;
                    {
                        this.$session = $session;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return this.$session.getProcessLifetimes().next();
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super LifetimeDefinition> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl43
            }
            case 1: {
                withDebugger = $continuation.Z$0;
                launcher = (SessionLauncher)$continuation.L$2;
                session = (Session)$continuation.L$1;
                this = (SessionManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl43:
                // 2 sources

                processLifetime = (LifetimeDefinition)v2;
                buildParameters = new BuildParameters((BuildTargetBase)new BuildTarget(), CollectionsKt.listOf((Object)session.getModel().getProjectPath()), false, true, false, false, false, null, 244, null);
                $continuation.L$0 = session;
                $continuation.L$1 = launcher;
                $continuation.L$2 = processLifetime;
                $continuation.Z$0 = withDebugger;
                $continuation.label = 2;
                v3 = BuildTaskThrottler.buildSequentially$default((BuildTaskThrottler)BuildTaskThrottler.Companion.getInstance(this.project), (BuildParameters)buildParameters, null, (Continuation)$continuation, (int)2, null);
                if (v3 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl61
            }
            case 2: {
                withDebugger = $continuation.Z$0;
                processLifetime = (LifetimeDefinition)$continuation.L$2;
                launcher = (SessionLauncher)$continuation.L$1;
                session = (Session)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl61:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 3;
                v4 = launcher.launchSession(session.getId(), session.getModel(), (Lifetime)processLifetime, session.getEvents(), withDebugger != false, (Continuation<? super Unit>)$continuation);
                if (v4 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl72
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl72:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object stopResource(@NotNull String var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof stopResource.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SessionManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.stopResource(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                SessionManager.LOG.trace("Stopping resource " + (String)resourceId);
                v0 = this.resourceToSessionMap.remove(resourceId);
                if (v0 == null) {
                    return Unit.INSTANCE;
                }
                sessionId = v0;
                this.sessionsUnderRestart.remove(sessionId);
                v1 = this.sessions.remove(sessionId);
                if (v1 == null) {
                    return Unit.INSTANCE;
                }
                session = v1;
                if (RLifetimeKt.isNotAlive((Lifetime)((Lifetime)session.getLifetimeDefinition()))) {
                    return Unit.INSTANCE;
                }
                SessionManager.LOG.trace("Stopping session " + sessionId);
                $continuation.L$0 = sessionId;
                $continuation.L$1 = session;
                $continuation.label = 1;
                v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(session, null){
                    int label;
                    final /* synthetic */ Session $session;
                    {
                        this.$session = $session;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return Boxing.boxBoolean((boolean)LifetimeDefinition.terminate$default((LifetimeDefinition)this.$session.getLifetimeDefinition(), (boolean)false, (int)1, null));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl38
            }
            case 1: {
                session = (Session)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl38:
                // 2 sources

                session.getEvents().tryEmit((Object)new SessionTerminated(sessionId, 0));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void sessionProcessWasTerminated(@NotNull String sessionId, int exitCode, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        LOG.trace("Stopping session " + sessionId + " (" + exitCode + ", " + text + ")");
        Unit sessionUnderRestart = this.sessionsUnderRestart.remove(sessionId);
        if (sessionUnderRestart != null) {
            return;
        }
        MapFun.removeIf(this.resourceToSessionMap, arg_0 -> SessionManager.sessionProcessWasTerminated$lambda$3(sessionId, arg_0));
        Session session = this.sessions.remove(sessionId);
        if (session == null) {
            return;
        }
        Session session2 = session;
        if (RLifetimeKt.isNotAlive((Lifetime)((Lifetime)session2.getLifetimeDefinition()))) {
            return;
        }
        ApplicationKt.getApplication().invokeLater(() -> SessionManager.sessionProcessWasTerminated$lambda$4(session2));
        session2.getEvents().tryEmit((Object)new SessionTerminated(sessionId, exitCode));
    }

    private static final boolean handleDeleteCommand$lambda$2(DeleteSessionCommand $command, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual(it.getValue(), (Object)$command.getSessionId());
    }

    private static final boolean sessionProcessWasTerminated$lambda$3(String $sessionId, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)$sessionId, (String)"$sessionId");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual(it.getValue(), (Object)$sessionId);
    }

    private static final void sessionProcessWasTerminated$lambda$4(Session $session) {
        Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
        LifetimeDefinition.terminate$default((LifetimeDefinition)$session.getLifetimeDefinition(), (boolean)false, (int)1, null);
    }

    public static final /* synthetic */ Object access$handleCreateCommand(SessionManager $this, CreateSessionCommand command, Continuation $completion) {
        return $this.handleCreateCommand(command, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleDeleteCommand(SessionManager $this, DeleteSessionCommand command, Continuation $completion) {
        return $this.handleDeleteCommand(command, (Continuation<? super Unit>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SessionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lme/rafaelldi/aspire/sessionHost/SessionManager$Companion;", "", "<init>", "()V", "getInstance", "Lme/rafaelldi/aspire/sessionHost/SessionManager;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionManager.kt\nme/rafaelldi/aspire/sessionHost/SessionManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,205:1\n31#2,2:206\n*S KotlinDebug\n*F\n+ 1 SessionManager.kt\nme/rafaelldi/aspire/sessionHost/SessionManager$Companion\n*L\n29#1:206,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SessionManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SessionManager> serviceClass$iv = SessionManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SessionManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\fH\u00c6\u0003JA\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lme/rafaelldi/aspire/sessionHost/SessionManager$CreateSessionCommand;", "Lme/rafaelldi/aspire/sessionHost/SessionManager$LaunchSessionCommand;", "sessionId", "", "sessionModel", "Lme/rafaelldi/aspire/generated/SessionModel;", "sessionEvents", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lme/rafaelldi/aspire/sessionHost/SessionEvent;", "aspireHostConfig", "Lme/rafaelldi/aspire/run/AspireHostConfig;", "sessionLifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "<init>", "(Ljava/lang/String;Lme/rafaelldi/aspire/generated/SessionModel;Lkotlinx/coroutines/flow/MutableSharedFlow;Lme/rafaelldi/aspire/run/AspireHostConfig;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "getSessionId", "()Ljava/lang/String;", "getSessionModel", "()Lme/rafaelldi/aspire/generated/SessionModel;", "getSessionEvents", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "getAspireHostConfig", "()Lme/rafaelldi/aspire/run/AspireHostConfig;", "getSessionLifetimeDefinition", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "aspire-plugin"})
    public static final class CreateSessionCommand
    implements LaunchSessionCommand {
        @NotNull
        private final String sessionId;
        @NotNull
        private final SessionModel sessionModel;
        @NotNull
        private final MutableSharedFlow<SessionEvent> sessionEvents;
        @NotNull
        private final AspireHostConfig aspireHostConfig;
        @NotNull
        private final LifetimeDefinition sessionLifetimeDefinition;

        public CreateSessionCommand(@NotNull String sessionId, @NotNull SessionModel sessionModel, @NotNull MutableSharedFlow<SessionEvent> sessionEvents, @NotNull AspireHostConfig aspireHostConfig, @NotNull LifetimeDefinition sessionLifetimeDefinition) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
            Intrinsics.checkNotNullParameter(sessionEvents, (String)"sessionEvents");
            Intrinsics.checkNotNullParameter((Object)aspireHostConfig, (String)"aspireHostConfig");
            Intrinsics.checkNotNullParameter((Object)sessionLifetimeDefinition, (String)"sessionLifetimeDefinition");
            this.sessionId = sessionId;
            this.sessionModel = sessionModel;
            this.sessionEvents = sessionEvents;
            this.aspireHostConfig = aspireHostConfig;
            this.sessionLifetimeDefinition = sessionLifetimeDefinition;
        }

        @NotNull
        public final String getSessionId() {
            return this.sessionId;
        }

        @NotNull
        public final SessionModel getSessionModel() {
            return this.sessionModel;
        }

        @NotNull
        public final MutableSharedFlow<SessionEvent> getSessionEvents() {
            return this.sessionEvents;
        }

        @NotNull
        public final AspireHostConfig getAspireHostConfig() {
            return this.aspireHostConfig;
        }

        @NotNull
        public final LifetimeDefinition getSessionLifetimeDefinition() {
            return this.sessionLifetimeDefinition;
        }

        @NotNull
        public final String component1() {
            return this.sessionId;
        }

        @NotNull
        public final SessionModel component2() {
            return this.sessionModel;
        }

        @NotNull
        public final MutableSharedFlow<SessionEvent> component3() {
            return this.sessionEvents;
        }

        @NotNull
        public final AspireHostConfig component4() {
            return this.aspireHostConfig;
        }

        @NotNull
        public final LifetimeDefinition component5() {
            return this.sessionLifetimeDefinition;
        }

        @NotNull
        public final CreateSessionCommand copy(@NotNull String sessionId, @NotNull SessionModel sessionModel, @NotNull MutableSharedFlow<SessionEvent> sessionEvents, @NotNull AspireHostConfig aspireHostConfig, @NotNull LifetimeDefinition sessionLifetimeDefinition) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
            Intrinsics.checkNotNullParameter(sessionEvents, (String)"sessionEvents");
            Intrinsics.checkNotNullParameter((Object)aspireHostConfig, (String)"aspireHostConfig");
            Intrinsics.checkNotNullParameter((Object)sessionLifetimeDefinition, (String)"sessionLifetimeDefinition");
            return new CreateSessionCommand(sessionId, sessionModel, sessionEvents, aspireHostConfig, sessionLifetimeDefinition);
        }

        public static /* synthetic */ CreateSessionCommand copy$default(CreateSessionCommand createSessionCommand, String string, SessionModel sessionModel, MutableSharedFlow mutableSharedFlow, AspireHostConfig aspireHostConfig, LifetimeDefinition lifetimeDefinition, int n, Object object) {
            if ((n & 1) != 0) {
                string = createSessionCommand.sessionId;
            }
            if ((n & 2) != 0) {
                sessionModel = createSessionCommand.sessionModel;
            }
            if ((n & 4) != 0) {
                mutableSharedFlow = createSessionCommand.sessionEvents;
            }
            if ((n & 8) != 0) {
                aspireHostConfig = createSessionCommand.aspireHostConfig;
            }
            if ((n & 0x10) != 0) {
                lifetimeDefinition = createSessionCommand.sessionLifetimeDefinition;
            }
            return createSessionCommand.copy(string, sessionModel, mutableSharedFlow, aspireHostConfig, lifetimeDefinition);
        }

        @NotNull
        public String toString() {
            return "CreateSessionCommand(sessionId=" + this.sessionId + ", sessionModel=" + this.sessionModel + ", sessionEvents=" + this.sessionEvents + ", aspireHostConfig=" + this.aspireHostConfig + ", sessionLifetimeDefinition=" + this.sessionLifetimeDefinition + ")";
        }

        public int hashCode() {
            int result = this.sessionId.hashCode();
            result = result * 31 + this.sessionModel.hashCode();
            result = result * 31 + this.sessionEvents.hashCode();
            result = result * 31 + this.aspireHostConfig.hashCode();
            result = result * 31 + this.sessionLifetimeDefinition.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CreateSessionCommand)) {
                return false;
            }
            CreateSessionCommand createSessionCommand = (CreateSessionCommand)other;
            if (!Intrinsics.areEqual((Object)this.sessionId, (Object)createSessionCommand.sessionId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sessionModel, (Object)createSessionCommand.sessionModel)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.sessionEvents, createSessionCommand.sessionEvents)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.aspireHostConfig, (Object)createSessionCommand.aspireHostConfig)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sessionLifetimeDefinition, (Object)createSessionCommand.sessionLifetimeDefinition);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lme/rafaelldi/aspire/sessionHost/SessionManager$DeleteSessionCommand;", "Lme/rafaelldi/aspire/sessionHost/SessionManager$LaunchSessionCommand;", "sessionId", "", "<init>", "(Ljava/lang/String;)V", "getSessionId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "aspire-plugin"})
    public static final class DeleteSessionCommand
    implements LaunchSessionCommand {
        @NotNull
        private final String sessionId;

        public DeleteSessionCommand(@NotNull String sessionId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            this.sessionId = sessionId;
        }

        @NotNull
        public final String getSessionId() {
            return this.sessionId;
        }

        @NotNull
        public final String component1() {
            return this.sessionId;
        }

        @NotNull
        public final DeleteSessionCommand copy(@NotNull String sessionId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            return new DeleteSessionCommand(sessionId);
        }

        public static /* synthetic */ DeleteSessionCommand copy$default(DeleteSessionCommand deleteSessionCommand, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = deleteSessionCommand.sessionId;
            }
            return deleteSessionCommand.copy(string);
        }

        @NotNull
        public String toString() {
            return "DeleteSessionCommand(sessionId=" + this.sessionId + ")";
        }

        public int hashCode() {
            return this.sessionId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeleteSessionCommand)) {
                return false;
            }
            DeleteSessionCommand deleteSessionCommand = (DeleteSessionCommand)other;
            return Intrinsics.areEqual((Object)this.sessionId, (Object)deleteSessionCommand.sessionId);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Lme/rafaelldi/aspire/sessionHost/SessionManager$LaunchSessionCommand;", "", "aspire-plugin"})
    public static interface LaunchSessionCommand {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JA\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lme/rafaelldi/aspire/sessionHost/SessionManager$Session;", "", "id", "", "model", "Lme/rafaelldi/aspire/generated/SessionModel;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "processLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "events", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lme/rafaelldi/aspire/sessionHost/SessionEvent;", "<init>", "(Ljava/lang/String;Lme/rafaelldi/aspire/generated/SessionModel;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;Lkotlinx/coroutines/flow/MutableSharedFlow;)V", "getId", "()Ljava/lang/String;", "getModel", "()Lme/rafaelldi/aspire/generated/SessionModel;", "getLifetimeDefinition", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getProcessLifetimes", "()Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "getEvents", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "aspire-plugin"})
    public static final class Session {
        @NotNull
        private final String id;
        @NotNull
        private final SessionModel model;
        @NotNull
        private final LifetimeDefinition lifetimeDefinition;
        @NotNull
        private final SequentialLifetimes processLifetimes;
        @NotNull
        private final MutableSharedFlow<SessionEvent> events;

        public Session(@NotNull String id, @NotNull SessionModel model, @NotNull LifetimeDefinition lifetimeDefinition, @NotNull SequentialLifetimes processLifetimes, @NotNull MutableSharedFlow<SessionEvent> events) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"lifetimeDefinition");
            Intrinsics.checkNotNullParameter((Object)processLifetimes, (String)"processLifetimes");
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.id = id;
            this.model = model;
            this.lifetimeDefinition = lifetimeDefinition;
            this.processLifetimes = processLifetimes;
            this.events = events;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final SessionModel getModel() {
            return this.model;
        }

        @NotNull
        public final LifetimeDefinition getLifetimeDefinition() {
            return this.lifetimeDefinition;
        }

        @NotNull
        public final SequentialLifetimes getProcessLifetimes() {
            return this.processLifetimes;
        }

        @NotNull
        public final MutableSharedFlow<SessionEvent> getEvents() {
            return this.events;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final SessionModel component2() {
            return this.model;
        }

        @NotNull
        public final LifetimeDefinition component3() {
            return this.lifetimeDefinition;
        }

        @NotNull
        public final SequentialLifetimes component4() {
            return this.processLifetimes;
        }

        @NotNull
        public final MutableSharedFlow<SessionEvent> component5() {
            return this.events;
        }

        @NotNull
        public final Session copy(@NotNull String id, @NotNull SessionModel model, @NotNull LifetimeDefinition lifetimeDefinition, @NotNull SequentialLifetimes processLifetimes, @NotNull MutableSharedFlow<SessionEvent> events) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"lifetimeDefinition");
            Intrinsics.checkNotNullParameter((Object)processLifetimes, (String)"processLifetimes");
            Intrinsics.checkNotNullParameter(events, (String)"events");
            return new Session(id, model, lifetimeDefinition, processLifetimes, events);
        }

        public static /* synthetic */ Session copy$default(Session session, String string, SessionModel sessionModel, LifetimeDefinition lifetimeDefinition, SequentialLifetimes sequentialLifetimes, MutableSharedFlow mutableSharedFlow, int n, Object object) {
            if ((n & 1) != 0) {
                string = session.id;
            }
            if ((n & 2) != 0) {
                sessionModel = session.model;
            }
            if ((n & 4) != 0) {
                lifetimeDefinition = session.lifetimeDefinition;
            }
            if ((n & 8) != 0) {
                sequentialLifetimes = session.processLifetimes;
            }
            if ((n & 0x10) != 0) {
                mutableSharedFlow = session.events;
            }
            return session.copy(string, sessionModel, lifetimeDefinition, sequentialLifetimes, mutableSharedFlow);
        }

        @NotNull
        public String toString() {
            return "Session(id=" + this.id + ", model=" + this.model + ", lifetimeDefinition=" + this.lifetimeDefinition + ", processLifetimes=" + this.processLifetimes + ", events=" + this.events + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.model.hashCode();
            result = result * 31 + this.lifetimeDefinition.hashCode();
            result = result * 31 + this.processLifetimes.hashCode();
            result = result * 31 + this.events.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Session)) {
                return false;
            }
            Session session = (Session)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)session.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.model, (Object)session.model)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lifetimeDefinition, (Object)session.lifetimeDefinition)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.processLifetimes, (Object)session.processLifetimes)) {
                return false;
            }
            return Intrinsics.areEqual(this.events, session.events);
        }
    }
}

