/*
 * Decompiled with CFR 0.152.
 */
package me.rafaelldi.aspire.sessionHost;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.runtime.RiderDotNetActiveRuntimeHost;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.rafaelldi.aspire.run.AspireHostConfig;
import me.rafaelldi.aspire.sessionHost.SessionHostLauncher;
import me.rafaelldi.aspire.util.AnsiEscapeDecoderUtilsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/rafaelldi/aspire/sessionHost/SessionHostLauncher;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "Lorg/jetbrains/annotations/NotNull;", "hostAssemblyPath", "Ljava/nio/file/Path;", "launchSessionHost", "", "aspireHostConfig", "Lme/rafaelldi/aspire/run/AspireHostConfig;", "sessionHostRdPort", "", "aspireHostLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "dotnet", "Lcom/jetbrains/rider/runtime/dotNetCore/DotNetCoreRuntime;", "rdPort", "Companion", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nSessionHostLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionHostLauncher.kt\nme/rafaelldi/aspire/sessionHost/SessionHostLauncher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n13#2:113\n*S KotlinDebug\n*F\n+ 1 SessionHostLauncher.kt\nme/rafaelldi/aspire/sessionHost/SessionHostLauncher\n*L\n31#1:113\n*E\n"})
public final class SessionHostLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PluginId pluginId;
    @NotNull
    private final Path hostAssemblyPath;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String RIDER_PARENT_PROCESS_ID = "RIDER_PARENT_PROCESS_ID";
    @NotNull
    private static final String RIDER_RD_PORT = "Rider_Connection__RdPort";
    @NotNull
    private static final String RIDER_RESOURCE_SERVICE_ENDPOINT_URL = "Rider_ResourceService__EndpointUrl";
    @NotNull
    private static final String RIDER_RESOURCE_SERVICE_API_KEY = "Rider_ResourceService__ApiKey";

    /*
     * WARNING - void declaration
     */
    public SessionHostLauncher(@NotNull Project project) {
        void $this$hostAssemblyPath_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        PluginId pluginId = PluginId.getId((String)"me.rafaelldi.aspire");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        this.pluginId = pluginId;
        SessionHostLauncher sessionHostLauncher = this;
        SessionHostLauncher sessionHostLauncher2 = this;
        boolean bl = false;
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)$this$hostAssemblyPath_u24lambda_u240.pluginId);
        if (ideaPluginDescriptor == null) {
            throw new IllegalStateException(("Plugin " + $this$hostAssemblyPath_u24lambda_u240.pluginId + " could not be found.").toString());
        }
        IdeaPluginDescriptor plugin = ideaPluginDescriptor;
        Path path = plugin.getPluginPath();
        if (path == null) {
            throw new IllegalStateException(("Could not detect path of plugin " + plugin + " on disk.").toString());
        }
        Path basePath = path;
        Path path2 = basePath.resolve("aspire-session-host");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = path2.resolve("aspire-session-host.dll");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        sessionHostLauncher2.hostAssemblyPath = path3;
    }

    public final void launchSessionHost(@NotNull AspireHostConfig aspireHostConfig, int sessionHostRdPort, @NotNull LifetimeDefinition aspireHostLifetime) {
        Intrinsics.checkNotNullParameter((Object)aspireHostConfig, (String)"aspireHostConfig");
        Intrinsics.checkNotNullParameter((Object)aspireHostLifetime, (String)"aspireHostLifetime");
        LOG.info("Starting Aspire session host");
        DotNetCoreRuntime dotNetCoreRuntime = (DotNetCoreRuntime)RiderDotNetActiveRuntimeHost.Companion.getInstance(this.project).getDotNetCoreRuntime().getValue();
        if (dotNetCoreRuntime == null) {
            throw new CantRunException("Cannot find active .NET runtime");
        }
        DotNetCoreRuntime dotnet = dotNetCoreRuntime;
        GeneralCommandLine commandLine = this.getCommandLine(dotnet, aspireHostConfig, sessionHostRdPort);
        LOG.trace("Host command line: " + commandLine.getCommandLineString());
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine);
        aspireHostLifetime.onTermination(() -> SessionHostLauncher.launchSessionHost$lambda$1(processHandler));
        processHandler.addProcessListener(new ProcessListener(aspireHostLifetime){
            final /* synthetic */ LifetimeDefinition $aspireHostLifetime;
            {
                this.$aspireHostLifetime = $aspireHostLifetime;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String text = AnsiEscapeDecoderUtilsKt.decodeAnsiCommandsToString(string, outputType);
                if (Intrinsics.areEqual(outputType, (Object)ProcessOutputType.STDERR)) {
                    SessionHostLauncher.access$getLOG$cp().error(text);
                } else {
                    SessionHostLauncher.access$getLOG$cp().debug(text);
                }
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$aspireHostLifetime.executeIfAlive(() -> launchSessionHost.2.processTerminated$lambda$0(this.$aspireHostLifetime));
            }

            private static final boolean processTerminated$lambda$0(LifetimeDefinition $aspireHostLifetime) {
                Intrinsics.checkNotNullParameter((Object)$aspireHostLifetime, (String)"$aspireHostLifetime");
                SessionHostLauncher.access$getLOG$cp().trace("Terminating Aspire session host lifetime");
                return $aspireHostLifetime.terminate(true);
            }
        }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)aspireHostLifetime), null, (int)1, null));
        processHandler.startNotify();
        LOG.trace("Aspire session host started");
    }

    /*
     * WARNING - void declaration
     */
    private final GeneralCommandLine getCommandLine(DotNetCoreRuntime dotnet, AspireHostConfig aspireHostConfig, int rdPort) {
        void $this$getCommandLine_u24lambda_u242;
        Object object = new String[]{((Object)this.hostAssemblyPath).toString()};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(dotnet.getCliExePath()).withCharset(StandardCharsets.UTF_8).withParameters(object).withWorkDirectory(this.hostAssemblyPath.getParent().toFile());
        Object object2 = object = MapsKt.createMapBuilder();
        GeneralCommandLine generalCommandLine2 = generalCommandLine;
        boolean bl = false;
        $this$getCommandLine_u24lambda_u242.put("Kestrel__Endpoints__Http__Url", "http://localhost:" + aspireHostConfig.getDebugSessionPort() + "/");
        $this$getCommandLine_u24lambda_u242.put(RIDER_RD_PORT, String.valueOf(rdPort));
        $this$getCommandLine_u24lambda_u242.put(RIDER_PARENT_PROCESS_ID, String.valueOf(ProcessHandle.current().pid()));
        if (aspireHostConfig.getResourceServiceEndpointUrl() != null) {
            $this$getCommandLine_u24lambda_u242.put(RIDER_RESOURCE_SERVICE_ENDPOINT_URL, aspireHostConfig.getResourceServiceEndpointUrl());
        }
        if (aspireHostConfig.getResourceServiceApiKey() != null) {
            $this$getCommandLine_u24lambda_u242.put(RIDER_RESOURCE_SERVICE_API_KEY, aspireHostConfig.getResourceServiceApiKey());
        }
        GeneralCommandLine generalCommandLine3 = generalCommandLine2.withEnvironment(MapsKt.build((Map)object));
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine3, (String)"withEnvironment(...)");
        GeneralCommandLine commandLine = generalCommandLine3;
        return commandLine;
    }

    private static final Unit launchSessionHost$lambda$1(KillableColoredProcessHandler $processHandler) {
        Intrinsics.checkNotNullParameter((Object)$processHandler, (String)"$processHandler");
        if (!$processHandler.isProcessTerminating() && !$processHandler.isProcessTerminated()) {
            LOG.trace("Killing Aspire session host process");
            $processHandler.killProcess();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SessionHostLauncher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/rafaelldi/aspire/sessionHost/SessionHostLauncher$Companion;", "", "<init>", "()V", "getInstance", "Lme/rafaelldi/aspire/sessionHost/SessionHostLauncher;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "RIDER_PARENT_PROCESS_ID", "", "RIDER_RD_PORT", "RIDER_RESOURCE_SERVICE_ENDPOINT_URL", "RIDER_RESOURCE_SERVICE_API_KEY", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nSessionHostLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionHostLauncher.kt\nme/rafaelldi/aspire/sessionHost/SessionHostLauncher$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,112:1\n31#2,2:113\n*S KotlinDebug\n*F\n+ 1 SessionHostLauncher.kt\nme/rafaelldi/aspire/sessionHost/SessionHostLauncher$Companion\n*L\n29#1:113,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SessionHostLauncher getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SessionHostLauncher> serviceClass$iv = SessionHostLauncher.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SessionHostLauncher)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

