/*
 * Decompiled with CFR 0.152.
 */
package me.rafaelldi.aspire.services.components;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ExtensionsKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.LocalDateTime;
import me.rafaelldi.aspire.AspireBundle;
import me.rafaelldi.aspire.generated.ResourceEnvironmentVariable;
import me.rafaelldi.aspire.generated.ResourceState;
import me.rafaelldi.aspire.generated.ResourceType;
import me.rafaelldi.aspire.generated.ResourceUrl;
import me.rafaelldi.aspire.services.AspireResourceService;
import me.rafaelldi.aspire.services.components.RowExtensionsKt;
import me.rafaelldi.aspire.util.AspireResourceUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lme/rafaelldi/aspire/services/components/ResourceDashboardPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "resourceService", "Lme/rafaelldi/aspire/services/AspireResourceService;", "<init>", "(Lme/rafaelldi/aspire/services/AspireResourceService;)V", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "setUpPanel", "resourceData", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nResourceDashboardPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceDashboardPanel.kt\nme/rafaelldi/aspire/services/components/ResourceDashboardPanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n6442#2:154\n13309#2,2:157\n1855#3,2:155\n*S KotlinDebug\n*F\n+ 1 ResourceDashboardPanel.kt\nme/rafaelldi/aspire/services/components/ResourceDashboardPanel\n*L\n83#1:154\n146#1:157,2\n84#1:155,2\n*E\n"})
public final class ResourceDashboardPanel
extends BorderLayoutPanel {
    @NotNull
    private DialogPanel panel;

    public ResourceDashboardPanel(@NotNull AspireResourceService resourceService) {
        Intrinsics.checkNotNullParameter((Object)resourceService, (String)"resourceService");
        this.panel = this.setUpPanel(resourceService);
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
        this.add(ScrollPaneFactory.createScrollPane((Component)((Component)this.panel), (int)0));
    }

    private final DialogPanel setUpPanel(AspireResourceService resourceData) {
        return BuilderKt.panel(arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39(resourceData, arg_0));
    }

    private static final Unit setUpPanel$lambda$39$lambda$3(AspireResourceService $resourceData, Row $this$row) {
        ResourceState state;
        Object it;
        Intrinsics.checkNotNullParameter((Object)$resourceData, (String)"$resourceData");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon resourceIcon = AspireResourceUtilsKt.getIcon($resourceData.getType(), $resourceData.getState());
        $this$row.icon(resourceIcon).gap(RightGap.SMALL);
        RowExtensionsKt.copyableLabel$default($this$row, $resourceData.getDisplayName(), null, null, 6, null).bold().gap(RightGap.SMALL);
        if ($resourceData.getType() == ResourceType.Project) {
            Path path = $resourceData.getProjectPath();
            if (path != null) {
                it = path;
                boolean bl = false;
                RowExtensionsKt.copyableLabel$default($this$row, ((Object)it.getFileName()).toString(), null, UIUtil.FontColor.BRIGHTER, 2, null).gap(RightGap.SMALL);
            }
        }
        if ($resourceData.getType() == ResourceType.Container) {
            String string = $resourceData.getContainerImage();
            if (string != null) {
                it = string;
                boolean bl = false;
                RowExtensionsKt.copyableLabel$default($this$row, (String)it, null, UIUtil.FontColor.BRIGHTER, 2, null).gap(RightGap.SMALL);
            }
        }
        if ($resourceData.getType() == ResourceType.Executable) {
            Path path = $resourceData.getExecutablePath();
            if (path != null) {
                it = path;
                boolean bl = false;
                RowExtensionsKt.copyableLabel$default($this$row, ((Object)it.getFileName()).toString(), null, UIUtil.FontColor.BRIGHTER, 2, null).gap(RightGap.SMALL);
            }
        }
        if ((state = $resourceData.getState()) != null) {
            RowExtensionsKt.separator($this$row).gap(RightGap.SMALL);
            RowExtensionsKt.copyableLabel$default($this$row, state.name(), null, UIUtil.FontColor.BRIGHTER, 2, null).gap(RightGap.COLUMNS);
        }
        if ($resourceData.getType() == ResourceType.Project) {
            AnAction restartAction = ActionManager.getInstance().getAction("Aspire.Resource.Restart");
            Intrinsics.checkNotNull((Object)restartAction);
            ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)restartAction, null, (int)2, null);
            AnAction restartDebugAction = ActionManager.getInstance().getAction("Aspire.Resource.Restart.Debug");
            Intrinsics.checkNotNull((Object)restartDebugAction);
            ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)restartDebugAction, null, (int)2, null);
            AnAction stopAction = ActionManager.getInstance().getAction("Aspire.Resource.Stop");
            Intrinsics.checkNotNull((Object)stopAction);
            ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)stopAction, null, (int)2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$4(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(AspireBundle.message("service.tab.dashboard.endpoints", new Object[0])).bold();
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$8$lambda$7$lambda$6(ResourceUrl $url, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BrowserUtil.browse((String)$url.getFullUrl());
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$8$lambda$7(ResourceUrl $url, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.link($url.getFullUrl(), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$8$lambda$7$lambda$6($url, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$9(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(AspireBundle.message("service.tab.dashboard.properties", new Object[0])).bold();
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$11$lambda$10(ResourceState $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)((Object)$it), (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it.name(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$13$lambda$12(LocalDateTime $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it.toString(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$15$lambda$14(int $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, String.valueOf($it), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$17$lambda$16(int $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, String.valueOf($it), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$19$lambda$18(Path $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, ((Object)$it.toAbsolutePath()).toString(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$21$lambda$20(Path $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, ((Object)$it.toAbsolutePath()).toString(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$23$lambda$22(Path $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, ((Object)$it.toAbsolutePath()).toString(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$25$lambda$24(String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$27$lambda$26(String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$29$lambda$28(String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$31$lambda$30(String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$33$lambda$32(String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$35$lambda$34(String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RowExtensionsKt.copyableLabel$default($this$row, $it, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$36(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(AspireBundle.message("service.tab.dashboard.environment", new Object[0])).bold();
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39$lambda$38$lambda$37(ResourceEnvironmentVariable $variable, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$variable, (String)"$variable");
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = $variable.getKey();
        String string2 = $variable.getValue();
        if (string2 == null) {
            string2 = "-";
        }
        RowExtensionsKt.copyableLabel$default($this$row, string + " = " + string2, null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit setUpPanel$lambda$39(AspireResourceService $resourceData, Panel $this$panel) {
        ResourceState it;
        boolean $i$f$forEach;
        ResourceEnvironmentVariable[] $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$resourceData, (String)"$resourceData");
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$3($resourceData, arg_0), (int)1, null);
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        if (!($resourceData.getUrls().length == 0)) {
            Panel.row$default((Panel)$this$panel, null, ResourceDashboardPanel::setUpPanel$lambda$39$lambda$4, (int)1, null).bottomGap(BottomGap.SMALL);
            Object[] $this$sortedBy$iv = $resourceData.getUrls();
            boolean $i$f$sortedBy = false;
            $this$forEach$iv = (ResourceEnvironmentVariable[])ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ResourceUrl it = (ResourceUrl)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (ResourceUrl)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
            $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                ResourceUrl url = (ResourceUrl)t;
                boolean bl = false;
                if (url.isInternal()) continue;
                $this$panel.row(url.getName(), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$8$lambda$7(url, arg_0));
            }
            Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        }
        Panel.row$default((Panel)$this$panel, null, ResourceDashboardPanel::setUpPanel$lambda$39$lambda$9, (int)1, null).bottomGap(BottomGap.SMALL);
        ResourceState resourceState = $resourceData.getState();
        if (resourceState != null) {
            it = resourceState;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.state", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$11$lambda$10(it, arg_0));
        }
        LocalDateTime localDateTime = $resourceData.getStartTime();
        if (localDateTime != null) {
            it = localDateTime;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.start.time", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$13$lambda$12((LocalDateTime)it, arg_0));
        }
        Integer n = $resourceData.getPid();
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.pid", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$15$lambda$14(it2, arg_0));
        }
        Integer n2 = $resourceData.getExitCode();
        if (n2 != null) {
            int it3 = ((Number)n2).intValue();
            boolean bl = false;
            if (it3 != -1) {
                $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.exit.code", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$17$lambda$16(it3, arg_0));
            }
        }
        Path path = $resourceData.getProjectPath();
        if (path != null) {
            Path it4 = path;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.project", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$19$lambda$18(it4, arg_0));
        }
        Path path2 = $resourceData.getExecutablePath();
        if (path2 != null) {
            Path it5 = path2;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.executable", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$21$lambda$20(it5, arg_0));
        }
        Path path3 = $resourceData.getExecutableWorkDir();
        if (path3 != null) {
            Path it6 = path3;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.working.dir", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$23$lambda$22(it6, arg_0));
        }
        String string = $resourceData.getArgs();
        if (string != null) {
            String it7 = string;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.args", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$25$lambda$24(it7, arg_0));
        }
        String string2 = $resourceData.getContainerImage();
        if (string2 != null) {
            String it8 = string2;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.container.image", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$27$lambda$26(it8, arg_0));
        }
        String string3 = $resourceData.getContainerId();
        if (string3 != null) {
            String it9 = string3;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.container.id", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$29$lambda$28(it9, arg_0));
        }
        String string4 = $resourceData.getContainerPorts();
        if (string4 != null) {
            String it10 = string4;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.container.ports", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$31$lambda$30(it10, arg_0));
        }
        String string5 = $resourceData.getContainerCommand();
        if (string5 != null) {
            String it11 = string5;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.container.command", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$33$lambda$32(it11, arg_0));
        }
        String string6 = $resourceData.getContainerArgs();
        if (string6 != null) {
            String it12 = string6;
            boolean bl = false;
            $this$panel.row(AspireBundle.message("service.tab.dashboard.properties.container.args", new Object[0]), arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$35$lambda$34(it12, arg_0));
        }
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        if (!($resourceData.getEnvironment().length == 0)) {
            Panel.row$default((Panel)$this$panel, null, ResourceDashboardPanel::setUpPanel$lambda$39$lambda$36, (int)1, null).bottomGap(BottomGap.SMALL);
            $this$forEach$iv = $resourceData.getEnvironment();
            $i$f$forEach = false;
            int n3 = $this$forEach$iv.length;
            for (int i = 0; i < n3; ++i) {
                ResourceEnvironmentVariable element$iv;
                ResourceEnvironmentVariable variable = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Panel.row$default((Panel)$this$panel, null, arg_0 -> ResourceDashboardPanel.setUpPanel$lambda$39$lambda$38$lambda$37(variable, arg_0), (int)1, null);
            }
        }
        return Unit.INSTANCE;
    }
}

