/*
 * Decompiled with CFR 0.152.
 */
package me.rafaelldi.aspire.services;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import me.rafaelldi.aspire.generated.AspireSessionHostModel;
import me.rafaelldi.aspire.generated.ResourceState;
import me.rafaelldi.aspire.generated.ResourceType;
import me.rafaelldi.aspire.generated.ResourceWrapper;
import me.rafaelldi.aspire.run.AspireHostConfig;
import me.rafaelldi.aspire.run.AspireHostConfiguration;
import me.rafaelldi.aspire.run.AspireHostConfigurationParameters;
import me.rafaelldi.aspire.services.AspireHostService;
import me.rafaelldi.aspire.services.AspireResourceService;
import me.rafaelldi.aspire.services.AspireServiceContributor;
import me.rafaelldi.aspire.services.AspireServiceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 /2\u00020\u0001:\u0002/0B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\r\u001a\r\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\u000f0\u000eJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\bJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\bJ\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0086@\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0002J(\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\tH\u0002J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u00061"}, d2={"Lme/rafaelldi/aspire/services/AspireServiceManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "hostServices", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lme/rafaelldi/aspire/services/AspireHostService;", "resourceServices", "", "Lme/rafaelldi/aspire/services/AspireResourceService;", "getHostServices", "", "Lkotlin/jvm/internal/EnhancedNullability;", "getHostService", "hostPath", "getResourceServices", "serviceEventPublisher", "Lcom/intellij/execution/services/ServiceEventListener;", "kotlin.jvm.PlatformType", "Lcom/intellij/execution/services/ServiceEventListener;", "addAspireHostService", "", "host", "removeAspireHostService", "Ljava/nio/file/Path;", "updateAspireHostService", "name", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "startAspireHostService", "aspireHostConfig", "Lme/rafaelldi/aspire/run/AspireHostConfig;", "sessionHostModel", "Lme/rafaelldi/aspire/generated/AspireSessionHostModel;", "(Lme/rafaelldi/aspire/run/AspireHostConfig;Lme/rafaelldi/aspire/generated/AspireSessionHostModel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendServiceChangedEvent", "viewResource", "resourceId", "resource", "Lme/rafaelldi/aspire/generated/ResourceWrapper;", "resourceLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "hostService", "sendServiceStructureChangedEvent", "Companion", "Listener", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nAspireServiceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireServiceManager.kt\nme/rafaelldi/aspire/services/AspireServiceManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,213:1\n603#2:214\n13#3:215\n*S KotlinDebug\n*F\n+ 1 AspireServiceManager.kt\nme/rafaelldi/aspire/services/AspireServiceManager\n*L\n48#1:214\n35#1:215\n*E\n"})
public final class AspireServiceManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, AspireHostService> hostServices;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, AspireResourceService>> resourceServices;
    private final ServiceEventListener serviceEventPublisher;
    @NotNull
    private static final Logger LOG;

    public AspireServiceManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.hostServices = new ConcurrentHashMap();
        this.resourceServices = new ConcurrentHashMap();
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ServiceEventListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        this.serviceEventPublisher = (ServiceEventListener)messageBus.syncPublisher(topic);
    }

    @NotNull
    public final List<AspireHostService> getHostServices() {
        Collection<AspireHostService> collection = this.hostServices.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    @Nullable
    public final AspireHostService getHostService(@NotNull String hostPath) {
        Intrinsics.checkNotNullParameter((Object)hostPath, (String)"hostPath");
        return this.hostServices.get(hostPath);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<AspireResourceService> getResourceServices(@NotNull String hostPath) {
        List list;
        Sequence sequence;
        Sequence sequence2;
        Sequence sequence3;
        Collection<AspireResourceService> collection;
        Intrinsics.checkNotNullParameter((Object)hostPath, (String)"hostPath");
        Map<String, AspireResourceService> map = this.resourceServices.get(hostPath);
        if (map != null && (collection = map.values()) != null && (sequence3 = CollectionsKt.asSequence((Iterable)collection)) != null && (sequence2 = SequencesKt.filter((Sequence)sequence3, AspireServiceManager::getResourceServices$lambda$0)) != null && (sequence = SequencesKt.filter((Sequence)sequence2, AspireServiceManager::getResourceServices$lambda$1)) != null) {
            List list2;
            Sequence sequence4 = sequence;
            boolean $i$f$sortedBy = false;
            Sequence sequence5 = SequencesKt.sortedWith((Sequence)sequence4, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AspireResourceService it = (AspireResourceService)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getType());
                    it = (AspireResourceService)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getType())));
                }
            });
            if (sequence5 != null && (list2 = SequencesKt.toList((Sequence)sequence5)) != null) {
                list = list2;
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    public final void addAspireHostService(@NotNull AspireHostService host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (this.hostServices.containsKey(host.getProjectPathString())) {
            return;
        }
        LOG.trace("Adding a new Aspire host " + host.getProjectPathString());
        ((Map)this.hostServices).put(host.getProjectPathString(), host);
        ((Map)this.resourceServices).put(host.getProjectPathString(), (Map)new LinkedHashMap());
        ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_ADDED, (Object)host, AspireServiceContributor.class);
        this.serviceEventPublisher.handle(event);
    }

    public final void removeAspireHostService(@NotNull Path hostPath) {
        Intrinsics.checkNotNullParameter((Object)hostPath, (String)"hostPath");
        String hostPathString = ((Object)hostPath.toAbsolutePath()).toString();
        LOG.trace("Removing the Aspire host " + hostPathString);
        AspireHostService host = this.hostServices.remove(hostPathString);
        this.resourceServices.remove(hostPathString);
        if (host == null) {
            return;
        }
        ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_REMOVED, (Object)host, AspireServiceContributor.class);
        this.serviceEventPublisher.handle(event);
    }

    public final void updateAspireHostService(@NotNull Path hostPath, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)hostPath, (String)"hostPath");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String hostPathString = ((Object)hostPath.toAbsolutePath()).toString();
        LOG.trace("Updating the Aspire host " + hostPathString);
        AspireHostService aspireHostService = this.hostServices.get(hostPathString);
        if (aspireHostService == null) {
            return;
        }
        AspireHostService host = aspireHostService;
        host.update(name);
        this.sendServiceChangedEvent(host);
    }

    public final void updateAspireHostService(@NotNull Path hostPath, @NotNull ExecutionResult executionResult) {
        Intrinsics.checkNotNullParameter((Object)hostPath, (String)"hostPath");
        Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
        String hostPathString = ((Object)hostPath.toAbsolutePath()).toString();
        LOG.trace("Setting the execution result to the Aspire host " + hostPathString);
        AspireHostService aspireHostService = this.hostServices.get(hostPathString);
        if (aspireHostService == null) {
            return;
        }
        AspireHostService host = aspireHostService;
        host.update(executionResult, this.project);
        this.sendServiceChangedEvent(host);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object startAspireHostService(@NotNull AspireHostConfig var1_1, @NotNull AspireSessionHostModel var2_2, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof startAspireHostService.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ AspireServiceManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startAspireHostService(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                hostPathString = aspireHostConfig.getAspireHostProjectPath().toAbsolutePath().toString();
                AspireServiceManager.LOG.trace("Starting the Aspire Host " + hostPathString);
                aspireHostServiceLifetime = aspireHostConfig.getAspireHostLifetime().createNested();
                v0 = this.hostServices.get(hostPathString);
                if (v0 == null) {
                    return Unit.INSTANCE;
                }
                hostService = v0;
                serviceViewManager = ServiceViewManager.getInstance((Project)this.project);
                $continuation.L$0 = this;
                $continuation.L$1 = aspireHostConfig;
                $continuation.L$2 = sessionHostModel;
                $continuation.L$3 = aspireHostServiceLifetime;
                $continuation.L$4 = hostService;
                $continuation.label = 1;
                v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Promise<Void>>, Object>(serviceViewManager, hostService, null){
                    int label;
                    final /* synthetic */ ServiceViewManager $serviceViewManager;
                    final /* synthetic */ AspireHostService $hostService;
                    {
                        this.$serviceViewManager = $serviceViewManager;
                        this.$hostService = $hostService;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return this.$serviceViewManager.select((Object)this.$hostService, AspireServiceContributor.class, true, true);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Promise<Void>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl38
            }
            case 1: {
                hostService = (AspireHostService)$continuation.L$4;
                aspireHostServiceLifetime = (LifetimeDefinition)$continuation.L$3;
                sessionHostModel = (AspireSessionHostModel)$continuation.L$2;
                aspireHostConfig = (AspireHostConfig)$continuation.L$1;
                this = (AspireServiceManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl38:
                // 2 sources

                aspireHostServiceLifetime.bracketIfAlive((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, startAspireHostService$lambda$3(me.rafaelldi.aspire.services.AspireHostService me.rafaelldi.aspire.run.AspireHostConfig me.rafaelldi.aspire.generated.AspireSessionHostModel com.jetbrains.rd.util.lifetime.LifetimeDefinition me.rafaelldi.aspire.services.AspireServiceManager ), ()Lkotlin/Unit;)((AspireHostService)hostService, (AspireHostConfig)aspireHostConfig, (AspireSessionHostModel)sessionHostModel, (LifetimeDefinition)aspireHostServiceLifetime, (AspireServiceManager)this), (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, startAspireHostService$lambda$4(me.rafaelldi.aspire.services.AspireHostService me.rafaelldi.aspire.services.AspireServiceManager ), ()Lkotlin/Unit;)((AspireHostService)hostService, (AspireServiceManager)this));
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sessionHostModel, aspireHostServiceLifetime, this, hostService, null){
                    int label;
                    final /* synthetic */ AspireSessionHostModel $sessionHostModel;
                    final /* synthetic */ LifetimeDefinition $aspireHostServiceLifetime;
                    final /* synthetic */ AspireServiceManager this$0;
                    final /* synthetic */ AspireHostService $hostService;
                    {
                        this.$sessionHostModel = $sessionHostModel;
                        this.$aspireHostServiceLifetime = $aspireHostServiceLifetime;
                        this.this$0 = $receiver;
                        this.$hostService = $hostService;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.$sessionHostModel.getResources().view((Lifetime)this.$aspireHostServiceLifetime, (arg_0, arg_1, arg_2) -> startAspireHostService.5.invokeSuspend$lambda$0(this.this$0, this.$hostService, arg_0, arg_1, arg_2));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(AspireServiceManager this$0, AspireHostService $hostService, Lifetime resourceLifetime, String resourceId, ResourceWrapper resource) {
                        AspireServiceManager.access$viewResource(this$0, resourceId, resource, resourceLifetime, $hostService);
                        return Unit.INSTANCE;
                    }
                }), (Continuation)$continuation);
                if (v2 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl53
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl53:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void sendServiceChangedEvent(AspireHostService host) {
        ServiceEventListener.ServiceEvent event = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHANGED, (Object)host, AspireServiceContributor.class);
        this.serviceEventPublisher.handle(event);
    }

    private final void viewResource(String resourceId, ResourceWrapper resource, Lifetime resourceLifetime, AspireHostService hostService) {
        LOG.trace("Adding a new resource " + resourceId);
        Map<String, AspireResourceService> map = this.resourceServices.get(hostService.getProjectPathString());
        if (map == null) {
            return;
        }
        Map<String, AspireResourceService> resourcesByHost = map;
        AspireResourceService resourceService = new AspireResourceService(resource, resourceLifetime, hostService, this.project);
        CollectionExKt.addUnique(resourcesByHost, (Lifetime)resourceLifetime, (Object)resourceId, (Object)resourceService);
        ServiceViewManager serviceViewManager = ServiceViewManager.getInstance((Project)this.project);
        ApplicationKt.getApplication().invokeLater(() -> AspireServiceManager.viewResource$lambda$5(serviceViewManager, hostService));
        resource.isInitialized().set((Object)true);
        resourceLifetime.bracketIfAlive(() -> AspireServiceManager.viewResource$lambda$6(this, hostService), () -> AspireServiceManager.viewResource$lambda$7(this, hostService));
    }

    private final void sendServiceStructureChangedEvent(AspireHostService host) {
        ServiceEventListener.ServiceEvent serviceEvent = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_STRUCTURE_CHANGED, (Object)host, AspireServiceContributor.class);
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ServiceEventListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(serviceEvent);
    }

    private static final boolean getResourceServices$lambda$0(AspireResourceService it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType() != ResourceType.Unknown;
    }

    private static final boolean getResourceServices$lambda$1(AspireResourceService it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getState() != ResourceState.Hidden;
    }

    private static final Unit startAspireHostService$lambda$3(AspireHostService $hostService, AspireHostConfig $aspireHostConfig, AspireSessionHostModel $sessionHostModel, LifetimeDefinition $aspireHostServiceLifetime, AspireServiceManager this$0) {
        Intrinsics.checkNotNullParameter((Object)$hostService, (String)"$hostService");
        Intrinsics.checkNotNullParameter((Object)$aspireHostConfig, (String)"$aspireHostConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)$sessionHostModel), (String)"$sessionHostModel");
        Intrinsics.checkNotNullParameter((Object)$aspireHostServiceLifetime, (String)"$aspireHostServiceLifetime");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $hostService.startHost($aspireHostConfig.getAspireHostProjectUrl(), $sessionHostModel, (Lifetime)$aspireHostServiceLifetime);
        this$0.sendServiceChangedEvent($hostService);
        return Unit.INSTANCE;
    }

    private static final Unit startAspireHostService$lambda$4(AspireHostService $hostService, AspireServiceManager this$0) {
        Intrinsics.checkNotNullParameter((Object)$hostService, (String)"$hostService");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $hostService.stopHost();
        this$0.sendServiceChangedEvent($hostService);
        return Unit.INSTANCE;
    }

    private static final void viewResource$lambda$5(ServiceViewManager $serviceViewManager, AspireHostService $hostService) {
        Intrinsics.checkNotNullParameter((Object)$hostService, (String)"$hostService");
        $serviceViewManager.expand((Object)$hostService, AspireServiceContributor.class);
    }

    private static final Unit viewResource$lambda$6(AspireServiceManager this$0, AspireHostService $hostService) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$hostService, (String)"$hostService");
        this$0.sendServiceStructureChangedEvent($hostService);
        return Unit.INSTANCE;
    }

    private static final Unit viewResource$lambda$7(AspireServiceManager this$0, AspireHostService $hostService) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$hostService, (String)"$hostService");
        this$0.sendServiceStructureChangedEvent($hostService);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$viewResource(AspireServiceManager $this, String resourceId, ResourceWrapper resource, Lifetime resourceLifetime, AspireHostService hostService) {
        $this.viewResource(resourceId, resource, resourceLifetime, hostService);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AspireServiceManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lme/rafaelldi/aspire/services/AspireServiceManager$Companion;", "", "<init>", "()V", "getInstance", "Lme/rafaelldi/aspire/services/AspireServiceManager;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nAspireServiceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireServiceManager.kt\nme/rafaelldi/aspire/services/AspireServiceManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,213:1\n31#2,2:214\n*S KotlinDebug\n*F\n+ 1 AspireServiceManager.kt\nme/rafaelldi/aspire/services/AspireServiceManager$Companion\n*L\n33#1:214,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AspireServiceManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<AspireServiceManager> serviceClass$iv = AspireServiceManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AspireServiceManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lme/rafaelldi/aspire/services/AspireServiceManager$Listener;", "Lcom/intellij/execution/RunManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "runConfigurationAdded", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runConfigurationChanged", "runConfigurationRemoved", "aspire-plugin"})
    public static final class Listener
    implements RunManagerListener {
        @NotNull
        private final Project project;

        public Listener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            RunConfiguration configuration = runConfiguration;
            if (!(configuration instanceof AspireHostConfiguration)) {
                return;
            }
            AspireHostConfigurationParameters params = ((AspireHostConfiguration)configuration).getParameters();
            Path path = Paths.get(params.getProjectFilePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path projectPath = path;
            String name = PathsKt.getNameWithoutExtension((Path)projectPath);
            AspireHostService host = new AspireHostService(name, projectPath);
            Companion.getInstance(this.project).addAspireHostService(host);
        }

        public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            RunConfiguration configuration = runConfiguration;
            if (!(configuration instanceof AspireHostConfiguration)) {
                return;
            }
            AspireHostConfigurationParameters params = ((AspireHostConfiguration)configuration).getParameters();
            Path path = Paths.get(params.getProjectFilePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path projectPath = path;
            String name = PathsKt.getNameWithoutExtension((Path)projectPath);
            Companion.getInstance(this.project).updateAspireHostService(projectPath, name);
        }

        public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            RunConfiguration configuration = runConfiguration;
            if (!(configuration instanceof AspireHostConfiguration)) {
                return;
            }
            AspireHostConfigurationParameters params = ((AspireHostConfiguration)configuration).getParameters();
            Path path = Paths.get(params.getProjectFilePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path projectPath = path;
            Companion.getInstance(this.project).removeAspireHostService(projectPath);
        }
    }
}

