/*
 * Decompiled with CFR 0.152.
 */
package me.rafaelldi.aspire.services;

import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.rafaelldi.aspire.AspireBundle;
import me.rafaelldi.aspire.services.AspireResourceService;
import me.rafaelldi.aspire.services.components.ResourceConsolePanel;
import me.rafaelldi.aspire.services.components.ResourceDashboardPanel;
import me.rafaelldi.aspire.util.AspireResourceUtilsKt;
import me.rafaelldi.aspire.util.DataKeysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\u0000H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lme/rafaelldi/aspire/services/AspireResourceServiceViewDescriptor;", "Lcom/intellij/execution/services/ServiceViewDescriptor;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "resourceService", "Lme/rafaelldi/aspire/services/AspireResourceService;", "<init>", "(Lme/rafaelldi/aspire/services/AspireResourceService;)V", "toolbarActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "mainPanel", "Ljavax/swing/JPanel;", "getMainPanel", "()Ljavax/swing/JPanel;", "mainPanel$delegate", "Lkotlin/Lazy;", "getPresentation", "Lcom/intellij/ide/projectView/PresentationData;", "getContentComponent", "getToolbarActions", "getDataProvider", "getData", "", "dataId", "", "aspire-plugin"})
public final class AspireResourceServiceViewDescriptor
implements ServiceViewDescriptor,
DataProvider {
    @NotNull
    private final AspireResourceService resourceService;
    @NotNull
    private final DefaultActionGroup toolbarActions;
    @NotNull
    private final Lazy mainPanel$delegate;

    public AspireResourceServiceViewDescriptor(@NotNull AspireResourceService resourceService) {
        Intrinsics.checkNotNullParameter((Object)resourceService, (String)"resourceService");
        this.resourceService = resourceService;
        AnAction[] anActionArray = new AnAction[]{ActionManager.getInstance().getAction("Aspire.Resource.Stop")};
        this.toolbarActions = new DefaultActionGroup(anActionArray);
        this.mainPanel$delegate = LazyKt.lazy(() -> AspireResourceServiceViewDescriptor.mainPanel_delegate$lambda$1(this));
    }

    private final JPanel getMainPanel() {
        Lazy lazy = this.mainPanel$delegate;
        return (JPanel)lazy.getValue();
    }

    @NotNull
    public PresentationData getPresentation() {
        PresentationData presentationData;
        PresentationData $this$getPresentation_u24lambda_u242 = presentationData = new PresentationData();
        boolean bl = false;
        Icon icon = AspireResourceUtilsKt.getIcon(this.resourceService.getType(), this.resourceService.getState());
        $this$getPresentation_u24lambda_u242.setIcon(icon);
        $this$getPresentation_u24lambda_u242.addText(this.resourceService.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        return presentationData;
    }

    @NotNull
    public JPanel getContentComponent() {
        return this.getMainPanel();
    }

    @NotNull
    public DefaultActionGroup getToolbarActions() {
        return this.toolbarActions;
    }

    @NotNull
    public AspireResourceServiceViewDescriptor getDataProvider() {
        return this;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return DataKeysKt.getASPIRE_RESOURCE_UID().is(dataId) ? this.resourceService.getUid() : (DataKeysKt.getASPIRE_RESOURCE_TYPE().is(dataId) ? this.resourceService.getType() : (DataKeysKt.getASPIRE_RESOURCE_STATE().is(dataId) ? this.resourceService.getState() : null));
    }

    private static final JPanel mainPanel_delegate$lambda$1(AspireResourceServiceViewDescriptor this$0) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JBTabbedPane tabs = new JBTabbedPane();
        tabs.addTab(AspireBundle.INSTANCE.getMessage("service.tab.dashboard", new Object[0]), (Component)((Object)new ResourceDashboardPanel(this$0.resourceService)));
        tabs.addTab(AspireBundle.INSTANCE.getMessage("service.tab.console", new Object[0]), (Component)((Object)new ResourceConsolePanel(this$0.resourceService)));
        JPanel $this$mainPanel_delegate_u24lambda_u241_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$mainPanel_delegate_u24lambda_u241_u24lambda_u240.add((Component)tabs, "Center");
        return jPanel;
    }
}

